/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.AccessController;
import weblogic.cluster.FragmentSocket;
import weblogic.cluster.MulticastFragmentSocket;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

final class FragmentSocketWrapper
implements FragmentSocket,
BeanUpdateListener {
    private static final boolean DEBUG = true;
    private static final int MAX_RECEIVE_RETRIES = 5;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static FragmentSocketWrapper THE_ONE;
    private final String mcastaddr;
    private final String interfaceAddress;
    private final int port;
    private final byte ttl;
    private final long packetDelay;
    private final int bufSize;
    private FragmentSocket sock;
    private String currentMessagingMode;

    static synchronized FragmentSocketWrapper getInstance(String string, String string2, int n, byte by, long l, int n2) throws IOException {
        if (THE_ONE != null) {
            return THE_ONE;
        }
        THE_ONE = new FragmentSocketWrapper(string, string2, n, by, l, n2);
        return THE_ONE;
    }

    private FragmentSocketWrapper(String string, String string2, int n, byte by, long l, int n2) throws IOException {
        this.mcastaddr = string;
        this.interfaceAddress = string2;
        this.port = n;
        this.ttl = by;
        this.packetDelay = l;
        this.bufSize = n2;
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        this.currentMessagingMode = clusterMBean.getClusterMessagingMode();
        this.sock = "unicast".equals(clusterMBean.getClusterMessagingMode()) ? this.getUnicastFragmentSocket() : new MulticastFragmentSocket(string, string2, n, by, l, n2);
        clusterMBean.addBeanUpdateListener(this);
    }

    private FragmentSocket getUnicastFragmentSocket() {
        try {
            Class<?> clazz = Class.forName("weblogic.cluster.messaging.internal.server.UnicastFragmentSocket");
            return (FragmentSocket)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
    }

    public void start() throws IOException {
        this.sock.start();
    }

    public void send(byte[] byArray, int n) throws IOException {
        this.sock.send(byArray, n);
    }

    public int receive(byte[] byArray) throws InterruptedIOException, IOException {
        for (int i = 0; i < 5; ++i) {
            FragmentSocket fragmentSocket = this.sock;
            try {
                return fragmentSocket.receive(byArray);
            }
            catch (IOException iOException) {
                if (fragmentSocket != this.sock) continue;
                throw iOException;
            }
        }
        throw new IOException("unable to receive cluster messages after switching messaging mode");
    }

    public void shutdown() {
        this.sock.shutdown();
    }

    public long getFragmentsSentCount() {
        return this.sock.getFragmentsSentCount();
    }

    public long getFragmentsReceivedCount() {
        return this.sock.getFragmentsReceivedCount();
    }

    public void setPacketDelay(long l) {
        this.sock.setPacketDelay(l);
    }

    public void shutdownPermanent() {
        throw new AssertionError((Object)"shutdownPermanent should not be called on FragmentSocketWrapper!");
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        String string;
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        if (descriptorBean instanceof ClusterMBean && !(string = ((ClusterMBean)descriptorBean).getClusterMessagingMode()).equals(this.currentMessagingMode)) {
            this.switchMessagingMode(string);
        }
    }

    private void switchMessagingMode(String string) {
        this.debug("switching from " + this.currentMessagingMode + " to " + string);
        FragmentSocket fragmentSocket = this.sock;
        try {
            if ("unicast".equals(string)) {
                this.sock = this.getUnicastFragmentSocket();
                this.sock.start();
                this.debug("unicast mode started");
            } else {
                this.sock = new MulticastFragmentSocket(this.mcastaddr, this.interfaceAddress, this.port, this.ttl, this.packetDelay, this.bufSize);
                this.sock.start();
                this.debug("multicast mode started");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.currentMessagingMode = string;
        fragmentSocket.shutdownPermanent();
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    private void debug(String string) {
        System.out.println("[FragmentSocketWrapper] " + string);
    }
}

