/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.cluster.ClusterHelper;
import weblogic.cluster.ClusterService;
import weblogic.cluster.ClusterServices;
import weblogic.cluster.GroupMessage;
import weblogic.common.internal.WLObjectInputStream;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Hex;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class GroupMessageHandlerServlet
extends HttpServlet {
    private static final boolean DEBUG = true;
    public static final String SERVER_NAME = "server-name";
    public static final String SERVER_HASH = "server-hash";
    private static final String SERVER_URI = "/bea_wls_cluster_internal/0056FABC093BDF49C8AE091F74400598";
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final String CURRENT_SERVER_HASH = GroupMessageHandlerServlet.encodeServerHash();
    public static final String CURRENT_SERVER_NAME = ManagementService.getRuntimeAccess(kernelId).getServer().getName();

    private static String encodeServerHash() {
        byte[] byArray = ClusterService.getClusterService().getSecureHash();
        return Hex.asHex((byte[])byArray, (int)byArray.length, (boolean)false);
    }

    private static Object deserialize(InputStream inputStream, int n) throws IOException, ClassNotFoundException {
        byte[] byArray = new byte[n];
        DataIO.readFully((InputStream)inputStream, (byte[])byArray);
        WLObjectInputStream wLObjectInputStream = new WLObjectInputStream((InputStream)new UnsyncByteArrayInputStream(byArray));
        Object object = wLObjectInputStream.readObjectWL();
        wLObjectInputStream.close();
        return object;
    }

    private static byte[] serialize(Object object) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        WLObjectOutputStream wLObjectOutputStream = new WLObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
        wLObjectOutputStream.writeObject(object);
        wLObjectOutputStream.flush();
        byte[] byArray = unsyncByteArrayOutputStream.toByteArray();
        wLObjectOutputStream.close();
        return byArray;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object2;
        String string = httpServletRequest.getParameter(SERVER_NAME);
        String string2 = httpServletRequest.getParameter(SERVER_HASH);
        if (!httpServletRequest.getMethod().equals("POST") || httpServletRequest.getContentLength() <= 0 || string == null || string2 == null) {
            httpServletResponse.sendError(403);
            return;
        }
        System.out.println("Servlet received state dump request from:" + string + " hash:" + string2);
        byte[] byArray = Hex.fromHexString((String)string2);
        if (!ClusterService.getClusterService().checkRequest(string, byArray)) {
            httpServletResponse.sendError(403);
            return;
        }
        ServerIdentity serverIdentity = null;
        ClusterServices clusterServices = ClusterService.getServices();
        if (clusterServices == null) {
            throw new ServletException("This server is not in a cluster.");
        }
        Collection collection = clusterServices.getRemoteMembers();
        for (Object object2 : collection) {
            if (!object2.serverName().equals(string)) continue;
            serverIdentity = object2.identity();
            break;
        }
        if (serverIdentity == null) {
            throw new ServletException("Sender is not in the cluster view of this server " + string);
        }
        Object object3 = null;
        try {
            object3 = (HttpGroupMessage)GroupMessageHandlerServlet.deserialize((InputStream)httpServletRequest.getInputStream(), httpServletRequest.getContentLength());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServletException("Error deserializing stream.", (Throwable)classNotFoundException);
        }
        object2 = object3.executeAndGetResponse((HostID)serverIdentity);
        byte[] byArray2 = GroupMessageHandlerServlet.serialize(object2);
        httpServletResponse.setContentLength(byArray2.length);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.write(byArray2);
        servletOutputStream.close();
        httpServletResponse.flushBuffer();
        System.out.println("Writing response len:" + byArray2.length);
    }

    public static void executeMessageOnRemoteOverHttp(HostID hostID, HttpGroupMessage httpGroupMessage) throws IOException, ClassNotFoundException {
        String string = "/bea_wls_cluster_internal/0056FABC093BDF49C8AE091F74400598?server-name=" + CURRENT_SERVER_NAME + "&" + SERVER_HASH + "=" + CURRENT_SERVER_HASH;
        URL uRL = ClusterHelper.fabricateHTTPURL(string, hostID);
        System.out.println("Sending statedump request:" + uRL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        byte[] byArray = GroupMessageHandlerServlet.serialize(httpGroupMessage);
        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(byArray);
        outputStream.close();
        if (httpURLConnection.getResponseCode() != 200) {
            throw new IOException("Unexpected error when requesting statedump  code:" + httpURLConnection.getResponseCode() + " url:" + uRL);
        }
        int n = httpURLConnection.getContentLength();
        if (n > 0) {
            GroupMessage groupMessage = (GroupMessage)GroupMessageHandlerServlet.deserialize(httpURLConnection.getInputStream(), httpURLConnection.getContentLength());
            groupMessage.execute(hostID);
        }
    }

    public static interface HttpGroupMessage
    extends GroupMessage {
        public GroupMessage executeAndGetResponse(HostID var1);
    }
}

