/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import weblogic.cluster.ClusterAnnouncementsDebugLogger;
import weblogic.cluster.ClusterHelper;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.HybridMulticastReceiver;
import weblogic.cluster.MemberAttributes;
import weblogic.cluster.MemberManager;
import weblogic.cluster.MulticastManager;
import weblogic.cluster.RemoteMemberInfo;
import weblogic.common.internal.WLObjectInputStream;
import weblogic.management.provider.ManagementService;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.protocol.URLManager;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.io.DataIO;
import weblogic.work.WorkAdapter;

final class HTTPExecuteRequest
extends WorkAdapter {
    private HttpURLConnection con;
    private DataInputStream in;
    private final String request;
    private final int senderNum;
    private final HostID memberID;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String SECRET_STRING = "&ServerName=" + ManagementService.getRuntimeAccess(kernelId).getServer().getName();
    private static final byte[] SERVER_HASH_VALUE = ClusterService.getClusterService().getSecureHash();
    private static final boolean DEBUG = false;

    HTTPExecuteRequest(long l, int n, HostID hostID) {
        this.senderNum = n;
        this.request = this.getHeader(l);
        this.memberID = hostID;
    }

    private void connect() throws ConnectException, IOException {
        URL uRL = this.getServerURL();
        this.con = URLManager.createAdminHttpConnection(uRL);
        ConnectionSigner.signConnection(this.con, kernelId);
        this.con.setRequestMethod("POST");
        this.con.setDoInput(true);
        this.con.setDoOutput(true);
        OutputStream outputStream = this.con.getOutputStream();
        this.con.connect();
        outputStream.write(SERVER_HASH_VALUE);
        outputStream.flush();
        outputStream.close();
        this.in = new DataInputStream(this.con.getInputStream());
    }

    private URL getServerURL() throws MalformedURLException {
        return ClusterHelper.fabricateHTTPURL(this.request, this.memberID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block26: {
            if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
                ClusterLogger.logFetchServerStateDump((String)this.memberID.toString());
            }
            this.connect();
            if (this.con.getResponseCode() != 200) {
                throw new IOException("Failed to get OK response");
            }
            byte[] byArray = this.readHttpResponse(this.in, this.con.getContentLength());
            WLObjectInputStream wLObjectInputStream = MulticastManager.getInputStream(byArray);
            MemberAttributes memberAttributes = (MemberAttributes)wLObjectInputStream.readObject();
            this.processAttributes(memberAttributes);
            final GroupMessage groupMessage = (GroupMessage)wLObjectInputStream.readObject();
            long l = wLObjectInputStream.readLong();
            final HostID hostID = this.memberID;
            SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    groupMessage.execute(hostID);
                    if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
                        ClusterLogger.logFetchClusterStateDumpComplete((String)HTTPExecuteRequest.this.memberID.toString());
                    }
                    return null;
                }
            });
            Object var9_10 = null;
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.con != null) {
                this.con.disconnect();
            }
            this.resetHTTPRequestDispatchFlag();
            {
                break block26;
                catch (ConnectException connectException) {
                    if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
                        ClusterLogger.logFailedWhileReceivingStateDump((String)this.memberID.toString(), (Exception)connectException);
                    }
                    Object var9_11 = null;
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.con != null) {
                        this.con.disconnect();
                    }
                    this.resetHTTPRequestDispatchFlag();
                    break block26;
                }
                catch (IOException iOException) {
                    ClusterHelper.logStateDumpRequestRejection(this.con, iOException, this.memberID.toString());
                    Object var9_12 = null;
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    if (this.con != null) {
                        this.con.disconnect();
                    }
                    this.resetHTTPRequestDispatchFlag();
                    break block26;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClusterLogger.logFailedToDeserializeStateDump((String)this.memberID.toString(), (Exception)classNotFoundException);
                    Object var9_13 = null;
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.con != null) {
                        this.con.disconnect();
                    }
                    this.resetHTTPRequestDispatchFlag();
                }
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.con != null) {
                    this.con.disconnect();
                }
                this.resetHTTPRequestDispatchFlag();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetHTTPRequestDispatchFlag() {
        RemoteMemberInfo remoteMemberInfo = MemberManager.theOne().findOrCreate(this.memberID);
        try {
            HybridMulticastReceiver hybridMulticastReceiver = (HybridMulticastReceiver)remoteMemberInfo.findOrCreateReceiver(this.senderNum, true);
            hybridMulticastReceiver.setHttpRequestDispatched(false);
            Object var4_3 = null;
            MemberManager.theOne().done(remoteMemberInfo);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            MemberManager.theOne().done(remoteMemberInfo);
            throw throwable;
        }
    }

    private String getHeader(long l) {
        return "/bea_wls_cluster_internal/psquare/p2?senderNum=" + this.senderNum + "&lastSeqNum=" + l + "&PeerInfo=" + ClusterHelper.STRINGFIED_PEERINFO + SECRET_STRING;
    }

    private byte[] readHttpResponse(DataInputStream dataInputStream, int n) throws IOException, ProtocolException {
        byte[] byArray = new byte[n];
        DataIO.readFully((InputStream)dataInputStream, (byte[])byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttributes(MemberAttributes memberAttributes) {
        RemoteMemberInfo remoteMemberInfo = MemberManager.theOne().findOrCreate((HostID)memberAttributes.identity());
        try {
            remoteMemberInfo.processAttributes(memberAttributes);
            Object var4_3 = null;
            MemberManager.theOne().done(remoteMemberInfo);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            MemberManager.theOne().done(remoteMemberInfo);
            throw throwable;
        }
    }
}

