/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import weblogic.cluster.ClusterDebugLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MulticastManager;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.rmi.spi.HostID;

final class HeartbeatMessage
implements GroupMessage,
Externalizable {
    private static final boolean DEBUG = ClusterDebugLogger.isDebugEnabled();
    private static final long serialVersionUID = -7010984889884629879L;
    private static final long MAX_TIME_DIFF = 60000L;
    private long diff;
    ArrayList items;

    HeartbeatMessage(ArrayList arrayList) {
        this.items = arrayList;
    }

    public void execute(HostID hostID) {
        MulticastManager.theOne().receiveHeartbeat(hostID, this);
        if (this.diff > 60000L) {
            ClusterLogger.logMachineTimesOutOfSync((String)hostID.objectToString(), (long)(this.diff / 1000L));
        }
    }

    public String toString() {
        return "Heartbeat with " + this.items.size() + " items";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ((WLObjectOutput)objectOutput).writeArrayList(this.items);
        if (DEBUG) {
            objectOutput.writeLong(System.currentTimeMillis());
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.items = ((WLObjectInput)objectInput).readArrayList();
        if (DEBUG) {
            long l = objectInput.readLong();
            long l2 = System.currentTimeMillis();
            this.diff = Math.abs(l - l2);
        }
    }

    public HeartbeatMessage() {
    }
}

