/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.security.AccessController;
import weblogic.cluster.HTTPExecuteRequest;
import weblogic.cluster.MulticastReceiver;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class HybridMulticastReceiver
extends MulticastReceiver {
    private boolean httpReqDispatched;
    private int senderNum;
    private WorkManager workManager;
    private final HostID memberID;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    HybridMulticastReceiver(HostID hostID, int n) {
        this(hostID, n, WorkManagerFactory.getInstance().getSystem());
    }

    HybridMulticastReceiver(HostID hostID, int n, WorkManager workManager) {
        super(hostID, n, workManager);
        this.senderNum = n;
        this.workManager = workManager;
        this.memberID = hostID;
    }

    void processLastSeqNum(long l) {
        if (l >= this.currentSeqNum) {
            this.fetchStateDumpOverHttp(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInSync(int n) {
        HybridMulticastReceiver hybridMulticastReceiver = this;
        synchronized (hybridMulticastReceiver) {
            this.httpReqDispatched = false;
            super.setInSync(n);
        }
    }

    protected void setOutOfSync() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHttpRequestDispatched(boolean bl) {
        HybridMulticastReceiver hybridMulticastReceiver = this;
        synchronized (hybridMulticastReceiver) {
            this.httpReqDispatched = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchStateDumpOverHttp(long l) {
        if (this.httpReqDispatched) {
            return;
        }
        Object object = this;
        synchronized (object) {
            this.httpReqDispatched = true;
        }
        object = new HTTPExecuteRequest(l, this.senderNum, this.memberID);
        this.workManager.schedule((Runnable)object);
    }

    synchronized void dispatch(long l, int n, int n2, int n3, boolean bl, boolean bl2, byte[] byArray) {
        if (this.httpReqDispatched) {
            return;
        }
        super.dispatch(l, n, n2, n3, bl, bl2, byArray);
    }
}

