/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.security.AccessController;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.MemberManager;
import weblogic.cluster.MulticastManager;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.work.WorkManagerFactory;

public class InboundService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static boolean started;

    public void start() throws ServiceFailureException {
        InboundService.startListening();
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (clusterMBean != null) {
            MemberManager.theOne().waitToSyncWithCurrentMembers();
            MulticastManager.theOne().resume();
        }
    }

    public static synchronized void startListening() throws ServiceFailureException {
        if (started) {
            return;
        }
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (clusterMBean != null) {
            try {
                MulticastManager.theOne().startListening();
            }
            catch (IOException iOException) {
                ClusterLogger.logFailedToJoinClusterError((String)clusterMBean.getName(), (String)clusterMBean.getMulticastAddress(), (Exception)iOException);
                throw new ServiceFailureException("Failed to listen on multicast address", (Throwable)iOException);
            }
            if ("unicast".equals(clusterMBean.getClusterMessagingMode())) {
                ClusterLogger.logUnicastEnabled();
            } else {
                ClusterLogger.logListeningToCluster((String)clusterMBean.getName(), (String)clusterMBean.getMulticastAddress(), (String)(clusterMBean.getMulticastPort() + ""));
            }
            MulticastManager.theOne().startHeartbeat();
            started = true;
        }
    }

    public void stop() {
        this.shutdownInternal(false);
    }

    public synchronized void halt() {
        this.shutdownInternal(true);
    }

    private synchronized void shutdownInternal(boolean bl) {
        if (started) {
            if (bl) {
                WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                    public void run() {
                        MulticastManager.theOne().stopHeartbeat();
                    }
                });
            } else {
                MulticastManager.theOne().stopHeartbeat();
            }
        }
    }
}

