/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.common.internal.PeerInfo;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.cluster.ServerInfoManager;
import weblogic.server.channels.ChannelService;

final class MemberAttributes
implements ClusterMemberInfo,
Externalizable {
    private static final long serialVersionUID = -2297055762635480163L;
    private ServerIdentity jvmid;
    private String hostAddress;
    private String machineName;
    private String version;
    private long joinTime;
    private int loadWeight;
    private String replicationGroup;
    private String preferredSecondaryGroup;
    private String clusterName;
    private boolean isMigratableServer;
    private String replicationChannel;
    private PeerInfo info;

    public MemberAttributes() {
    }

    public MemberAttributes(String string, String string2, String string3, long l, int n, String string4, String string5, String string6, boolean bl, String string7, PeerInfo peerInfo) {
        this.jvmid = LocalServerIdentity.getIdentity();
        this.hostAddress = string == null ? "" : string;
        this.machineName = string2;
        this.version = string3;
        this.joinTime = l;
        this.loadWeight = n;
        this.replicationGroup = string4 == null ? "" : string4;
        this.preferredSecondaryGroup = string5 == null ? "" : string5;
        this.clusterName = string6;
        this.isMigratableServer = bl;
        this.replicationChannel = string7 == null ? "" : string7;
        this.info = peerInfo.getPeerInfoForWire();
    }

    public String toString() {
        return this.jvmid.getServerName() + " jvmid:" + this.jvmid;
    }

    public int hashCode() {
        return this.jvmid.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MemberAttributes) {
            MemberAttributes memberAttributes = (MemberAttributes)object;
            return this.jvmid.equals(memberAttributes.jvmid) && this.serverName().equals(memberAttributes.serverName());
        }
        return false;
    }

    public ServerIdentity identity() {
        return this.jvmid;
    }

    public String serverName() {
        return this.jvmid.getServerName();
    }

    public String hostAddress() {
        return this.hostAddress;
    }

    public String machineName() {
        return this.machineName;
    }

    public String version() {
        return this.version;
    }

    public long joinTime() {
        return this.joinTime;
    }

    public int loadWeight() {
        return this.loadWeight;
    }

    public String replicationGroup() {
        return this.replicationGroup;
    }

    public String preferredSecondaryGroup() {
        return this.preferredSecondaryGroup;
    }

    public String domainName() {
        return this.jvmid.getDomainName();
    }

    public String clusterName() {
        return this.clusterName;
    }

    public boolean isMigratableServer() {
        return this.isMigratableServer;
    }

    public String replicationChannel() {
        return this.replicationChannel;
    }

    public PeerInfo peerInfo() {
        return this.info;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.info);
        objectOutput.writeObject(this.jvmid);
        objectOutput.writeUTF(this.hostAddress);
        objectOutput.writeUTF(this.machineName);
        objectOutput.writeUTF(this.version);
        objectOutput.writeLong(this.joinTime);
        objectOutput.writeObject(ServerInfoManager.theOne().writeLocalInfoUpdate());
        objectOutput.writeInt(this.loadWeight);
        objectOutput.writeUTF(this.replicationGroup);
        objectOutput.writeUTF(this.preferredSecondaryGroup);
        objectOutput.writeUTF(this.clusterName);
        objectOutput.writeBoolean(this.isMigratableServer);
        objectOutput.writeUTF(this.replicationChannel);
        ChannelService.exportServerChannels(this.jvmid, objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.info = (PeerInfo)objectInput.readObject();
        this.jvmid = (ServerIdentity)objectInput.readObject();
        this.hostAddress = objectInput.readUTF();
        this.machineName = objectInput.readUTF();
        this.version = objectInput.readUTF();
        this.joinTime = objectInput.readLong();
        ServerInfoManager.theOne().readUpdate(objectInput.readObject());
        this.loadWeight = objectInput.readInt();
        this.replicationGroup = objectInput.readUTF();
        this.preferredSecondaryGroup = objectInput.readUTF();
        this.clusterName = objectInput.readUTF();
        this.isMigratableServer = objectInput.readBoolean();
        this.replicationChannel = objectInput.readUTF();
        ChannelService.importServerChannels(this.jvmid, objectInput);
    }
}

