/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.DataInputStream;
import java.io.Externalizable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.cluster.AnnouncementManager;
import weblogic.cluster.AttributeManager;
import weblogic.cluster.ClusterAnnouncementsDebugLogger;
import weblogic.cluster.ClusterDropoutListener;
import weblogic.cluster.ClusterHelper;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MemberAttributes;
import weblogic.cluster.MulticastManager;
import weblogic.cluster.MulticastReceiver;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.MulticastSessionIDConstants;
import weblogic.cluster.RecoverListener;
import weblogic.cluster.RemoteMemberInfo;
import weblogic.cluster.RuntimeStateMessage;
import weblogic.cluster.StateDumpMessage;
import weblogic.common.internal.WLObjectInputStream;
import weblogic.management.provider.ManagementService;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.protocol.URLManager;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.io.DataIO;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemberManager
implements PeerGoneListener,
MulticastSessionIDConstants,
RecoverListener {
    private final int idlePeriodsUntilTimeout;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String SECRET_STRING = "?PeerInfo=" + ClusterHelper.STRINGFIED_PEERINFO + "&ServerName=" + ManagementService.getRuntimeAccess(kernelId).getServer().getName();
    private static final byte[] SERVER_HASH_VALUE = ClusterService.getClusterService().getSecureHash();
    private static MemberManager theMemberManager = null;
    private Map remoteMembers = new HashMap();
    private long joinTime;
    private ArrayList ClusterMembersListeners;
    private boolean waitingForFirstHeartbeats = true;
    private String clusterName;
    private MulticastSession runtimeStateSender;

    public static MemberManager theOne() {
        return theMemberManager;
    }

    static void initialize(long l, int n) {
        Debug.assertion((theMemberManager == null ? 1 : 0) != 0, (String)"intialize only once");
        theMemberManager = new MemberManager(l, n);
        ClusterDropoutListener.initialize();
    }

    private MemberManager(long l, int n) {
        this.joinTime = l;
        this.ClusterMembersListeners = new ArrayList();
        this.clusterName = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getName();
        this.idlePeriodsUntilTimeout = n;
        this.runtimeStateSender = MulticastManager.theOne().createSender(3, this, 1, true, true);
    }

    int getIdlePeriodsUntilTimeout() {
        return this.idlePeriodsUntilTimeout;
    }

    synchronized void waitToSyncWithCurrentMembers() {
        long l;
        long l2 = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getMemberWarmupTimeoutSeconds() * 1000;
        if (l2 > (l = (long)(this.idlePeriodsUntilTimeout * 10000))) {
            this.waitForDiscovery(l);
            this.waitForSync();
        } else {
            if (l2 > 0L) {
                this.waitForDiscovery(l2);
            }
            this.waitForSync();
        }
    }

    private void waitForDiscovery(long l) {
        if (l > 0L) {
            ClusterLogger.logStartWarmup((String)ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getName());
        }
        long l2 = 0L;
        long l3 = System.currentTimeMillis();
        while (this.waitingForFirstHeartbeats && l2 < l) {
            try {
                this.wait(l - l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l2 = System.currentTimeMillis() - l3;
        }
        this.waitingForFirstHeartbeats = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSync() {
        HashSet hashSet;
        Object object = this;
        synchronized (object) {
            hashSet = new HashSet(this.remoteMembers.values());
        }
        object = hashSet.iterator();
        MemberAttributes memberAttributes = null;
        while (object.hasNext()) {
            RemoteMemberInfo remoteMemberInfo = (RemoteMemberInfo)object.next();
            MemberAttributes memberAttributes2 = remoteMemberInfo.getAttributes();
            if (memberAttributes2 == null) {
                object.remove();
                continue;
            }
            if (!remoteMemberInfo.isRunning()) continue;
            memberAttributes = memberAttributes2;
            break;
        }
        if (memberAttributes != null) {
            this.getJNDIStateDump(memberAttributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getJNDIStateDump(MemberAttributes memberAttributes) throws AssertionError {
        block35: {
            Externalizable externalizable;
            URL uRL = null;
            HttpURLConnection httpURLConnection = null;
            FilterInputStream filterInputStream = null;
            WLObjectInputStream wLObjectInputStream = null;
            ClusterLogger.logFetchClusterStateDump((String)memberAttributes.serverName());
            uRL = this.getServerURL(memberAttributes);
            httpURLConnection = URLManager.createAdminHttpConnection(uRL);
            ConnectionSigner.signConnection(httpURLConnection, kernelId);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            httpURLConnection.connect();
            outputStream.write(SERVER_HASH_VALUE);
            outputStream.flush();
            outputStream.close();
            filterInputStream = new DataInputStream(httpURLConnection.getInputStream());
            if (httpURLConnection.getResponseCode() != 200) {
                throw new IOException("Unexpected error on the server didn''t receive response code 200");
            }
            if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
                ClusterAnnouncementsDebugLogger.debug("Request " + uRL + " CONTENT LENGTH " + httpURLConnection.getContentLength());
            }
            byte[] byArray = this.readHttpResponse((DataInputStream)filterInputStream, httpURLConnection.getContentLength());
            wLObjectInputStream = MulticastManager.getInputStream(byArray);
            int n = wLObjectInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                externalizable = (MemberAttributes)wLObjectInputStream.readObject();
                StateDumpMessage stateDumpMessage = (StateDumpMessage)wLObjectInputStream.readObject();
                if (stateDumpMessage == null) continue;
                this.processAttributes((MemberAttributes)externalizable);
                AnnouncementManager.theOne().receiveStateDump((HostID)((MemberAttributes)externalizable).identity(), stateDumpMessage);
            }
            MemberAttributes memberAttributes2 = (MemberAttributes)wLObjectInputStream.readObject();
            this.processAttributes(memberAttributes2);
            externalizable = (StateDumpMessage)wLObjectInputStream.readObject();
            AnnouncementManager.theOne().receiveStateDump((HostID)memberAttributes2.identity(), (StateDumpMessage)externalizable);
            ClusterLogger.logFetchClusterStateDumpComplete((String)memberAttributes.serverName());
            Object var13_16 = null;
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (wLObjectInputStream != null) {
                    wLObjectInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            break block35;
            {
                catch (MalformedURLException malformedURLException) {
                    throw new AssertionError("Unexpected exception", (Throwable)malformedURLException);
                }
                catch (IOException iOException) {
                    ClusterHelper.logStateDumpRequestRejection(httpURLConnection, iOException, memberAttributes.serverName());
                    Object var13_17 = null;
                    try {
                        if (filterInputStream != null) {
                            filterInputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    try {
                        if (wLObjectInputStream != null) {
                            wLObjectInputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    break block35;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClusterLogger.logFailedToDeserializeStateDump((String)memberAttributes.serverName(), (Exception)classNotFoundException);
                    Object var13_18 = null;
                    try {
                        if (filterInputStream != null) {
                            filterInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (wLObjectInputStream != null) {
                            wLObjectInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                try {
                    if (filterInputStream != null) {
                        filterInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (wLObjectInputStream != null) {
                        wLObjectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
    }

    private URL getServerURL(ClusterMemberInfo clusterMemberInfo) throws MalformedURLException {
        return ClusterHelper.fabricateHTTPURL("/bea_wls_cluster_internal/a2e2gp2r2/p2s2" + SECRET_STRING, (HostID)clusterMemberInfo.identity());
    }

    synchronized void shutdown() {
        for (RemoteMemberInfo remoteMemberInfo : this.remoteMembers.values()) {
            remoteMemberInfo.shutdown();
        }
        this.remoteMembers.clear();
        this.ClusterMembersListeners.clear();
    }

    synchronized RemoteMemberInfo findOrCreate(HostID hostID) {
        RemoteMemberInfo remoteMemberInfo = (RemoteMemberInfo)this.remoteMembers.get(hostID);
        if (remoteMemberInfo == null) {
            remoteMemberInfo = new RemoteMemberInfo(hostID, this.joinTime);
            this.remoteMembers.put(hostID, remoteMemberInfo);
            remoteMemberInfo.numUnprocessedMessages = 1;
        } else {
            ++remoteMemberInfo.numUnprocessedMessages;
        }
        return remoteMemberInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<RemoteMemberInfo> getRemoteMemberInfos() {
        ArrayList<RemoteMemberInfo> arrayList = new ArrayList<RemoteMemberInfo>();
        Map map = this.remoteMembers;
        synchronized (map) {
            for (Object v : this.remoteMembers.values()) {
                if (!(v instanceof RemoteMemberInfo)) continue;
                arrayList.add((RemoteMemberInfo)v);
            }
        }
        return arrayList;
    }

    synchronized void done(RemoteMemberInfo remoteMemberInfo) {
        --remoteMemberInfo.numUnprocessedMessages;
        if (this.waitingForFirstHeartbeats && remoteMemberInfo.numUnprocessedMessages == 0 && remoteMemberInfo.getAttributes() != null && remoteMemberInfo.isRunning()) {
            this.waitingForFirstHeartbeats = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTimeout(HostID hostID) {
        RemoteMemberInfo remoteMemberInfo = this.findOrCreate(hostID);
        try {
            remoteMemberInfo.resetTimeout();
            Object var4_3 = null;
            this.done(remoteMemberInfo);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.done(remoteMemberInfo);
            throw throwable;
        }
    }

    synchronized void checkTimeouts() {
        Iterator iterator = this.remoteMembers.values().iterator();
        while (iterator.hasNext()) {
            RemoteMemberInfo remoteMemberInfo = (RemoteMemberInfo)iterator.next();
            boolean bl = remoteMemberInfo.checkTimeout();
            if (remoteMemberInfo.numUnprocessedMessages != 0 || !bl) continue;
            if (remoteMemberInfo.getAttributes() != null) {
                ClusterLogger.logRemovingServerDueToTimeout((String)remoteMemberInfo.getAttributes().toString());
            }
            iterator.remove();
            remoteMemberInfo.shutdown();
        }
    }

    public synchronized void peerGone(PeerGoneEvent peerGoneEvent) {
        RemoteMemberInfo remoteMemberInfo = (RemoteMemberInfo)this.remoteMembers.get(peerGoneEvent.getID());
        if (remoteMemberInfo != null) {
            if (remoteMemberInfo.numUnprocessedMessages == 0) {
                if (remoteMemberInfo.getAttributes() != null) {
                    ClusterLogger.logRemovingServerDueToPeerGone((String)remoteMemberInfo.getAttributes().toString());
                }
                final RemoteMemberInfo remoteMemberInfo2 = remoteMemberInfo;
                final Map map = this.remoteMembers;
                final PeerGoneEvent peerGoneEvent2 = peerGoneEvent;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        map.remove(peerGoneEvent2.getID());
                        remoteMemberInfo2.shutdown();
                        return null;
                    }
                });
            } else {
                remoteMemberInfo.forceTimeout();
            }
        }
    }

    synchronized void shutdown(HostID hostID) {
        final RemoteMemberInfo remoteMemberInfo = (RemoteMemberInfo)this.remoteMembers.get(hostID);
        if (remoteMemberInfo != null && remoteMemberInfo.getAttributes() != null) {
            ClusterLogger.logServerSuspended((String)remoteMemberInfo.getAttributes().serverName());
            final HostID hostID2 = hostID;
            SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    MemberManager.this.remoteMembers.remove(hostID2);
                    remoteMemberInfo.shutdown();
                    return null;
                }
            });
        }
    }

    Collection getRemoteMembers() {
        return this.getRemoteMembers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection getRemoteMembers(boolean bl) {
        HashMap hashMap;
        ArrayList<MemberAttributes> arrayList = new ArrayList<MemberAttributes>();
        MemberManager memberManager = this;
        synchronized (memberManager) {
            hashMap = (HashMap)((HashMap)this.remoteMembers).clone();
        }
        for (RemoteMemberInfo remoteMemberInfo : hashMap.values()) {
            MemberAttributes memberAttributes = remoteMemberInfo.getAttributes();
            if (memberAttributes == null) continue;
            if (bl) {
                if (!remoteMemberInfo.isRunning() && !remoteMemberInfo.isSuspended()) continue;
                arrayList.add(memberAttributes);
                continue;
            }
            if (!remoteMemberInfo.isRunning()) continue;
            arrayList.add(memberAttributes);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireClusterMembersChangeEvent(ClusterMemberInfo clusterMemberInfo, int n) {
        ArrayList arrayList = this.ClusterMembersListeners;
        synchronized (arrayList) {
            final ClusterMembersChangeEvent clusterMembersChangeEvent = new ClusterMembersChangeEvent(this, n, clusterMemberInfo);
            for (final ClusterMembersChangeListener clusterMembersChangeListener : this.ClusterMembersListeners) {
                WorkAdapter workAdapter = new WorkAdapter(){
                    private ClusterMembersChangeEvent event;
                    private ClusterMembersChangeListener listener;
                    {
                        this.event = clusterMembersChangeEvent;
                        this.listener = clusterMembersChangeListener;
                    }

                    public void run() {
                        this.listener.clusterMembersChanged(this.event);
                    }

                    public String toString() {
                        return "Cluster Members Changed";
                    }
                };
                WorkManagerFactory.getInstance().getSystem().schedule((Runnable)workAdapter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClusterMembersListener(ClusterMembersChangeListener clusterMembersChangeListener) {
        ArrayList arrayList = this.ClusterMembersListeners;
        synchronized (arrayList) {
            this.ClusterMembersListeners.add(clusterMembersChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClusterMembersListener(ClusterMembersChangeListener clusterMembersChangeListener) {
        ArrayList arrayList = this.ClusterMembersListeners;
        synchronized (arrayList) {
            int n = this.ClusterMembersListeners.indexOf(clusterMembersChangeListener);
            if (n > -1) {
                this.ClusterMembersListeners.remove(n);
            }
        }
    }

    private byte[] readHttpResponse(DataInputStream dataInputStream, int n) throws IOException, ProtocolException {
        byte[] byArray = new byte[n];
        DataIO.readFully((InputStream)dataInputStream, (byte[])byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttributes(MemberAttributes memberAttributes) {
        RemoteMemberInfo remoteMemberInfo = this.findOrCreate((HostID)memberAttributes.identity());
        try {
            remoteMemberInfo.processAttributes(memberAttributes);
            Object var4_3 = null;
            this.done(remoteMemberInfo);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.done(remoteMemberInfo);
            throw throwable;
        }
    }

    public void sendMemberRuntimeState() throws IOException {
        GroupMessage groupMessage = this.createRecoverMessage();
        this.runtimeStateSender.send(groupMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateMemberRuntimeState(HostID hostID, int n, long l) {
        RemoteMemberInfo remoteMemberInfo = this.findOrCreate(hostID);
        try {
            remoteMemberInfo.updateRuntimeState(n);
            MulticastReceiver multicastReceiver = remoteMemberInfo.findOrCreateReceiver(3, true);
            if (l >= 0L) {
                multicastReceiver.setInSync(l);
            }
            Object var8_6 = null;
            this.done(remoteMemberInfo);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.done(remoteMemberInfo);
            throw throwable;
        }
    }

    @Override
    public synchronized GroupMessage createRecoverMessage() {
        int n = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getStableState();
        long l = MulticastManager.theOne().findSender(3).getCurrentSeqNum();
        RuntimeStateMessage runtimeStateMessage = new RuntimeStateMessage(n, AttributeManager.theOne().getLocalAttributes(), l);
        return runtimeStateMessage;
    }

    void dumpDiagnosticImageData(XMLStreamWriter xMLStreamWriter) throws XMLStreamException, IOException {
        xMLStreamWriter.writeStartElement("MemberManager");
        xMLStreamWriter.writeAttribute("clusterName", this.clusterName);
        for (RemoteMemberInfo remoteMemberInfo : this.getRemoteMemberInfos()) {
            remoteMemberInfo.dumpDiagnosticImageData(xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
    }
}

