/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.util.ArrayList;
import java.util.Iterator;
import weblogic.cluster.ServiceOffer;
import weblogic.cluster.ServiceRetract;
import weblogic.cluster.TreeManager;
import weblogic.rmi.spi.HostID;

final class MemberServices {
    private HostID memberID;
    private ArrayList allOffers;

    MemberServices(HostID hostID) {
        this.memberID = hostID;
        this.allOffers = new ArrayList();
    }

    ArrayList getAllOffers() {
        return this.allOffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retractAllOffers(boolean bl) {
        ArrayList arrayList = this.allOffers;
        synchronized (arrayList) {
            for (ServiceOffer serviceOffer : this.allOffers) {
                TreeManager.theOne().retract(serviceOffer, bl);
            }
            this.allOffers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRetract(ServiceRetract serviceRetract, boolean bl) {
        ArrayList arrayList = this.allOffers;
        synchronized (arrayList) {
            Iterator iterator = this.allOffers.iterator();
            while (iterator.hasNext()) {
                ServiceOffer serviceOffer = (ServiceOffer)iterator.next();
                if (serviceOffer.id() != serviceRetract.id()) continue;
                iterator.remove();
                TreeManager.theOne().retract(serviceOffer, bl);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processOffer(ServiceOffer serviceOffer, boolean bl) {
        ArrayList arrayList = this.allOffers;
        synchronized (arrayList) {
            serviceOffer.setServer(this.memberID);
            TreeManager.theOne().install(serviceOffer, bl);
            this.allOffers.add(serviceOffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processUpdate(ServiceOffer serviceOffer, boolean bl, int n) {
        ArrayList arrayList = this.allOffers;
        synchronized (arrayList) {
            Iterator iterator = this.allOffers.iterator();
            while (iterator.hasNext()) {
                ServiceOffer serviceOffer2 = (ServiceOffer)iterator.next();
                if (serviceOffer2.id() != serviceOffer.getOldID()) continue;
                iterator.remove();
                break;
            }
            serviceOffer.setServer(this.memberID);
            TreeManager.theOne().update(serviceOffer, bl);
            this.allOffers.add(serviceOffer);
        }
    }
}

