/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Locale;
import weblogic.cluster.ClusterDebugLogger;
import weblogic.cluster.FragmentSocket;
import weblogic.cluster.MulticastManager;
import weblogic.utils.Debug;

class MulticastFragmentSocket
implements FragmentSocket {
    private static final boolean DEBUG = true;
    private String multicastAddr;
    private InetAddress group;
    private InetAddress interfaceAddr;
    private int port;
    private MulticastSocket sock;
    private boolean blocked;
    private ArrayList blockedPackets;
    private long packetDelay;
    private long lastDelay;
    private long lastSendTime;
    private long fragmentsSentCount;
    private long fragmentsReceivedCount;
    private static final String osName = MulticastFragmentSocket.initOSNameProp();
    private static final boolean isLinux = "linux".equals(osName);
    private static final int SO_TIMEOUT = 30000;
    private byte ttl;
    private int bufSize;
    private boolean shutdownPermanent;
    private Object SOCK_INIT_LOCK = new Object();

    MulticastFragmentSocket(String string, String string2, int n, byte by, long l, int n2) throws IOException, UnknownHostException {
        this.multicastAddr = string;
        this.group = InetAddress.getByName(string);
        this.port = n;
        if (string2 != null) {
            if (ClusterDebugLogger.isDebugEnabled()) {
                ClusterDebugLogger.debug("Setting the interface address to : " + string2);
            }
            this.interfaceAddr = InetAddress.getByName(string2);
        }
        this.ttl = by;
        this.bufSize = n2;
        this.blocked = true;
        this.blockedPackets = new ArrayList();
        this.packetDelay = l;
        this.lastDelay = 0L;
        this.lastSendTime = 0L;
        this.fragmentsSentCount = 0L;
        this.fragmentsReceivedCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMulticastSocket() throws IOException {
        if (this.sock != null) {
            return;
        }
        Object object = this.SOCK_INIT_LOCK;
        synchronized (object) {
            MulticastSocket multicastSocket;
            if (this.sock != null) {
                return;
            }
            if (isLinux) {
                try {
                    multicastSocket = new MulticastSocket(new InetSocketAddress(this.multicastAddr, this.port));
                }
                catch (BindException bindException) {
                    if (ClusterDebugLogger.isDebugEnabled()) {
                        ClusterDebugLogger.debug("Failed to bind to : " + this.multicastAddr, bindException);
                        ClusterDebugLogger.debug("Will try binding to IP_ANY...");
                    }
                    multicastSocket = new MulticastSocket(this.port);
                }
            } else {
                multicastSocket = new MulticastSocket(this.port);
            }
            if (this.interfaceAddr != null) {
                multicastSocket.setInterface(this.interfaceAddr);
            }
            multicastSocket.setTimeToLive(this.ttl);
            multicastSocket.setSoTimeout(30000);
            if (multicastSocket.getReceiveBufferSize() < this.bufSize) {
                multicastSocket.setReceiveBufferSize(this.bufSize);
            }
            if (multicastSocket.getSendBufferSize() < this.bufSize) {
                multicastSocket.setSendBufferSize(this.bufSize);
            }
            multicastSocket.joinGroup(this.group);
            this.sock = multicastSocket;
        }
    }

    private static String initOSNameProp() {
        String string = "UNKNOWN";
        try {
            string = System.getProperty("os.name", "UNKNOWN").toLowerCase(Locale.ENGLISH);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void send(byte[] byArray, int n) throws IOException {
        if (this.shutdownPermanent) {
            throw new IOException("multicast socket shutdown to enable unicast mode");
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, this.group, this.port);
        if (this.blocked) {
            this.blockedPackets.add(datagramPacket);
        } else {
            this.sendThrottled(datagramPacket);
        }
    }

    public synchronized void start() throws IOException {
        this.initializeMulticastSocket();
        this.blocked = false;
        for (DatagramPacket datagramPacket : this.blockedPackets) {
            this.sendThrottled(datagramPacket);
        }
        this.blockedPackets.clear();
    }

    public void shutdown() {
        try {
            if (this.sock != null) {
                this.sock.leaveGroup(this.group);
                this.sock.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sock = null;
        this.blockedPackets.clear();
    }

    private void sendThrottled(DatagramPacket datagramPacket) throws IOException {
        long l = System.currentTimeMillis();
        long l2 = this.packetDelay - (l - this.lastSendTime);
        if (l2 <= 0L) {
            this.lastSendTime = l;
        } else {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lastSendTime = l + l2;
        }
        try {
            if (this.sock == null) {
                this.initializeMulticastSocket();
            }
            this.sock.send(datagramPacket);
            if (MulticastManager.theOne().getSendStartTimestamp() == 0L) {
                MulticastManager.theOne().flagStartedSending();
            } else if (!MulticastManager.theOne().getCanReceiveOwnMessages()) {
                MulticastManager.theOne().handleMissedOwnMessages();
            }
        }
        catch (IOException iOException) {
            if (this.sock != null) {
                this.shutdown();
            }
            throw iOException;
        }
        ++this.fragmentsSentCount;
    }

    public int receive(byte[] byArray) throws InterruptedIOException, IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        try {
            if (this.sock == null) {
                if (this.shutdownPermanent) {
                    throw new IOException("multicast socket shutdown to enable unicast mode");
                }
                this.initializeMulticastSocket();
            }
            this.sock.receive(datagramPacket);
        }
        catch (IOException iOException) {
            if (this.sock != null) {
                this.shutdown();
            }
            throw iOException;
        }
        ++this.fragmentsReceivedCount;
        return datagramPacket.getLength();
    }

    public long getFragmentsSentCount() {
        return this.fragmentsSentCount;
    }

    public long getFragmentsReceivedCount() {
        return this.fragmentsReceivedCount;
    }

    public void setPacketDelay(long l) {
        Debug.say((String)("Setting packet delay to " + l));
        this.packetDelay = l;
    }

    public synchronized void shutdownPermanent() {
        this.shutdownPermanent = true;
        this.shutdown();
    }
}

