/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.cluster.ClusterDebugLogger;
import weblogic.cluster.ClusterExtensionLogger;
import weblogic.cluster.ClusterHeartbeatsDebugLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.EncryptionHelper;
import weblogic.cluster.FragmentSocket;
import weblogic.cluster.FragmentSocketWrapper;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.HeartbeatMessage;
import weblogic.cluster.LastSeqNumHBI;
import weblogic.cluster.MemberManager;
import weblogic.cluster.MulticastReceiver;
import weblogic.cluster.MulticastReplacer;
import weblogic.cluster.MulticastSender;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.MulticastSessionIDConstants;
import weblogic.cluster.NAKHBI;
import weblogic.cluster.RecoverListener;
import weblogic.cluster.RemoteMemberInfo;
import weblogic.cluster.ShutdownMessage;
import weblogic.cluster.UpgradeUtils;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.WLObjectInputStream;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.health.HealthMonitorService;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.t3.srvr.SetUIDRendezvous;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;
import weblogic.work.WorkManagerImpl;

public class MulticastManager
extends WorkAdapter
implements NakedTimerListener,
MulticastSessionIDConstants {
    static final int HEARTBEAT_PERIOD_MILLIS = 10000;
    static final int MAX_FRAGMENT_SIZE = Kernel.getConfig().getMTUSize() - 100;
    static final int ONE_KILO_BYTE = 1024;
    private static final int MAX_RETRY_DELAY = 10000;
    private static final int RETRY_DELAY_INCREMENT = 1000;
    private int currentDelay = 0;
    private final TimerManager timerManager;
    private static final String osName = MulticastManager.initOSNameProp();
    private static final boolean isLinux = "linux".equals(osName);
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static MulticastManager theMulticastManager = null;
    private boolean serverResumed = false;
    private FragmentSocket sock;
    private byte[] fragmentBuffer;
    private boolean shutdown;
    private ArrayList senders;
    private ArrayList currentHeartbeatItems;
    private ArrayList suspendedSendersLastSeqHBI;
    private MulticastSender heartbeatSender;
    private long messagesLostCount;
    private long resendRequestsCount;
    private int localDomainNameHash;
    private int localClusterNameHash;
    private String localDomainName;
    private String localClusterName;
    private long numForeignFragementsDropped;
    private boolean canReceiveOwnMessages = false;
    private long sendStartTimestamp = 0L;
    private final int port;
    private final String multicastAddress;
    private final String clusterName;
    private final boolean isUnicast;

    public static MulticastManager theOne() {
        return theMulticastManager;
    }

    static void initialize(String string, String string2, int n, byte by, long l) throws IOException, UnknownHostException {
        theMulticastManager = new MulticastManager(string, string2, n, by, l);
    }

    private MulticastManager(String string, String string2, int n, byte by, long l) throws IOException, UnknownHostException {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        this.isUnicast = "unicast".equals(clusterMBean.getClusterMessagingMode());
        int n2 = clusterMBean.getMulticastBufferSize();
        n2 = n2 > 0 ? (n2 *= 1024) : 32768;
        this.sock = FragmentSocketWrapper.getInstance(string, string2, n, by, l, n2);
        this.fragmentBuffer = new byte[32768];
        this.shutdown = false;
        this.senders = new ArrayList();
        this.currentHeartbeatItems = new ArrayList();
        this.suspendedSendersLastSeqHBI = new ArrayList();
        for (int i = 0; i <= 3; ++i) {
            this.senders.add(null);
        }
        this.heartbeatSender = this.createSender(0, null, -1, false);
        this.messagesLostCount = 0L;
        this.resendRequestsCount = 0L;
        this.localDomainName = ManagementService.getRuntimeAccess(kernelId).getDomain().getName();
        this.localDomainNameHash = this.hashCode(this.localDomainName);
        this.localClusterName = clusterMBean.getName();
        this.localClusterNameHash = this.hashCode(this.localClusterName);
        this.numForeignFragementsDropped = 0L;
        this.multicastAddress = string;
        this.port = n;
        this.clusterName = clusterMBean.getName();
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("Heartbeat", WorkManagerFactory.getInstance().getSystem());
    }

    void startListening() throws IOException {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                try {
                    MulticastManager.this.sock.start();
                }
                catch (IOException iOException) {
                    return iOException;
                }
                return null;
            }
        };
        IOException iOException = null;
        iOException = this.port > 1024 ? (IOException)privilegedAction.run() : (IOException)SetUIDRendezvous.doPrivileged(privilegedAction);
        if (iOException != null) {
            throw iOException;
        }
        WorkManagerImpl.executeDaemonTask((String)"weblogic.cluster.MessageReceiver", (int)5, (Runnable)((Object)this));
    }

    void startHeartbeat() {
        if (this.timerManager.isSuspended()) {
            this.timerManager.resume();
        } else {
            this.timerManager.scheduleAtFixedRate((TimerListener)this, 0L, 10000L);
        }
    }

    synchronized void suspendNonAdminMulticastSessions() {
        for (MulticastSender multicastSender : this.senders) {
            Serializable serializable;
            if (multicastSender.isAdminSender() || !multicastSender.isRetryEnabled()) continue;
            multicastSender.suspend();
            LastSeqNumHBI lastSeqNumHBI = new LastSeqNumHBI(multicastSender.getSessionID(), 0L, false);
            int n = this.currentHeartbeatItems.indexOf(lastSeqNumHBI);
            if (n < 0 || (serializable = (Serializable)this.currentHeartbeatItems.get(n)) == null) continue;
            this.removeItem(serializable);
            this.suspendedSendersLastSeqHBI.add(serializable);
        }
    }

    synchronized void resumeNonAdminMulticastSessions() {
        for (Object object : this.suspendedSendersLastSeqHBI) {
            this.addItem((Serializable)object);
        }
        this.suspendedSendersLastSeqHBI.clear();
        for (MulticastSender multicastSender : this.senders) {
            if (multicastSender.isAdminSender()) continue;
            multicastSender.resume();
        }
    }

    void stopHeartbeat() {
        if (!this.timerManager.isSuspended()) {
            try {
                this.heartbeatSender.send(new ShutdownMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.timerManager.suspend();
        }
    }

    void handleMissedOwnMessages() {
        ClusterMBean clusterMBean;
        long l;
        long l2 = System.currentTimeMillis() - this.sendStartTimestamp;
        if (l2 > (l = (long)(10000 * ((clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster()).getIdlePeriodsUntilTimeout() + 1)))) {
            ClusterLogger.logMessageCannotReceiveOwnMessages((String)ManagementService.getRuntimeAccess(kernelId).getServer().getName());
            HealthMonitorService.subsystemFailed("Cluster", "Unable to receive self generated multicast messages");
        }
    }

    void stopListening() {
        this.shutdown = true;
        this.sock.shutdown();
    }

    MulticastSender createSender(int n, RecoverListener recoverListener, int n2, boolean bl) {
        return this.createSender(n, recoverListener, n2, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MulticastSender createSender(int n, RecoverListener recoverListener, int n2, boolean bl, boolean bl2) {
        ArrayList arrayList = this.senders;
        synchronized (arrayList) {
            MulticastSender multicastSender = null;
            if (n == -1) {
                multicastSender = new MulticastSender(this.senders.size(), this.sock, recoverListener, n2, bl, bl2);
                this.senders.add(multicastSender);
            } else {
                multicastSender = (MulticastSender)this.senders.get(n);
                if (multicastSender == null) {
                    multicastSender = new MulticastSender(n, this.sock, recoverListener, n2, bl, bl2);
                    this.senders.set(multicastSender.getSessionID(), multicastSender);
                }
            }
            return multicastSender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MulticastSender findSender(int n) {
        ArrayList arrayList = this.senders;
        synchronized (arrayList) {
            return (MulticastSender)this.senders.get(n);
        }
    }

    public synchronized void addItem(Serializable serializable) {
        this.currentHeartbeatItems.add(serializable);
    }

    synchronized void removeItem(Serializable serializable) {
        this.currentHeartbeatItems.remove(serializable);
    }

    synchronized void replaceItem(Serializable serializable) {
        this.removeItem(serializable);
        this.addItem(serializable);
    }

    void flagStartedSending() {
        this.sendStartTimestamp = System.currentTimeMillis();
    }

    long getSendStartTimestamp() {
        return this.sendStartTimestamp;
    }

    boolean getCanReceiveOwnMessages() {
        return this.canReceiveOwnMessages;
    }

    void receiveHeartbeat(HostID hostID, HeartbeatMessage heartbeatMessage) {
        final HostID hostID2 = hostID;
        final HeartbeatMessage heartbeatMessage2 = heartbeatMessage;
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                if (ClusterHeartbeatsDebugLogger.isDebugEnabled()) {
                    ClusterHeartbeatsDebugLogger.debug("Received " + heartbeatMessage2 + " from " + hostID2);
                    Iterator iterator = heartbeatMessage2.items.iterator();
                    while (iterator.hasNext()) {
                        ClusterHeartbeatsDebugLogger.debug("  " + iterator.next());
                    }
                }
                for (Object e : heartbeatMessage2.items) {
                    Object object;
                    Externalizable externalizable;
                    if (e instanceof GroupMessage) {
                        ((GroupMessage)e).execute(hostID2);
                        continue;
                    }
                    if (e instanceof LastSeqNumHBI) {
                        Object var7_6;
                        externalizable = (LastSeqNumHBI)e;
                        if (!MulticastManager.this.serverResumed && externalizable.senderNum >= 2 && externalizable.senderNum != 3) continue;
                        object = MemberManager.theOne().findOrCreate(hostID2);
                        try {
                            MulticastReceiver multicastReceiver = ((RemoteMemberInfo)object).findOrCreateReceiver(externalizable.senderNum, externalizable.useHTTPForSD);
                            multicastReceiver.processLastSeqNum(externalizable.lastSeqNum);
                            var7_6 = null;
                            MemberManager.theOne().done((RemoteMemberInfo)object);
                            continue;
                        }
                        catch (Throwable throwable) {
                            var7_6 = null;
                            MemberManager.theOne().done((RemoteMemberInfo)object);
                            throw throwable;
                        }
                    }
                    if (!(e instanceof NAKHBI)) continue;
                    externalizable = (NAKHBI)e;
                    if (!((NAKHBI)externalizable).memID.isLocal()) continue;
                    object = MulticastManager.this.findSender(((NAKHBI)externalizable).senderNum);
                    ((MulticastSender)object).processNAK(((NAKHBI)externalizable).seqNum, ((NAKHBI)externalizable).fragNum, ((NAKHBI)externalizable).serverVersion);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.shutdown) {
            HostID hostID = null;
            try {
                byte[] byArray;
                this.sock.receive(this.fragmentBuffer);
                WLObjectInputStream wLObjectInputStream = MulticastManager.getInputStream(this.fragmentBuffer);
                int n = wLObjectInputStream.readInt();
                int n2 = wLObjectInputStream.readInt();
                hostID = (HostID)wLObjectInputStream.readObjectWL();
                if (this.isFragmentFromForeignCluster(n, n2)) {
                    ++this.numForeignFragementsDropped;
                    if (!this.isUnicast) {
                        if (n != this.localDomainNameHash) {
                            if (!isLinux) {
                                ClusterLogger.logMultipleDomainsCannotUseSameMulticastAddress2((String)this.localDomainName);
                            }
                        } else {
                            ClusterLogger.logMultipleClustersCannotUseSameMulticastAddress2((String)this.localClusterName);
                        }
                    }
                    if (!ClusterDebugLogger.isDebugEnabled()) continue;
                    ClusterDebugLogger.debug("dropped fragment from foreign domain/cluster domainhash=" + n + " clusterhash=" + n2 + " id=" + hostID);
                    continue;
                }
                if (hostID.isLocal()) {
                    this.canReceiveOwnMessages = true;
                    continue;
                }
                if (!MulticastManager.acceptMessageVersion(wLObjectInputStream)) continue;
                MemberManager.theOne().resetTimeout(hostID);
                byte[] byArray2 = null;
                if (ClusterService.getClusterService().multicastDataEncryptionEnabled()) {
                    byArray2 = (byte[])wLObjectInputStream.readObject();
                }
                byte[] byArray3 = byArray = (byte[])wLObjectInputStream.readObject();
                if (ClusterService.getClusterService().multicastDataEncryptionEnabled()) {
                    if (!EncryptionHelper.verify(byArray, byArray2)) {
                        ClusterLogger.logMessageDigestInvalid((String)hostID.objectToString());
                        return;
                    }
                    byArray3 = EncryptionHelper.decrypt(byArray, kernelId);
                }
                wLObjectInputStream = MulticastManager.getInputStream(byArray3);
                int n3 = wLObjectInputStream.readInt();
                long l = wLObjectInputStream.readLong();
                int n4 = wLObjectInputStream.readInt();
                int n5 = wLObjectInputStream.readInt();
                int n6 = wLObjectInputStream.readInt();
                boolean bl = wLObjectInputStream.readBoolean();
                boolean bl2 = wLObjectInputStream.readBoolean();
                boolean bl3 = wLObjectInputStream.readBoolean();
                byte[] byArray4 = wLObjectInputStream.readBytes();
                if (this.serverResumed || n3 < 2 || n3 == 3) {
                    Object var21_25;
                    RemoteMemberInfo remoteMemberInfo = MemberManager.theOne().findOrCreate(hostID);
                    try {
                        MulticastReceiver multicastReceiver = remoteMemberInfo.findOrCreateReceiver(n3, bl3);
                        multicastReceiver.dispatch(l, n4, n5, n6, bl, bl2, byArray4);
                        var21_25 = null;
                        MemberManager.theOne().done(remoteMemberInfo);
                    }
                    catch (Throwable throwable) {
                        var21_25 = null;
                        MemberManager.theOne().done(remoteMemberInfo);
                        throw throwable;
                    }
                }
                this.currentDelay = 0;
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (EOFException eOFException) {
                ClusterLogger.logMulticastAddressCollision((String)this.clusterName, (String)this.multicastAddress, (String)(this.port + ""));
            }
            catch (OptionalDataException optionalDataException) {
                ClusterLogger.logMulticastAddressCollision((String)this.clusterName, (String)this.multicastAddress, (String)(this.port + ""));
            }
            catch (StreamCorruptedException streamCorruptedException) {
                if (hostID != null && ClusterService.getClusterService().multicastDataEncryptionEnabled()) {
                    ClusterLogger.logMessageDigestInvalid((String)hostID.objectToString());
                    continue;
                }
                if (this.isUnicast) {
                    ClusterExtensionLogger.logUnicastReceiveError((Throwable)streamCorruptedException);
                    continue;
                }
                ClusterLogger.logMulticastReceiveError((Throwable)streamCorruptedException);
            }
            catch (IOException iOException) {
                if (!this.shutdown) {
                    if (this.isUnicast) {
                        ClusterExtensionLogger.logUnicastReceiveError((Throwable)iOException);
                    } else {
                        ClusterLogger.logMulticastReceiveError((Throwable)iOException);
                    }
                }
                this.delay();
            }
            catch (Throwable throwable) {
                if (this.shutdown) continue;
                if (this.isUnicast) {
                    ClusterExtensionLogger.logUnicastReceiveError((Throwable)throwable);
                    continue;
                }
                ClusterLogger.logMulticastReceiveError((Throwable)throwable);
            }
        }
    }

    private static boolean acceptMessageVersion(WLObjectInputStream wLObjectInputStream) {
        try {
            String string = wLObjectInputStream.readString();
            if (UpgradeUtils.getInstance().acceptVersion(string)) {
                if (ClusterDebugLogger.isDebugEnabled()) {
                    ClusterDebugLogger.debug("[UPGRADE] accepting a group message as the remote version is compatible. message version is " + string);
                }
                return true;
            }
            if (ClusterDebugLogger.isDebugEnabled()) {
                ClusterDebugLogger.debug("[UPGRADE] DROPPING a group message as the remote version is NOT compatible. message version is " + string);
            }
            return false;
        }
        catch (IOException iOException) {
            if (ClusterDebugLogger.isDebugEnabled()) {
                ClusterDebugLogger.debug("[UPGRADE] remote version is not available in group message!" + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            }
            return true;
        }
    }

    private void delay() {
        this.currentDelay = Math.min(this.currentDelay + 1000, 10000);
        try {
            Thread.sleep(this.currentDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    MulticastSession getSender(int n) {
        return (MulticastSession)this.senders.get(n);
    }

    void forceSuspend() {
        this.serverResumed = false;
    }

    void resume() {
        this.serverResumed = true;
    }

    private boolean isFragmentFromForeignCluster(int n, int n2) {
        return this.localDomainNameHash != n || this.localClusterNameHash != n2;
    }

    public int hashCode(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = 31 * n + string.charAt(i);
        }
        return n;
    }

    static WLObjectInputStream getInputStream(byte[] byArray) throws IOException {
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
        WLObjectInputStream wLObjectInputStream = new WLObjectInputStream((InputStream)unsyncByteArrayInputStream);
        wLObjectInputStream.setReplacer(new MulticastReplacer((HostID)LocalServerIdentity.getIdentity()));
        return wLObjectInputStream;
    }

    static WLObjectOutputStream getOutputStream(UnsyncByteArrayOutputStream unsyncByteArrayOutputStream) throws IOException {
        return UpgradeUtils.getInstance().getOutputStream(unsyncByteArrayOutputStream, ServerChannelManager.findDefaultLocalServerChannel());
    }

    static WLObjectOutputStream getOutputStream(UnsyncByteArrayOutputStream unsyncByteArrayOutputStream, PeerInfo peerInfo) throws IOException {
        return UpgradeUtils.getInstance().getOutputStream(unsyncByteArrayOutputStream, ServerChannelManager.findDefaultLocalServerChannel(), peerInfo);
    }

    boolean isUnicastMessagingMode() {
        return this.isUnicast;
    }

    long getFragmentsSentCount() {
        return this.sock.getFragmentsSentCount();
    }

    long getFragmentsReceivedCount() {
        return this.sock.getFragmentsReceivedCount();
    }

    long getMulticastMessagesLostCount() {
        return this.messagesLostCount;
    }

    long getResendRequestsCount() {
        return this.resendRequestsCount;
    }

    void incrementMulticastMessagesLostCount(long l) {
        this.messagesLostCount += l;
    }

    void incrementResendRequestsCount() {
        ++this.resendRequestsCount;
    }

    long getForeignFragmentsDroppedCount() {
        return this.numForeignFragementsDropped;
    }

    public String toString() {
        return "Read Multicast Msg Fragment";
    }

    public void setPacketDelay(long l) {
        this.sock.setPacketDelay(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        try {
            HeartbeatMessage heartbeatMessage;
            Object object = this;
            synchronized (object) {
                heartbeatMessage = new HeartbeatMessage((ArrayList)this.currentHeartbeatItems.clone());
            }
            this.heartbeatSender.send(heartbeatMessage);
            if (ClusterHeartbeatsDebugLogger.isDebugEnabled()) {
                ClusterHeartbeatsDebugLogger.debug("Sent " + heartbeatMessage);
                object = heartbeatMessage.items.iterator();
                while (object.hasNext()) {
                    ClusterHeartbeatsDebugLogger.debug("  " + object.next());
                }
            }
        }
        catch (IOException iOException) {
            ClusterLogger.logMulticastSendError((IOException)iOException);
        }
        MemberManager.theOne().checkTimeouts();
    }

    private static String initOSNameProp() {
        String string = "UNKNOWN";
        try {
            string = System.getProperty("os.name", "UNKNOWN").toLowerCase(Locale.ENGLISH);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string;
    }

    void dumpDiagnosticImageData(XMLStreamWriter xMLStreamWriter) throws XMLStreamException, IOException {
        xMLStreamWriter.writeStartElement("MulticastManager");
        MemberManager memberManager = MemberManager.theOne();
        if (memberManager != null) {
            memberManager.dumpDiagnosticImageData(xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
    }
}

