/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OptionalDataException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Date;
import weblogic.cluster.MulticastReplacer;
import weblogic.cluster.MulticastSessionIDConstants;
import weblogic.common.internal.WLObjectInputStream;
import weblogic.kernel.Kernel;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.security.HMAC;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.utils.ByteArrayDiffChecker;
import weblogic.utils.io.UnsyncByteArrayInputStream;

public final class MulticastMonitor
implements MulticastSessionIDConstants {
    static final int MAX_FRAGMENT_SIZE = 65536;
    private final MulticastSocket sock;
    private byte[] fragmentBuffer;
    private final int bufSize;
    private final int localDomainNameHash;
    private final int localClusterNameHash;
    private byte[] salt = null;
    private byte[] key = null;
    private String domainDir;
    private EncryptionService es;
    private ByteArrayDiffChecker badc;
    private boolean esEnabled = false;

    public MulticastMonitor(String string, int n, String string2, String string3, String string4) throws IOException, UnknownHostException {
        this.bufSize = 131072;
        this.sock = new MulticastSocket(n);
        this.sock.setSoTimeout(30000);
        this.sock.setReceiveBufferSize(this.bufSize);
        this.localDomainNameHash = this.hashCode(string2);
        this.localClusterNameHash = this.hashCode(string3);
        this.sock.joinGroup(InetAddress.getByName(string));
        this.domainDir = string4;
        this.badc = new ByteArrayDiffChecker();
        Kernel.ensureInitialized();
        this.initES();
    }

    private void initES() {
        if (this.domainDir == null) {
            return;
        }
        System.setProperty("weblogic.RootDirectory", this.domainDir);
        this.es = SerializedSystemIni.getExistingEncryptionService();
        if (this.es == null) {
            return;
        }
        this.salt = SerializedSystemIni.getSalt();
        this.key = SerializedSystemIni.getEncryptedSecretKey();
        this.esEnabled = true;
    }

    private boolean verify(byte[] byArray, byte[] byArray2) {
        if (!this.esEnabled) {
            return false;
        }
        byte[] byArray3 = HMAC.digest((byte[])byArray, (byte[])this.key, (byte[])this.salt);
        return this.badc.diffByteArrays(byArray2, byArray3) == null;
    }

    public void run() throws Exception {
        while (true) {
            try {
                while (true) {
                    this.fragmentBuffer = new byte[65536];
                    DatagramPacket datagramPacket = new DatagramPacket(this.fragmentBuffer, 65536);
                    this.sock.receive(datagramPacket);
                    WLObjectInputStream wLObjectInputStream = MulticastMonitor.getInputStream(datagramPacket.getData());
                    int n = wLObjectInputStream.readInt();
                    int n2 = wLObjectInputStream.readInt();
                    HostID hostID = (HostID)wLObjectInputStream.readObjectWL();
                    byte[] byArray = null;
                    byte[] byArray2 = null;
                    byte[] byArray3 = null;
                    String string = wLObjectInputStream.readString();
                    byArray = (byte[])wLObjectInputStream.readObject();
                    try {
                        byArray2 = (byte[])wLObjectInputStream.readObject();
                    }
                    catch (IOException iOException) {
                        byArray2 = byArray;
                        byArray = null;
                    }
                    if (byArray != null) {
                        if (!this.esEnabled) {
                            System.err.println("Cannot handle encrypted multicast traffic.  Make sure domaindir is specified and correct");
                            MulticastMonitor.usage();
                        }
                        if (this.verify(byArray2, byArray)) {
                            byArray3 = this.es.decryptBytes(byArray2);
                        } else {
                            System.err.println("Message digest mismatch - ignoring packet");
                            System.exit(1);
                        }
                    } else {
                        byArray3 = byArray2;
                    }
                    wLObjectInputStream = MulticastMonitor.getInputStream(byArray3);
                    int n3 = wLObjectInputStream.readInt();
                    long l = wLObjectInputStream.readLong();
                    int n4 = wLObjectInputStream.readInt();
                    int n5 = wLObjectInputStream.readInt();
                    int n6 = wLObjectInputStream.readInt();
                    boolean bl = wLObjectInputStream.readBoolean();
                    boolean bl2 = wLObjectInputStream.readBoolean();
                    boolean bl3 = wLObjectInputStream.readBoolean();
                    byte[] byArray4 = wLObjectInputStream.readBytes();
                    if (!this.isFragmentFromForeignCluster(n, n2)) {
                        String string2;
                        switch (n3) {
                            case 2: {
                                n5 = byArray4.length;
                                string2 = " Received announcement message of size ";
                                break;
                            }
                            case 1: {
                                string2 = " Received attribute message of size ";
                                break;
                            }
                            case 0: {
                                string2 = " Received heartbeat message of size ";
                                break;
                            }
                            default: {
                                string2 = " Received multicast message of size ";
                            }
                        }
                        System.out.println(string2 + n5 + " from " + ((ServerIdentity)hostID).getServerName() + " @ " + new Date() + " messageVersion:" + string + " seqNum:" + l + " fragment # " + n4);
                        continue;
                    }
                    System.out.println("Received multicast message of size " + n5 + " from foreign cluster " + hostID);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            catch (OptionalDataException optionalDataException) {
                System.err.println("Failed with OptionalDataException - EOF = " + optionalDataException.eof + " Length = " + optionalDataException.length);
                System.exit(1);
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Failed with IOException " + iOException);
                System.exit(1);
                continue;
            }
            break;
        }
    }

    private boolean isFragmentFromForeignCluster(int n, int n2) {
        return this.localDomainNameHash != n || this.localClusterNameHash != n2;
    }

    public int hashCode(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = 31 * n + string.charAt(i);
        }
        return n;
    }

    private static WLObjectInputStream getInputStream(byte[] byArray) throws IOException {
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
        WLObjectInputStream wLObjectInputStream = new WLObjectInputStream((InputStream)unsyncByteArrayInputStream);
        wLObjectInputStream.setReplacer(new MulticastReplacer((HostID)LocalServerIdentity.getIdentity()));
        return wLObjectInputStream;
    }

    public static void main(String[] stringArray) {
        String string = null;
        try {
            if (stringArray.length < 4 || stringArray.length > 5) {
                MulticastMonitor.usage();
            }
            if (stringArray.length == 5) {
                string = stringArray[4];
            }
            MulticastMonitor multicastMonitor = new MulticastMonitor(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], string);
            multicastMonitor.run();
        }
        catch (Exception exception) {
            MulticastMonitor.usage();
        }
    }

    public static void usage() {
        System.out.println("java weblogic.cluster.MulticastMonitor <multicastaddress> <port> <domainname> <clustername> [<domaindir>] ");
        System.exit(1);
    }
}

