/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.util.BitSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.cluster.ClusterDebugLogger;
import weblogic.cluster.ClusterExtensionLogger;
import weblogic.cluster.ClusterFragmentsDebugLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MulticastManager;
import weblogic.cluster.NAKHBI;
import weblogic.common.internal.WLObjectInputStream;
import weblogic.rmi.spi.HostID;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class MulticastReceiver {
    private static final boolean DEBUG = false;
    private static final int CACHE_SIZE = 3;
    private HostID memberID;
    private int senderNum;
    private IncomingMessage[] cache;
    protected long currentSeqNum;
    private boolean recoveryInProgress;
    private boolean outOfSync;
    private boolean retryEnabled;
    private WorkManager workManager;
    private ConcurrentHashMap<String, GroupMessageStat> groupMessageStatistics = new ConcurrentHashMap();

    MulticastReceiver(HostID hostID, int n) {
        this(hostID, n, WorkManagerFactory.getInstance().getDefault());
    }

    MulticastReceiver(HostID hostID, int n, WorkManager workManager) {
        this.memberID = hostID;
        this.senderNum = n;
        this.workManager = workManager;
        this.clear();
    }

    synchronized void dispatch(long l, int n, int n2, int n3, boolean bl, boolean bl2, byte[] byArray) {
        this.retryEnabled = bl2;
        this.processFragment(l, n, n2, n3, bl, byArray);
        GroupMessage groupMessage = this.getNextMessage();
        while (groupMessage != null) {
            final HostID hostID = this.memberID;
            final GroupMessage groupMessage2 = groupMessage;
            String string = groupMessage2.getClass().getName();
            GroupMessageStat groupMessageStat = this.groupMessageStatistics.get(groupMessage2.getClass().getName());
            if (groupMessageStat == null) {
                groupMessageStat = new GroupMessageStat(string);
                this.groupMessageStatistics.put(string, groupMessageStat);
            }
            final GroupMessageStat groupMessageStat2 = groupMessageStat;
            groupMessageStat2.start();
            WorkAdapter workAdapter = new WorkAdapter(){
                private HostID id;
                private GroupMessage msg;
                {
                    this.id = hostID;
                    this.msg = groupMessage2;
                }

                public void run() {
                    long l = System.nanoTime();
                    this.msg.execute(this.id);
                    long l2 = System.nanoTime() - l;
                    groupMessageStat2.finish(l2);
                }

                public String toString() {
                    return "Dispatch Multicast Msg Fragment";
                }
            };
            this.workManager.schedule((Runnable)workAdapter);
            groupMessage = this.getNextMessage();
        }
    }

    private void processFragment(long l, int n, int n2, int n3, boolean bl, byte[] byArray) {
        if (ClusterFragmentsDebugLogger.isDebugEnabled()) {
            ClusterFragmentsDebugLogger.debug("Received fragment memberID:" + this.memberID + " senderNum:" + this.senderNum + " seqNum:" + l + "fragNum:" + n + " containing " + byArray.length + " out of " + n2 + " bytes");
            ClusterFragmentsDebugLogger.debug("currentSeqNum: " + this.currentSeqNum);
        }
        if (l < this.currentSeqNum) {
            return;
        }
        if (l == this.currentSeqNum) {
            if (bl && !this.recoveryInProgress) {
                ++this.currentSeqNum;
                return;
            }
        } else if (l > this.currentSeqNum) {
            if (bl) {
                this.reportLostMessages(l - this.currentSeqNum);
                this.currentSeqNum = l;
                this.recoveryInProgress = true;
                this.setInSync();
            } else if (this.retryEnabled) {
                this.setOutOfSync();
                if (l >= this.currentSeqNum + 3L) {
                    return;
                }
            } else if (l >= this.currentSeqNum + 3L) {
                long l2 = l - 3L + 1L;
                this.reportLostMessages(l2 - this.currentSeqNum);
                this.currentSeqNum = l2;
            }
        }
        IncomingMessage incomingMessage = this.cache[(int)(l % 3L)];
        incomingMessage.processFragment(l, n, n2, n3, byArray);
    }

    private GroupMessage getNextMessage() {
        byte[] byArray = null;
        if (this.retryEnabled) {
            byArray = this.cache[(int)(this.currentSeqNum % 3L)].getMessage(this.currentSeqNum);
            if (byArray != null) {
                this.recoveryInProgress = false;
                this.setInSync();
                ++this.currentSeqNum;
            } else {
                this.resetOutOfSync();
            }
        } else {
            for (long i = this.currentSeqNum; i < this.currentSeqNum + 3L; ++i) {
                byArray = this.cache[(int)(i % 3L)].getMessage(i);
                if (byArray == null) continue;
                if (i > this.currentSeqNum) {
                    this.reportLostMessages(i - this.currentSeqNum);
                }
                this.currentSeqNum = i + 1L;
                break;
            }
        }
        if (byArray != null) {
            try {
                WLObjectInputStream wLObjectInputStream = MulticastManager.getInputStream(byArray);
                GroupMessage groupMessage = (GroupMessage)wLObjectInputStream.readObjectWL();
                if (ClusterDebugLogger.isDebugEnabled()) {
                    ClusterDebugLogger.debug("Received memberID:" + this.memberID + " senderNum:" + this.senderNum + " seqNum:" + (this.currentSeqNum - 1L) + " message:" + groupMessage);
                }
                return groupMessage;
            }
            catch (IOException iOException) {
                if (MulticastManager.theOne().isUnicastMessagingMode()) {
                    ClusterExtensionLogger.logUnicastReceiveError((Throwable)iOException);
                } else {
                    ClusterLogger.logMulticastReceiveError((Throwable)iOException);
                }
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (MulticastManager.theOne().isUnicastMessagingMode()) {
                    ClusterExtensionLogger.logUnicastReceiveError((Throwable)classNotFoundException);
                } else {
                    ClusterLogger.logMulticastReceiveError((Throwable)classNotFoundException);
                }
                return null;
            }
        }
        return null;
    }

    synchronized void processLastSeqNum(long l) {
        if (l >= this.currentSeqNum) {
            this.setOutOfSync();
        }
    }

    long getCurrentSeqNum() {
        return this.currentSeqNum;
    }

    protected void setOutOfSync() {
        if (!this.outOfSync) {
            MulticastManager.theOne().incrementResendRequestsCount();
            this.outOfSync = true;
            IncomingMessage incomingMessage = this.cache[(int)(this.currentSeqNum % 3L)];
            int n = incomingMessage.nextFragNum(this.currentSeqNum);
            MulticastManager.theOne().addItem(new NAKHBI(this.memberID, this.senderNum, this.currentSeqNum, n));
        }
    }

    private void resetOutOfSync() {
        if (this.outOfSync) {
            IncomingMessage incomingMessage = this.cache[(int)(this.currentSeqNum % 3L)];
            int n = incomingMessage.nextFragNum(this.currentSeqNum);
            MulticastManager.theOne().replaceItem(new NAKHBI(this.memberID, this.senderNum, this.currentSeqNum, n));
        }
    }

    private void setInSync() {
        if (this.outOfSync) {
            this.outOfSync = false;
            MulticastManager.theOne().removeItem(new NAKHBI(this.memberID, this.senderNum, 0L, 0));
        }
    }

    void setInSync(long l) {
        this.currentSeqNum = l;
        this.setInSync();
    }

    synchronized void shutdown() {
        if (this.outOfSync) {
            MulticastManager.theOne().removeItem(new NAKHBI(this.memberID, this.senderNum, 0L, 0));
        }
    }

    private void reportLostMessages(long l) {
        if (this.currentSeqNum > 0L) {
            MulticastManager.theOne().incrementMulticastMessagesLostCount(l);
            if (ClusterService.getClusterService().isUnicastMessagingModeEnabled()) {
                ClusterExtensionLogger.logLostUnicastMessages((long)l);
            } else {
                ClusterLogger.logLostMulticastMessages((long)l);
            }
        }
    }

    synchronized void clear() {
        this.cache = new IncomingMessage[3];
        for (int i = 0; i < 3; ++i) {
            this.cache[i] = new IncomingMessage();
        }
        this.currentSeqNum = 0L;
        this.recoveryInProgress = false;
        this.outOfSync = false;
        this.groupMessageStatistics.clear();
    }

    void dumpDiagnosticImageData(XMLStreamWriter xMLStreamWriter) throws XMLStreamException, IOException {
        xMLStreamWriter.writeStartElement("MulticastReceiver");
        xMLStreamWriter.writeAttribute("MemberID", this.memberID.toString());
        xMLStreamWriter.writeAttribute("SenderNum", String.valueOf(this.senderNum));
        for (GroupMessageStat groupMessageStat : this.groupMessageStatistics.values()) {
            groupMessageStat.dumpDiagnosticImageData(xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
    }

    private static class GroupMessageStat {
        private String name;
        private AtomicLong totalScheduled;
        private AtomicLong totalExecutionTimeNanos;
        private AtomicLong totalExecuted;
        private long minExecutionTimeNanos = Long.MAX_VALUE;
        private long maxExecutionTimeNanos = -1L;
        private long lastExecutionTimeNanos = -1L;

        public GroupMessageStat(String string) {
            this.name = string;
            this.totalScheduled = new AtomicLong();
            this.totalExecutionTimeNanos = new AtomicLong();
            this.totalExecuted = new AtomicLong();
        }

        public String getName() {
            return this.name;
        }

        public long getTotalScheduled() {
            return this.totalScheduled.get();
        }

        public long getTotalExecutionTimeNanos() {
            return this.totalExecutionTimeNanos.get();
        }

        public long getTotalExecuted() {
            return this.totalExecuted.get();
        }

        public double getAverageExecutionTimeNanos() {
            long l = this.getTotalExecuted();
            long l2 = this.getTotalExecutionTimeNanos();
            return l != 0L ? (double)l2 / (double)l : 0.0;
        }

        public long getPendingCount() {
            return this.getTotalScheduled() - this.getTotalExecuted();
        }

        public void start() {
            this.totalScheduled.addAndGet(1L);
        }

        public void finish(long l) {
            this.totalExecutionTimeNanos.addAndGet(l);
            this.totalExecuted.addAndGet(1L);
            if (l < this.minExecutionTimeNanos) {
                this.minExecutionTimeNanos = l;
            }
            if (l > this.maxExecutionTimeNanos) {
                this.maxExecutionTimeNanos = l;
            }
            this.lastExecutionTimeNanos = l;
        }

        void dumpDiagnosticImageData(XMLStreamWriter xMLStreamWriter) throws XMLStreamException, IOException {
            xMLStreamWriter.writeStartElement("GroupMessageStat");
            xMLStreamWriter.writeAttribute("Name", this.name);
            xMLStreamWriter.writeAttribute("TotalScheduled", String.valueOf(this.totalScheduled));
            xMLStreamWriter.writeAttribute("TotalExecuted", String.valueOf(this.totalExecuted));
            xMLStreamWriter.writeAttribute("AverageExecutionTimeNanos", String.valueOf(this.getAverageExecutionTimeNanos()));
            xMLStreamWriter.writeAttribute("MinExecutionTimeNanos", String.valueOf(this.minExecutionTimeNanos));
            xMLStreamWriter.writeAttribute("MaxExecutionTimeNanos", String.valueOf(this.maxExecutionTimeNanos));
            xMLStreamWriter.writeAttribute("LastExecutionTimeNanos", String.valueOf(this.lastExecutionTimeNanos));
            xMLStreamWriter.writeEndElement();
        }
    }

    private class IncomingMessage {
        private static final int INVALID_SEQNUM = -1;
        private long currentSeqNum = -1L;
        private int numFragments;
        private long numFragmentsReceived;
        private byte[] serializedMessage;
        private BitSet fragmentsReceived;

        IncomingMessage() {
        }

        void processFragment(long l, int n, int n2, int n3, byte[] byArray) {
            if (this.currentSeqNum != l) {
                this.currentSeqNum = l;
                this.numFragments = -1;
                this.numFragmentsReceived = 0L;
                this.serializedMessage = new byte[n2];
                this.fragmentsReceived = new BitSet();
            }
            if (!this.fragmentsReceived.get(n)) {
                System.arraycopy(byArray, 0, this.serializedMessage, n3, byArray.length);
                this.fragmentsReceived.set(n);
                ++this.numFragmentsReceived;
                if (n3 + byArray.length >= n2) {
                    this.numFragments = n + 1;
                }
            }
        }

        byte[] getMessage(long l) {
            if (l != this.currentSeqNum || this.numFragmentsReceived != (long)this.numFragments) {
                return null;
            }
            return this.serializedMessage;
        }

        int nextFragNum(long l) {
            int n;
            if (l != this.currentSeqNum) {
                return 0;
            }
            for (n = 0; n < this.fragmentsReceived.length() && this.fragmentsReceived.get(n); ++n) {
            }
            return n;
        }
    }
}

