/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.util.Arrays;
import weblogic.cluster.ClusterDebugLogger;
import weblogic.cluster.ClusterFragmentsDebugLogger;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.EncryptionHelper;
import weblogic.cluster.FragmentSocket;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.HeartbeatMessage;
import weblogic.cluster.LastSeqNumHBI;
import weblogic.cluster.MulticastManager;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.RecoverListener;
import weblogic.cluster.UpgradeUtils;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public final class MulticastSender
implements MulticastSession {
    private static final int DEFAULT_CACHE_SIZE = 3;
    private static final int RESEND_BLOCKING_INTERVAL_MILLIS = 2000;
    private static final int PAYLOAD_FUDGE_FACTOR = 27;
    private static final short DATA_HEADERS_SIZE = 29;
    private static final int ENCRYPTION_OVERHEAD_SIZE = 34;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private int senderNum;
    private FragmentSocket sock;
    private RecoverListener rl;
    private boolean retryEnabled;
    private int cacheSize;
    private OutgoingMessage[] cache;
    private int numMessages;
    private long oldestSeqNum;
    private long lastResendTime;
    private long lastSeqNumResent;
    private int lastFragNumResent;
    private int localDomainNameHash;
    private int localClusterNameHash;
    private final boolean useHTTPForSD;
    private final boolean adminSender;
    private boolean suspended;

    MulticastSender(int n, FragmentSocket fragmentSocket, RecoverListener recoverListener, int n2, boolean bl) {
        this(n, fragmentSocket, recoverListener, n2, bl, false);
    }

    MulticastSender(int n, FragmentSocket fragmentSocket, RecoverListener recoverListener, int n2, boolean bl, boolean bl2) {
        this.senderNum = n;
        this.sock = fragmentSocket;
        this.rl = recoverListener;
        this.adminSender = bl2;
        this.suspended = false;
        boolean bl3 = this.retryEnabled = recoverListener != null;
        this.cacheSize = !this.retryEnabled ? 1 : (n2 > 0 ? n2 : 3);
        this.cache = new OutgoingMessage[this.cacheSize];
        for (int i = 0; i < this.cacheSize; ++i) {
            this.cache[i] = new OutgoingMessage();
        }
        this.numMessages = 0;
        this.oldestSeqNum = 0L;
        this.lastResendTime = 0L;
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        this.localDomainNameHash = this.hashCode(ManagementService.getRuntimeAccess(kernelId).getDomain().getName());
        this.localClusterNameHash = this.hashCode(clusterMBean.getName());
        this.useHTTPForSD = bl;
    }

    public synchronized void send(GroupMessage groupMessage) throws IOException {
        if (!this.isAdminSender() && this.suspended) {
            if (ClusterDebugLogger.isDebugEnabled()) {
                ClusterDebugLogger.debug("Not sending message " + groupMessage + " as the " + "multicast session is supended");
            }
            return;
        }
        OutgoingMessage outgoingMessage = this.prepare(groupMessage, false);
        if (ClusterDebugLogger.isDebugEnabled()) {
            ClusterDebugLogger.debug("Sending senderNum:" + this.senderNum + " seqNum:" + outgoingMessage.seqNum + " message:" + groupMessage + " outgoing message:" + outgoingMessage);
        }
        this.fragmentAndSend(outgoingMessage, 0);
        if (this.retryEnabled) {
            this.lastResendTime = System.currentTimeMillis();
            this.lastSeqNumResent = outgoingMessage.seqNum;
            this.lastFragNumResent = 0;
            MulticastManager.theOne().replaceItem(new LastSeqNumHBI(this.senderNum, outgoingMessage.seqNum, this.useHTTPForSD));
        }
    }

    synchronized void processNAK(long l, int n, String string) {
        try {
            long l2 = System.currentTimeMillis();
            if (l < this.lastSeqNumResent || l == this.lastSeqNumResent && n < this.lastFragNumResent || l2 - this.lastResendTime > 2000L) {
                int n2;
                long l3;
                this.lastResendTime = l2;
                if (l >= this.oldestSeqNum) {
                    if (ClusterDebugLogger.isDebugEnabled()) {
                        ClusterDebugLogger.debug("Resending senderNum:" + this.senderNum + " seqNum:" + l + " fragNum:" + n);
                    }
                    l3 = l;
                    n2 = n;
                    this.lastSeqNumResent = l;
                    this.lastFragNumResent = n;
                } else {
                    if (this.cache[(int)(this.oldestSeqNum % (long)this.cacheSize)].isRecover) {
                        if (ClusterDebugLogger.isDebugEnabled()) {
                            ClusterDebugLogger.debug("Resending recover senderNum:" + this.senderNum + " seqNum:" + this.oldestSeqNum);
                        }
                    } else {
                        GroupMessage groupMessage = this.rl.createRecoverMessage();
                        if (ClusterDebugLogger.isDebugEnabled()) {
                            ClusterDebugLogger.debug("Sending recover senderNum:" + this.senderNum + " seqNum:" + this.oldestSeqNum + " message:" + groupMessage);
                        }
                        OutgoingMessage outgoingMessage = this.prepare(groupMessage, true);
                        MulticastManager.theOne().replaceItem(new LastSeqNumHBI(this.senderNum, outgoingMessage.seqNum, this.useHTTPForSD));
                    }
                    l3 = this.oldestSeqNum;
                    n2 = 0;
                    this.lastSeqNumResent = 0L;
                    this.lastFragNumResent = 0;
                }
                for (long i = l3; i <= this.oldestSeqNum + (long)this.numMessages - 1L; ++i) {
                    OutgoingMessage outgoingMessage = this.cache[(int)(i % (long)this.cacheSize)];
                    outgoingMessage = outgoingMessage.replace(string);
                    this.fragmentAndSend(outgoingMessage, n2);
                    n2 = 0;
                }
            }
        }
        catch (IOException iOException) {
            if (ClusterDebugLogger.isDebugEnabled()) {
                ClusterLogger.logMulticastSendError((IOException)iOException);
            }
            ClusterLogger.logMulticastSendErrorMsg((String)iOException.getLocalizedMessage());
        }
    }

    public int getSessionID() {
        return this.senderNum;
    }

    GroupMessage createRecoverMessage() {
        if (this.rl == null) {
            return null;
        }
        return this.rl.createRecoverMessage();
    }

    long getCurrentSeqNum() {
        return this.oldestSeqNum + (long)this.numMessages;
    }

    boolean isAdminSender() {
        return this.adminSender;
    }

    boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    synchronized void suspend() {
        this.suspended = true;
    }

    synchronized void resume() {
        this.suspended = false;
    }

    private OutgoingMessage prepare(GroupMessage groupMessage, boolean bl) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        WLObjectOutputStream wLObjectOutputStream = MulticastManager.getOutputStream(unsyncByteArrayOutputStream);
        wLObjectOutputStream.writeObjectWL(groupMessage);
        String string = ((UpgradeUtils.PeerInfoableObjectOutput)wLObjectOutputStream).getClusterVersion();
        wLObjectOutputStream.flush();
        long l = this.oldestSeqNum + (long)this.numMessages;
        OutgoingMessage outgoingMessage = this.cache[(int)(l % (long)this.cacheSize)];
        if (MulticastSender.isHeartbeatMessage(groupMessage)) {
            outgoingMessage.set(unsyncByteArrayOutputStream.toRawBytes(), unsyncByteArrayOutputStream.size(), l, bl, this.retryEnabled, "0,0,0", null);
        } else {
            outgoingMessage.set(unsyncByteArrayOutputStream.toRawBytes(), unsyncByteArrayOutputStream.size(), l, bl, this.retryEnabled, string, groupMessage);
        }
        if (bl) {
            this.oldestSeqNum = l;
            this.numMessages = 1;
        } else if (this.numMessages == this.cacheSize) {
            ++this.oldestSeqNum;
        } else {
            ++this.numMessages;
        }
        return outgoingMessage;
    }

    private static boolean isHeartbeatMessage(GroupMessage groupMessage) {
        return groupMessage instanceof HeartbeatMessage;
    }

    private void fragmentAndSend(OutgoingMessage outgoingMessage, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n2 < outgoingMessage.size) {
            byte[] byArray;
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(MulticastManager.MAX_FRAGMENT_SIZE);
            WLObjectOutputStream wLObjectOutputStream = MulticastManager.getOutputStream(unsyncByteArrayOutputStream);
            wLObjectOutputStream.writeInt(this.localDomainNameHash);
            wLObjectOutputStream.writeInt(this.localClusterNameHash);
            wLObjectOutputStream.writeObjectWL(LocalServerIdentity.getIdentity());
            wLObjectOutputStream.writeString(outgoingMessage.messageVersion);
            wLObjectOutputStream.flush();
            int n4 = unsyncByteArrayOutputStream.size() + 27;
            if (ClusterService.getClusterService().multicastDataEncryptionEnabled()) {
                n4 += 34;
            }
            int n5 = Math.min(MulticastManager.MAX_FRAGMENT_SIZE - (n4 += 56), outgoingMessage.size - n2);
            byte[] byArray2 = byArray = this.serializePayload(outgoingMessage, n3, n2, n, n5);
            if (ClusterService.getClusterService().multicastDataEncryptionEnabled()) {
                byArray2 = EncryptionHelper.encrypt(byArray);
            }
            if (byArray2 != null) {
                if (ClusterService.getClusterService().multicastDataEncryptionEnabled()) {
                    wLObjectOutputStream.writeObject(EncryptionHelper.sign(byArray2));
                }
                wLObjectOutputStream.writeObject(byArray2);
                wLObjectOutputStream.flush();
                if (ClusterFragmentsDebugLogger.isDebugEnabled()) {
                    ClusterFragmentsDebugLogger.debug("Sending fragment senderNum:" + this.senderNum + " seqNum:" + outgoingMessage.seqNum + "fragNum:" + n3 + " containing " + n5 + " bytes out of " + outgoingMessage.size);
                }
                this.sock.send(unsyncByteArrayOutputStream.toRawBytes(), unsyncByteArrayOutputStream.size());
            }
            n2 += n5;
            ++n3;
        }
    }

    private byte[] serializePayload(OutgoingMessage outgoingMessage, int n, int n2, int n3, int n4) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(MulticastManager.MAX_FRAGMENT_SIZE);
        WLObjectOutputStream wLObjectOutputStream = new WLObjectOutputStream(byteArrayOutputStream);
        wLObjectOutputStream.writeInt(this.senderNum);
        wLObjectOutputStream.writeLong(outgoingMessage.seqNum);
        wLObjectOutputStream.writeInt(n);
        wLObjectOutputStream.writeInt(outgoingMessage.size);
        wLObjectOutputStream.writeInt(n2);
        wLObjectOutputStream.writeBoolean(outgoingMessage.isRecover);
        wLObjectOutputStream.writeBoolean(outgoingMessage.retryEnabled);
        wLObjectOutputStream.writeBoolean(this.useHTTPForSD);
        if (n >= n3) {
            wLObjectOutputStream.writeBytes(outgoingMessage.message, n2, n4);
            wLObjectOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public int hashCode(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = 31 * n + string.charAt(i);
        }
        return n;
    }

    public String toString() {
        return "MulticastSender-" + this.senderNum;
    }

    class OutgoingMessage {
        public byte[] message;
        public int size;
        public long seqNum;
        public boolean isRecover;
        public boolean retryEnabled;
        public String messageVersion;
        public GroupMessage groupMessage;

        OutgoingMessage() {
        }

        void set(byte[] byArray, int n, long l, boolean bl, boolean bl2, String string, GroupMessage groupMessage) {
            this.message = byArray;
            this.size = n;
            this.seqNum = l;
            this.isRecover = bl;
            this.retryEnabled = bl2;
            this.messageVersion = string;
            this.groupMessage = groupMessage;
        }

        void clear() {
            this.message = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public synchronized OutgoingMessage replace(String string) {
            OutgoingMessage outgoingMessage;
            OutgoingMessage outgoingMessage2;
            ObjectOutputStream objectOutputStream;
            block22: {
                block20: {
                    OutgoingMessage outgoingMessage3;
                    block21: {
                        block18: {
                            OutgoingMessage outgoingMessage4;
                            block19: {
                                block16: {
                                    OutgoingMessage outgoingMessage5;
                                    block17: {
                                        objectOutputStream = null;
                                        if (string != null && this.messageVersion != null) break block16;
                                        outgoingMessage5 = this;
                                        Object var8_7 = null;
                                        if (objectOutputStream == null) break block17;
                                        try {
                                            objectOutputStream.close();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    return outgoingMessage5;
                                }
                                if (!string.equals(this.messageVersion)) break block18;
                                outgoingMessage4 = this;
                                Object var8_8 = null;
                                if (objectOutputStream == null) break block19;
                                try {
                                    objectOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return outgoingMessage4;
                        }
                        PeerInfo peerInfo = PeerInfo.getPeerInfo((String)this.messageVersion);
                        outgoingMessage2 = PeerInfo.getPeerInfo((String)string);
                        if (ClusterDebugLogger.isDebugEnabled()) {
                            ClusterDebugLogger.debug("[UPGRADE] outgoing message needs replacement?, messageVersion:" + this.messageVersion + ", remoteVersion:" + string);
                        }
                        if (peerInfo.compareTo((Object)outgoingMessage2) > 0) break block20;
                        outgoingMessage3 = this;
                        Object var8_9 = null;
                        if (objectOutputStream == null) break block21;
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return outgoingMessage3;
                }
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                objectOutputStream = MulticastManager.getOutputStream(unsyncByteArrayOutputStream, (PeerInfo)outgoingMessage2);
                ((WLObjectOutputStream)objectOutputStream).writeObjectWL(this.groupMessage);
                this.messageVersion = ((UpgradeUtils.PeerInfoableObjectOutput)objectOutputStream).getClusterVersion();
                ((WLObjectOutputStream)objectOutputStream).writeString(this.messageVersion);
                objectOutputStream.flush();
                this.message = unsyncByteArrayOutputStream.toRawBytes();
                this.size = unsyncByteArrayOutputStream.size();
                if (ClusterDebugLogger.isDebugEnabled()) {
                    ClusterDebugLogger.debug("[UPGRADE] outgoing message is replaced and new messageVersion is " + this.messageVersion);
                }
                outgoingMessage = this;
                Object var8_10 = null;
                if (objectOutputStream == null) break block22;
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return outgoingMessage;
            catch (IOException iOException) {
                block23: {
                    try {
                        iOException.printStackTrace();
                        outgoingMessage2 = this;
                        Object var8_11 = null;
                        if (objectOutputStream == null) break block23;
                    }
                    catch (Throwable throwable) {
                        block24: {
                            Object var8_12 = null;
                            if (objectOutputStream == null) break block24;
                            try {
                                objectOutputStream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
                return outgoingMessage2;
            }
        }

        public String toString() {
            return "message:" + Arrays.toString(this.message) + ", size:" + this.size + ", seqNum:" + this.seqNum + ", messageVersion:" + this.messageVersion;
        }
    }
}

