/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.cluster.AttributeManager;
import weblogic.cluster.ClusterHelper;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MulticastManager;
import weblogic.cluster.MulticastSender;
import weblogic.cluster.UpgradeUtils;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerChannelStream;
import weblogic.utils.Debug;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public final class MulticastSessionDataRecoveryServlet
extends HttpServlet {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_BUF_SIZE = 10240;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("ServerName");
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        int n = httpServletRequest.getContentLength();
        if (n <= 0) {
            httpServletResponse.setStatus(403);
            return;
        }
        byte[] byArray = new byte[n];
        DataIO.readFully((InputStream)httpServletRequest.getInputStream(), (byte[])byArray);
        if (!ClusterService.getClusterService().checkRequest(string, byArray)) {
            httpServletResponse.setStatus(403);
            return;
        }
        if (ClusterService.getClusterService().multicastDataEncryptionEnabled() && !httpServletRequest.isSecure()) {
            ClusterLogger.logEnforceSecureRequest();
            httpServletResponse.setStatus(403);
            return;
        }
        String string2 = httpServletRequest.getParameter("senderNum");
        String string3 = httpServletRequest.getParameter("lastSeqNum");
        String string4 = httpServletRequest.getParameter("PeerInfo");
        PeerInfo peerInfo = ClusterHelper.getPeerInfo(string4);
        Debug.assertion((peerInfo != null ? 1 : 0) != 0, (String)"Peer info cannot be null");
        int n2 = Integer.valueOf(string2);
        int n3 = Integer.valueOf(string3);
        if (httpServletRequest.getParameter("PingOnly") != null) {
            this.executePingRequest(n3);
            return;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = null;
        WLObjectOutputStream wLObjectOutputStream = null;
        OutputStream outputStream = null;
        try {
            unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(10240);
            wLObjectOutputStream = UpgradeUtils.getInstance().getOutputStream(unsyncByteArrayOutputStream, null, peerInfo);
            ServerChannel serverChannel = ((ServerChannelStream)httpServletRequest).getServerChannel();
            wLObjectOutputStream.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
            MulticastSender multicastSender = MulticastManager.theOne().findSender(n2);
            GroupMessage groupMessage = multicastSender.createRecoverMessage();
            wLObjectOutputStream.writeObject(AttributeManager.theOne().getLocalAttributes());
            wLObjectOutputStream.writeObject(groupMessage);
            wLObjectOutputStream.writeLong(multicastSender.getCurrentSeqNum());
            wLObjectOutputStream.flush();
            httpServletResponse.setContentType("application/unknown");
            outputStream = httpServletResponse.getOutputStream();
            httpServletResponse.setContentLength(unsyncByteArrayOutputStream.size());
            unsyncByteArrayOutputStream.writeTo(outputStream);
            outputStream.flush();
        }
        finally {
            try {
                if (unsyncByteArrayOutputStream != null) {
                    unsyncByteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (wLObjectOutputStream != null) {
                    wLObjectOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void executePingRequest(int n) throws ServletException {
        MulticastSender multicastSender = MulticastManager.theOne().findSender(2);
        if (multicastSender.getCurrentSeqNum() != (long)n) {
            throw new ServletException("Incompatible sender sequence numbers. local value " + multicastSender.getCurrentSeqNum() + " received value " + n);
        }
    }
}

