/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.cluster.ClusterDebugLogger;
import weblogic.cluster.UpgradeUtils;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.rmi.spi.HostID;
import weblogic.utils.StackTraceUtils;

public final class NAKHBI
implements Externalizable {
    private static final long serialVersionUID = 1807772120988360177L;
    HostID memID;
    int senderNum;
    long seqNum;
    int fragNum;
    String serverVersion;

    NAKHBI(HostID hostID, int n, long l, int n2) {
        this.memID = hostID;
        this.senderNum = n;
        this.seqNum = l;
        this.fragNum = n2;
    }

    public String toString() {
        return "NAKHBI server:" + this.memID + " senderNum:" + this.senderNum + " seqNum:" + this.seqNum + " fragNum:" + this.fragNum;
    }

    public boolean equals(Object object) {
        try {
            NAKHBI nAKHBI = (NAKHBI)object;
            return this.memID.equals(nAKHBI.memID) && this.senderNum == nAKHBI.senderNum;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.senderNum;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        WLObjectOutput wLObjectOutput = (WLObjectOutput)objectOutput;
        wLObjectOutput.writeObjectWL((Object)this.memID);
        wLObjectOutput.writeInt(this.senderNum);
        wLObjectOutput.writeLong(this.seqNum);
        wLObjectOutput.writeInt(this.fragNum);
        wLObjectOutput.writeString(UpgradeUtils.getInstance().getLocalServerVersion());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        block2: {
            WLObjectInput wLObjectInput = (WLObjectInput)objectInput;
            this.memID = (HostID)wLObjectInput.readObjectWL();
            this.senderNum = wLObjectInput.readInt();
            this.seqNum = wLObjectInput.readLong();
            this.fragNum = wLObjectInput.readInt();
            try {
                this.serverVersion = wLObjectInput.readString();
            }
            catch (IOException iOException) {
                if (!ClusterDebugLogger.isDebugEnabled()) break block2;
                ClusterDebugLogger.debug("[UPGRADE] serverVerion not available in NAKBHI!" + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            }
        }
    }

    public NAKHBI() {
    }
}

