/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ConflictHandler;
import weblogic.cluster.ServiceOffer;
import weblogic.rmi.spi.HostID;
import weblogic.utils.AssertionError;

public final class NodeInfo {
    private static final boolean debug = false;
    private Collection installedOffers = new ArrayList();
    private Collection pendingOffers = null;
    int numUnprocessedRequests;
    private String name;
    private Context initialCtx;
    private ConflictHandler conHandler;
    private long approximateAge;
    private long ageThresholdMillis;

    public NodeInfo(Context context, ConflictHandler conflictHandler, String string, long l) {
        this.initialCtx = context;
        this.conHandler = conflictHandler;
        this.name = string;
        this.ageThresholdMillis = l * 1000L;
    }

    synchronized void install(ServiceOffer serviceOffer, boolean bl) {
        try {
            if (!bl) {
                serviceOffer.install(this.initialCtx);
            }
            if (this.installedOffers.size() == 0) {
                this.approximateAge = serviceOffer.approximateAge();
            }
            this.installedOffers.add(serviceOffer);
            if (this.pendingOffers != null) {
                this.conHandler.conflictStart(serviceOffer);
            }
        }
        catch (NamingException namingException) {
            if (this.pendingOffers == null) {
                this.conflictStart(this.installedOffers);
                this.pendingOffers = new ArrayList();
            }
            if (this.approximateAge <= this.ageThresholdMillis && serviceOffer.approximateAge() > this.ageThresholdMillis) {
                this.switchWithInstalledOffers(serviceOffer);
            } else {
                this.pendingOffers.add(serviceOffer);
            }
            this.conHandler.conflictStart(serviceOffer);
        }
    }

    synchronized void update(ServiceOffer serviceOffer, boolean bl) {
        try {
            if (!bl) {
                serviceOffer.update(this.initialCtx);
            }
            if (this.installedOffers.size() == 0) {
                this.approximateAge = serviceOffer.approximateAge();
            }
            this.remove(serviceOffer.getOldID(), serviceOffer.getServerID(), this.installedOffers);
            this.installedOffers.add(serviceOffer);
            if (this.pendingOffers != null) {
                this.conHandler.conflictStart(serviceOffer);
            }
        }
        catch (NamingException namingException) {
            if (this.pendingOffers == null) {
                this.conflictStart(this.installedOffers);
                this.pendingOffers = new ArrayList();
            }
            if (this.approximateAge <= this.ageThresholdMillis && serviceOffer.approximateAge() > this.ageThresholdMillis) {
                this.switchWithInstalledOffers(serviceOffer);
            } else {
                this.pendingOffers.add(serviceOffer);
            }
            this.conHandler.conflictStart(serviceOffer);
        }
    }

    private void switchWithInstalledOffers(ServiceOffer serviceOffer) {
        Iterator iterator = this.installedOffers.iterator();
        while (iterator.hasNext()) {
            ServiceOffer serviceOffer2 = (ServiceOffer)iterator.next();
            iterator.remove();
            try {
                serviceOffer2.retract(this.initialCtx);
                this.pendingOffers.add(serviceOffer2);
            }
            catch (NamingException namingException) {
                throw new AssertionError("Impossible exception", (Throwable)namingException);
            }
        }
        try {
            serviceOffer.install(this.initialCtx);
            this.installedOffers.add(serviceOffer);
            this.approximateAge = serviceOffer.approximateAge();
        }
        catch (NamingException namingException) {
            ClusterLogger.logOfferReplacementError((String)serviceOffer.toString(), (Exception)namingException);
            this.pendingOffers.add(serviceOffer);
        }
    }

    synchronized void retract(ServiceOffer serviceOffer, boolean bl) {
        if (this.remove(serviceOffer.id(), serviceOffer.getServerID(), this.installedOffers)) {
            if (!bl) {
                try {
                    serviceOffer.retract(this.initialCtx);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            if (this.pendingOffers != null) {
                this.conHandler.conflictStop(serviceOffer);
                if (this.installedOffers.isEmpty()) {
                    Iterator iterator = this.pendingOffers.iterator();
                    while (iterator.hasNext()) {
                        ServiceOffer serviceOffer2 = (ServiceOffer)iterator.next();
                        try {
                            serviceOffer2.install(this.initialCtx);
                            iterator.remove();
                            this.installedOffers.add(serviceOffer2);
                        }
                        catch (NamingException namingException) {}
                    }
                }
            }
        } else {
            boolean bl2 = false;
            if (this.pendingOffers != null) {
                bl2 = this.remove(serviceOffer.id(), serviceOffer.getServerID(), this.pendingOffers);
            }
            if (!bl2) {
                ClusterLogger.logRetractUnrecognizedOfferError((String)serviceOffer.toString());
            }
        }
        if (this.pendingOffers != null && this.pendingOffers.isEmpty()) {
            this.conflictStop(this.installedOffers);
            this.pendingOffers = null;
        }
    }

    boolean isEmpty() {
        return this.pendingOffers == null && this.installedOffers.isEmpty();
    }

    private boolean remove(int n, HostID hostID, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ServiceOffer serviceOffer = (ServiceOffer)iterator.next();
            if (!serviceOffer.getServerID().equals(hostID) || serviceOffer.id() != n) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private void conflictStart(Collection collection) {
        for (ServiceOffer serviceOffer : collection) {
            this.conHandler.conflictStart(serviceOffer);
        }
    }

    private void conflictStop(Collection collection) {
        for (ServiceOffer serviceOffer : collection) {
            this.conHandler.conflictStop(serviceOffer);
        }
    }
}

