/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.security.AccessController;
import weblogic.cluster.AnnouncementManager;
import weblogic.cluster.AttributeManager;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.MemberManager;
import weblogic.cluster.MulticastManager;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.work.WorkManagerFactory;

public final class OutboundService
extends AbstractServerService {
    private ClusterMBean clusterMBean;
    private boolean serverVisibleToCluster;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        this.clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (this.clusterMBean != null) {
            try {
                MulticastManager.theOne().resumeNonAdminMulticastSessions();
                AttributeManager.theOne().sendAttributes();
            }
            catch (IOException iOException) {
                throw new ServiceFailureException("Unexpected exception sending attributes", (Throwable)iOException);
            }
            this.sendServerRuntimeState();
            AnnouncementManager.theOne().unblockAnnouncements();
            if ("multicast".equals(this.clusterMBean.getClusterMessagingMode())) {
                ClusterLogger.logJoinedCluster((String)this.clusterMBean.getName(), (String)this.clusterMBean.getMulticastAddress(), (String)(this.clusterMBean.getMulticastPort() + ""));
            }
            this.serverVisibleToCluster = true;
        }
    }

    public void stop() throws ServiceFailureException {
        this.shutdownInternal(false);
    }

    public synchronized void halt() throws ServiceFailureException {
        this.shutdownInternal(true);
    }

    public synchronized void shutdownInternal(boolean bl) throws ServiceFailureException {
        if (this.clusterMBean != null && this.serverVisibleToCluster) {
            ClusterLogger.logOutboundClusterServiceStopped();
            if (bl) {
                WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                    public void run() {
                        if (OutboundService.this.isShuttingDown()) {
                            MulticastManager.theOne().stopHeartbeat();
                        } else {
                            try {
                                MulticastManager.theOne().suspendNonAdminMulticastSessions();
                                OutboundService.this.sendServerRuntimeState();
                            }
                            catch (ServiceFailureException serviceFailureException) {
                                // empty catch block
                            }
                        }
                    }
                });
            } else if (this.isShuttingDown()) {
                MulticastManager.theOne().stopHeartbeat();
            } else {
                MulticastManager.theOne().suspendNonAdminMulticastSessions();
                this.sendServerRuntimeState();
            }
            AnnouncementManager.theOne().blockAnnouncements();
            this.serverVisibleToCluster = false;
        }
    }

    private void sendServerRuntimeState() throws ServiceFailureException {
        if (this.clusterMBean != null) {
            try {
                MemberManager.theOne().sendMemberRuntimeState();
            }
            catch (IOException iOException) {
                throw new ServiceFailureException("Unexpected exception sending  runtime state: ", (Throwable)iOException);
            }
        }
    }

    private boolean isShuttingDown() {
        int n = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getStableState();
        return n == 9;
    }
}

