/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.cluster.RemoteClusterHealthChecker;
import weblogic.jndi.Environment;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public final class RemoteClusterHealthCheckerImpl
implements RemoteClusterHealthChecker,
ClusterMembersChangeListener {
    static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private long currentVersion;
    private final HashSet set = new HashSet();

    public static RemoteClusterHealthCheckerImpl getInstance() {
        return SingletonMaker.singleton;
    }

    private RemoteClusterHealthCheckerImpl() {
        this.updateMembershipInfo(ClusterService.getClusterService().getLocalMember(), true);
    }

    public static void start() {
        try {
            Object object2;
            ClusterService clusterService = ClusterService.getClusterService();
            for (Object object2 : clusterService.getRemoteMembers()) {
                RemoteClusterHealthCheckerImpl.getInstance().updateMembershipInfo((ClusterMemberInfo)object2, true);
            }
            clusterService.addClusterMembersListener(RemoteClusterHealthCheckerImpl.getInstance());
            object2 = new Environment();
            ((Environment)object2).setReplicateBindings(true);
            ((Environment)object2).getInitialContext().bind("weblogic/cluster/RemoteClusterHealthChecker", (Object)RemoteClusterHealthCheckerImpl.getInstance());
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)("Unexpected exception" + namingException.toString()));
        }
    }

    public static void stop() {
        ClusterService.getClusterService().removeClusterMembersListener(RemoteClusterHealthCheckerImpl.getInstance());
        try {
            new InitialContext().unbind("weblogic/cluster/RemoteClusterHealthChecker");
            ServerHelper.unexportObject((Remote)RemoteClusterHealthCheckerImpl.getInstance(), (boolean)false);
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)("Unexpected exception" + namingException.toString()));
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList checkClusterMembership(long l) throws RemoteException {
        HashSet hashSet = null;
        this.verifyCaller();
        Object object = this;
        synchronized (object) {
            if (l == this.currentVersion) {
                return null;
            }
            hashSet = (HashSet)this.set.clone();
        }
        object = new ArrayList(hashSet);
        return object;
    }

    private void verifyCaller() {
        try {
            HostID hostID = ServerHelper.getClientEndPoint().getHostID();
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)SubjectManager.getSubjectManager().getCurrentSubject((AbstractSubject)KERNEL_ID);
            if (authenticatedSubject == null) {
                throw new SecurityException("Null user is not permitted to perform MAN remote cluster membership operations");
            }
            int n = RemoteDomainSecurityHelper.acceptRemoteDomainCall(hostID, authenticatedSubject);
            if (n == 1) {
                throw new SecurityException("user " + authenticatedSubject.getName() + " is not " + "permitted to perform MAN cluster membership operations");
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            throw new SecurityException("operation not permitted");
        }
    }

    public void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        ClusterMemberInfo clusterMemberInfo = clusterMembersChangeEvent.getClusterMemberInfo();
        int n = clusterMembersChangeEvent.getAction();
        if (n == 1) {
            this.updateMembershipInfo(clusterMemberInfo, false);
        } else if (n == 0) {
            this.updateMembershipInfo(clusterMemberInfo, true);
        }
    }

    private synchronized void updateMembershipInfo(ClusterMemberInfo clusterMemberInfo, boolean bl) {
        if (bl) {
            this.set.add(clusterMemberInfo);
        } else {
            this.set.remove(clusterMemberInfo);
        }
        this.currentVersion = 0L;
        for (ClusterMemberInfo clusterMemberInfo2 : this.set) {
            this.currentVersion += (long)clusterMemberInfo2.identity().hashCode();
        }
    }

    public static class SingletonMaker {
        private static final RemoteClusterHealthCheckerImpl singleton = new RemoteClusterHealthCheckerImpl();
    }
}

