/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.RemoteClusterHealthChecker;
import weblogic.cluster.RemoteClusterMembersChangeListener;
import weblogic.jndi.Environment;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.StopTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;

public final class RemoteClusterMemberManager
implements NakedTimerListener,
StopTimerListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final ClusterMBean cluster = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
    private final Environment env = new Environment();
    private final ArrayList listeners = new ArrayList();
    private final int leaseRenewInterval;
    private long version;
    private boolean loggedMessageOnce;
    private RemoteClusterHealthChecker healthChecker;
    private final TimerManager timerFactory;
    private ArrayList currentCandidates;

    public static RemoteClusterMemberManager getInstance() {
        return SingletonMaker.singleton;
    }

    private RemoteClusterMemberManager() {
        if (this.cluster != null) {
            this.leaseRenewInterval = this.cluster.getHealthCheckIntervalMillis();
            this.timerFactory = TimerManagerFactory.getTimerManagerFactory().getTimerManager("RemoteClusterMemberManager");
            this.timerFactory.schedule((TimerListener)this, (long)this.leaseRenewInterval, (long)this.leaseRenewInterval);
        } else {
            this.timerFactory = null;
            this.leaseRenewInterval = 0;
        }
    }

    public synchronized void addRemoteClusterMemberListener(RemoteClusterMembersChangeListener remoteClusterMembersChangeListener) {
        this.listeners.add(remoteClusterMembersChangeListener);
        if (this.currentCandidates != null) {
            ArrayList<RemoteClusterMembersChangeListener> arrayList = new ArrayList<RemoteClusterMembersChangeListener>(1);
            arrayList.add(remoteClusterMembersChangeListener);
            this.fireMembershipChangeEvent(arrayList, this.currentCandidates);
        }
    }

    public void timerStopped(Timer timer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        ArrayList arrayList = null;
        RemoteClusterHealthChecker remoteClusterHealthChecker = this.getHealthChecker();
        ArrayList arrayList2 = null;
        try {
            if (remoteClusterHealthChecker == null) {
                return;
            }
            RemoteClusterMemberManager remoteClusterMemberManager = this;
            synchronized (remoteClusterMemberManager) {
                arrayList2 = (ArrayList)this.listeners.clone();
            }
            arrayList = remoteClusterHealthChecker.checkClusterMembership(this.version);
            if (arrayList != null) {
                this.currentCandidates = arrayList;
                this.version = 0L;
                for (int i = 0; i < arrayList.size(); ++i) {
                    ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)arrayList.get(i);
                    this.version += (long)clusterMemberInfo.identity().hashCode();
                }
                this.fireMembershipChangeEvent(arrayList2, arrayList);
            }
        }
        catch (RemoteException remoteException) {
            this.currentCandidates = null;
            this.healthChecker = null;
            this.version = 0L;
            this.fireMembershipChangeEvent(arrayList2, new ArrayList());
        }
    }

    private void fireMembershipChangeEvent(ArrayList arrayList, ArrayList arrayList2) {
        for (int i = 0; i < arrayList.size(); ++i) {
            RemoteClusterMembersChangeListener remoteClusterMembersChangeListener = (RemoteClusterMembersChangeListener)arrayList.get(i);
            remoteClusterMembersChangeListener.remoteClusterMembersChanged(arrayList2);
        }
    }

    private RemoteClusterHealthChecker getHealthChecker() {
        if (this.healthChecker != null) {
            return this.healthChecker;
        }
        String string = this.cluster.getRemoteClusterAddress();
        if (string == null) {
            return null;
        }
        if (!ServerHelper.isURLValid((String)string)) {
            if (!this.loggedMessageOnce) {
                ClusterLogger.logIncorrectRemoteClusterAddress((String)string);
                this.loggedMessageOnce = true;
            }
            return null;
        }
        try {
            AuthenticatedSubject authenticatedSubject = RemoteDomainSecurityHelper.getSubject(string);
            if (authenticatedSubject == null) {
                authenticatedSubject = SubjectUtils.getAnonymousSubject();
                this.healthChecker = this.lookup(authenticatedSubject, string);
            } else {
                this.healthChecker = this.lookup(authenticatedSubject, string);
                if (this.healthChecker != null) {
                    this.healthChecker = new SecureClusterHealthChecker(this.healthChecker, authenticatedSubject);
                }
            }
            return this.healthChecker;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private RemoteClusterHealthChecker lookup(AuthenticatedSubject authenticatedSubject, final String string) throws RemoteException {
        try {
            Object object = SecurityManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() {
                    RemoteClusterHealthChecker remoteClusterHealthChecker;
                    Context context = null;
                    try {
                        try {
                            RemoteClusterMemberManager.this.env.setProviderUrl(string);
                            RemoteClusterMemberManager.this.env.setRequestTimeout(RemoteClusterMemberManager.this.cluster.getHealthCheckIntervalMillis() * RemoteClusterMemberManager.this.cluster.getIdlePeriodsUntilTimeout());
                            context = RemoteClusterMemberManager.this.env.getInitialContext();
                            remoteClusterHealthChecker = (RemoteClusterHealthChecker)context.lookup("weblogic/cluster/RemoteClusterHealthChecker");
                            Object var5_4 = null;
                        }
                        catch (NamingException namingException) {
                            Object var3_10 = null;
                            Object var5_5 = null;
                            try {
                                if (context == null) return var3_10;
                                context.close();
                                return var3_10;
                            }
                            catch (NamingException namingException3) {
                                // empty catch block
                            }
                            return var3_10;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        try {}
                        catch (NamingException namingException2) {
                            throw throwable;
                        }
                        if (context == null) throw throwable;
                        context.close();
                        throw throwable;
                    }
                    try {}
                    catch (NamingException namingException) {
                        // empty catch block
                        return remoteClusterHealthChecker;
                    }
                    if (context == null) return remoteClusterHealthChecker;
                    context.close();
                    return remoteClusterHealthChecker;
                }
            });
            if (object != null) {
                if (object instanceof RemoteException) {
                    throw (RemoteException)object;
                }
                return (RemoteClusterHealthChecker)object;
            }
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new AssertionError((Object)privilegedActionException);
        }
    }

    private static class SecureClusterHealthChecker
    implements RemoteClusterHealthChecker {
        private final RemoteClusterHealthChecker delegate;
        private final AuthenticatedSubject subject;

        private SecureClusterHealthChecker(RemoteClusterHealthChecker remoteClusterHealthChecker, AuthenticatedSubject authenticatedSubject) {
            this.delegate = remoteClusterHealthChecker;
            this.subject = authenticatedSubject;
        }

        public ArrayList checkClusterMembership(final long l) throws RemoteException {
            if (this.subject == null) {
                return this.delegate.checkClusterMembership(l);
            }
            try {
                Object object = SecurityManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        try {
                            return SecureClusterHealthChecker.this.delegate.checkClusterMembership(l);
                        }
                        catch (RemoteException remoteException) {
                            return remoteException;
                        }
                    }
                });
                if (object instanceof RemoteException) {
                    throw (RemoteException)object;
                }
                return (ArrayList)object;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new AssertionError((Object)privilegedActionException);
            }
        }
    }

    private static class SingletonMaker {
        private static final RemoteClusterMemberManager singleton = new RemoteClusterMemberManager();

        private SingletonMaker() {
        }
    }
}

