/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.cluster.AlternateLivelinessChecker;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterService;
import weblogic.cluster.HybridMulticastReceiver;
import weblogic.cluster.MemberAttributes;
import weblogic.cluster.MemberManager;
import weblogic.cluster.MemberServices;
import weblogic.cluster.MulticastReceiver;
import weblogic.cluster.ServiceOffer;
import weblogic.cluster.ServiceRetract;
import weblogic.common.internal.VersionInfo;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.rmi.spi.HostID;
import weblogic.server.ServiceFailureException;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteMemberInfo {
    private JVMID memberID;
    private MemberServices services;
    private MemberAttributes attributes;
    private ArrayList receiverList;
    private int checksLeft;
    int numUnprocessedMessages;
    private RJVM rjvm;
    private long localJoinTime;
    private int srvrRuntimeState = 9;

    RemoteMemberInfo(HostID hostID, long l) {
        this.memberID = (JVMID)hostID;
        this.services = new MemberServices(hostID);
        this.attributes = null;
        this.receiverList = new ArrayList();
        this.checksLeft = MemberManager.theOne().getIdlePeriodsUntilTimeout();
        this.rjvm = RJVMManager.getRJVMManager().find(this.memberID);
        if (this.rjvm != null) {
            this.rjvm.addPeerGoneListener((PeerGoneListener)MemberManager.theOne());
        }
        this.localJoinTime = l;
    }

    MemberAttributes getAttributes() {
        return this.attributes;
    }

    RJVM getRJVM() {
        if (this.rjvm == null) {
            this.rjvm = RJVMManager.getRJVMManager().find(this.memberID);
            if (this.rjvm != null) {
                this.rjvm.addPeerGoneListener((PeerGoneListener)MemberManager.theOne());
            }
        }
        return this.rjvm;
    }

    void resetTimeout() {
        this.checksLeft = MemberManager.theOne().getIdlePeriodsUntilTimeout();
        RJVM rJVM = this.getRJVM();
        if (rJVM != null) {
            this.rjvm.messageReceived();
        }
        AlternateLivelinessChecker.getInstance().reachable((HostID)this.memberID);
    }

    boolean checkTimeout() {
        if (this.checksLeft > 0) {
            --this.checksLeft;
            return false;
        }
        MulticastReceiver multicastReceiver = this.findOrCreateReceiver(2, true);
        if (multicastReceiver == null) {
            return true;
        }
        return AlternateLivelinessChecker.getInstance().isUnreachable(multicastReceiver.getCurrentSeqNum(), (HostID)this.memberID);
    }

    MemberServices getMemberServices() {
        return this.services;
    }

    void forceTimeout() {
        this.checksLeft = 0;
    }

    void shutdown() {
        this.updateRuntimeState(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownInternal() {
        ArrayList arrayList = this.receiverList;
        synchronized (arrayList) {
            for (MulticastReceiver multicastReceiver : this.receiverList) {
                if (multicastReceiver == null) continue;
                multicastReceiver.shutdown();
            }
            this.receiverList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspend() {
        if (this.attributes != null) {
            MemberManager.theOne().fireClusterMembersChangeEvent(this.attributes, 1);
        }
        Object object = this.services;
        synchronized (object) {
            this.services.retractAllOffers(false);
        }
        object = this.findOrCreateReceiver(2, true);
        ((MulticastReceiver)object).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MulticastReceiver findOrCreateReceiver(int n, boolean bl) {
        ArrayList arrayList = this.receiverList;
        synchronized (arrayList) {
            while (this.receiverList.size() <= n) {
                this.receiverList.add(null);
            }
            MulticastReceiver multicastReceiver = (MulticastReceiver)this.receiverList.get(n);
            if (multicastReceiver == null) {
                multicastReceiver = bl ? new HybridMulticastReceiver((HostID)this.memberID, n, WorkManagerFactory.getInstance().getSystem()) : new MulticastReceiver((HostID)this.memberID, n, ClusterService.MULTICAST_WORKMANAGER);
                this.receiverList.set(n, multicastReceiver);
            }
            return multicastReceiver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MulticastReceiver> getReceivers() {
        ArrayList<MulticastReceiver> arrayList = new ArrayList<MulticastReceiver>();
        ArrayList arrayList2 = this.receiverList;
        synchronized (arrayList2) {
            for (Object e : this.receiverList) {
                if (!(e instanceof MulticastReceiver)) continue;
                arrayList.add((MulticastReceiver)e);
            }
        }
        return arrayList;
    }

    synchronized void processAttributes(MemberAttributes memberAttributes) {
        if (this.attributes == null) {
            if (!VersionInfo.theOne().compatible(memberAttributes.version())) {
                ClusterLogger.logIncompatibleVersionsError((String)VersionInfo.theOne().getReleaseVersion(), (String)memberAttributes.serverName(), (String)memberAttributes.version());
                if (memberAttributes.joinTime() <= this.localJoinTime) {
                    ClusterLogger.logIncompatibleServerLeavingCluster();
                    WorkAdapter workAdapter = new WorkAdapter(){

                        public void run() {
                            try {
                                ClusterService.getClusterService().getActivator().stop();
                            }
                            catch (ServiceFailureException serviceFailureException) {
                                serviceFailureException.printStackTrace();
                            }
                        }
                    };
                    WorkManagerFactory.getInstance().getSystem().schedule((Runnable)workAdapter);
                }
            } else {
                ClusterMemberInfo clusterMemberInfo = ClusterService.getServices().getLocalMember();
                if (!clusterMemberInfo.domainName().equals(memberAttributes.domainName())) {
                    ClusterLogger.logMultipleDomainsCannotUseSameMulticastAddress((String)clusterMemberInfo.domainName(), (String)memberAttributes.domainName());
                } else if (!clusterMemberInfo.clusterName().equals(memberAttributes.clusterName())) {
                    ClusterLogger.logMultipleClustersCannotUseSameMulticastAddress((String)clusterMemberInfo.clusterName(), (String)memberAttributes.clusterName());
                } else {
                    this.attributes = memberAttributes;
                    this.updateRuntimeState(2);
                }
            }
        } else {
            MemberManager.theOne().fireClusterMembersChangeEvent(memberAttributes, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processAnnouncement(Collection collection) {
        MemberServices memberServices = this.services;
        synchronized (memberServices) {
            for (Object e : collection) {
                Serializable serializable;
                try {
                    serializable = (ServiceRetract)e;
                    if (((ServiceRetract)serializable).ignoreRetract()) continue;
                    this.services.processRetract((ServiceRetract)serializable, false);
                }
                catch (ClassCastException classCastException) {
                    try {
                        serializable = (ServiceOffer)e;
                        if (serializable.getOldID() != -1) {
                            this.services.processUpdate((ServiceOffer)serializable, false, serializable.getOldID());
                            continue;
                        }
                        this.services.processOffer((ServiceOffer)serializable, false);
                    }
                    catch (ClassCastException classCastException2) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStateDump(Collection collection, int n, long l) {
        MemberServices memberServices = this.services;
        synchronized (memberServices) {
            this.services.retractAllOffers(false);
            Object object = collection;
            synchronized (object) {
                for (ServiceOffer serviceOffer : collection) {
                    this.services.processOffer(serviceOffer, false);
                }
            }
            object = this.findOrCreateReceiver(n, true);
            ((MulticastReceiver)object).setInSync(l);
        }
    }

    public String toString() {
        return this.memberID.getHostAddress().toString();
    }

    void updateRuntimeState(int n) {
        switch (this.srvrRuntimeState) {
            case 9: {
                if (n == 2) {
                    this.add();
                    break;
                }
                if (n == 17) {
                    this.discover();
                    break;
                }
                if (n != 9) break;
                this.suspend();
                this.shutdownInternal();
                break;
            }
            case 17: {
                if (n == 2) {
                    this.add();
                    break;
                }
                if (n != 9) break;
                this.shutdownInternal();
                break;
            }
            case 2: {
                if (n == 17) {
                    this.suspend();
                    break;
                }
                if (n != 9) break;
                this.suspend();
                this.shutdownInternal();
            }
        }
        this.srvrRuntimeState = n;
    }

    boolean isRunning() {
        return this.srvrRuntimeState == 2;
    }

    boolean isSuspended() {
        return this.srvrRuntimeState == 17;
    }

    private void add() {
        MemberManager.theOne().fireClusterMembersChangeEvent(this.attributes, 0);
        ClusterLogger.logAddingServer((String)this.attributes.serverName(), (String)this.attributes.clusterName(), (String)this.attributes.identity().toString());
    }

    private void discover() {
        MemberManager.theOne().fireClusterMembersChangeEvent(this.attributes, 3);
    }

    void dumpDiagnosticImageData(XMLStreamWriter xMLStreamWriter) throws XMLStreamException, IOException {
        xMLStreamWriter.writeStartElement("RemoteMemberInfo");
        xMLStreamWriter.writeAttribute("HostAddress", this.toString());
        for (MulticastReceiver multicastReceiver : this.getReceivers()) {
            multicastReceiver.dumpDiagnosticImageData(xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
    }
}

