/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MemberAttributes;
import weblogic.cluster.MemberManager;
import weblogic.cluster.RemoteMemberInfo;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.rmi.spi.HostID;

final class RuntimeStateMessage
implements GroupMessage,
Externalizable {
    private static final long serialVersionUID = 2610797619397430239L;
    private int srvrRuntimeState;
    private MemberAttributes memberAttributes;
    private long currentSeqNum = -1L;

    RuntimeStateMessage(int n, MemberAttributes memberAttributes, long l) {
        this.srvrRuntimeState = n;
        this.memberAttributes = memberAttributes;
        this.currentSeqNum = l;
    }

    public void execute(HostID hostID) {
        this.processAttributes(this.memberAttributes);
        MemberManager.theOne().updateMemberRuntimeState(hostID, this.srvrRuntimeState, this.currentSeqNum);
    }

    public String toString() {
        return "State:" + this.srvrRuntimeState;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ((WLObjectOutput)objectOutput).writeInt(this.srvrRuntimeState);
        ((WLObjectOutput)objectOutput).writeObjectWL((Object)this.memberAttributes);
        objectOutput.writeLong(this.currentSeqNum);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.srvrRuntimeState = ((WLObjectInput)objectInput).readInt();
        this.memberAttributes = (MemberAttributes)((WLObjectInput)objectInput).readObjectWL();
        if (objectInput.available() > 0) {
            this.currentSeqNum = objectInput.readLong();
        }
    }

    public RuntimeStateMessage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttributes(MemberAttributes memberAttributes) {
        RemoteMemberInfo remoteMemberInfo = MemberManager.theOne().findOrCreate((HostID)memberAttributes.identity());
        try {
            if (remoteMemberInfo.getAttributes() == null) {
                remoteMemberInfo.processAttributes(memberAttributes);
            }
            Object var4_3 = null;
            MemberManager.theOne().done(remoteMemberInfo);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            MemberManager.theOne().done(remoteMemberInfo);
            throw throwable;
        }
    }
}

