/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import weblogic.cluster.AdvertisementStatusListener;
import weblogic.cluster.AnnouncementManager;
import weblogic.cluster.BasicServiceOffer;
import weblogic.cluster.CompositeKey;
import weblogic.cluster.ServiceRec;
import weblogic.cluster.ServiceRetract;
import weblogic.cluster.UpgradeUtils;
import weblogic.common.internal.PeerInfo;
import weblogic.utils.Debug;

public final class ServiceAdvertiser {
    private int nextServiceID = 0;
    private Map serviceMap = new HashMap();

    public static ServiceAdvertiser theOne() {
        return SingletonMaker.singleton;
    }

    private ServiceAdvertiser() {
    }

    public void offerService(String string, String string2, Object object) throws NamingException {
        this.offerService(string, string2, object, null);
    }

    public void createSubcontext(String string) throws NamingException {
        this.offerService(string, null, null, null);
    }

    public void offerService(String string, String string2, Object object, AdvertisementStatusListener advertisementStatusListener) throws NamingException {
        this.announceOffer(string, string2, object);
    }

    public void replaceService(String string, String string2, Object object, Object object2) throws NamingException {
        this.announceReplacement(string, string2, object, object2);
    }

    public void retractService(String string, String string2, Object object) throws NamingException {
        this.announceReplacement(string, string2, object, null);
    }

    private synchronized void announceOffer(String string, String string2, Object object) throws NamingException {
        int n = this.getNextServiceID();
        BasicServiceOffer basicServiceOffer = new BasicServiceOffer(n, string, string2, object);
        AnnouncementManager.theOne().announce(null, basicServiceOffer);
        this.addToMap(new CompositeKey(string, string2), object, n);
    }

    private final synchronized void announceReplacement(String string, String string2, Object object, Object object2) throws NamingException {
        int n;
        ServiceRetract serviceRetract = null;
        BasicServiceOffer basicServiceOffer = null;
        CompositeKey compositeKey = new CompositeKey(string, string2);
        ServiceRec serviceRec = this.getRecordFromMap(compositeKey, object);
        int n2 = -1;
        if (serviceRec != null) {
            n2 = n = serviceRec.id;
            serviceRetract = object2 != null ? new ServiceRetract(n, true) : new ServiceRetract(n, false);
        }
        if (object2 != null) {
            n = this.getNextServiceID();
            this.addToMap(compositeKey, object2, n);
            basicServiceOffer = new BasicServiceOffer(n, string, string2, object2, n2);
        }
        if (serviceRetract != null || basicServiceOffer != null) {
            AnnouncementManager.theOne().announce(serviceRetract, basicServiceOffer);
            if (serviceRetract != null) {
                this.removeFromMap(compositeKey, serviceRec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextServiceID() {
        Map map = this.serviceMap;
        synchronized (map) {
            return this.nextServiceID++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addToMap(CompositeKey compositeKey, Object object, int n) {
        Map map = this.serviceMap;
        synchronized (map) {
            Object v = this.serviceMap.get(compositeKey);
            ArrayList<ServiceRec> arrayList = (ArrayList<ServiceRec>)v;
            if (v == null) {
                arrayList = new ArrayList<ServiceRec>(1);
                this.serviceMap.put(compositeKey, arrayList);
            }
            arrayList.add(new ServiceRec(n, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ServiceRec getRecordFromMap(CompositeKey compositeKey, Object object) {
        Map map = this.serviceMap;
        synchronized (map) {
            List list = (List)this.serviceMap.get(compositeKey);
            if (list == null) {
                return null;
            }
            Debug.assertion((list.size() != 0 ? 1 : 0) != 0);
            if (object == null) {
                return (ServiceRec)list.get(0);
            }
            ServiceRec serviceRec = new ServiceRec(-1, object);
            int n = list.indexOf(serviceRec);
            if (n != -1) {
                return (ServiceRec)list.get(n);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFromMap(CompositeKey compositeKey, ServiceRec serviceRec) {
        Map map = this.serviceMap;
        synchronized (map) {
            int n;
            List list = (List)this.serviceMap.get(compositeKey);
            if (list != null && (n = list.indexOf(serviceRec)) != -1) {
                list.remove(n);
                if (list.size() == 0) {
                    this.serviceMap.remove(compositeKey);
                }
            }
        }
    }

    synchronized void rewriteServicesAtNewVersion(PeerInfo peerInfo, PeerInfo peerInfo2) {
        for (Map.Entry entry : this.serviceMap.entrySet()) {
            CompositeKey compositeKey = (CompositeKey)entry.getKey();
            List list = (List)entry.getValue();
            if (list == null || list.size() == 0) continue;
            ServiceRec serviceRec = (ServiceRec)list.get(0);
            try {
                if (!UpgradeUtils.needsRewrite(serviceRec.service, peerInfo, peerInfo2)) continue;
                try {
                    this.announceReplacement(compositeKey.name, compositeKey.appId, serviceRec.service, serviceRec.service);
                }
                catch (NamingException namingException) {
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static class SingletonMaker {
        private static final ServiceAdvertiser singleton = new ServiceAdvertiser();

        private SingletonMaker() {
        }
    }
}

