/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import weblogic.cluster.AnnouncementManager;
import weblogic.cluster.GroupMessage;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.rmi.spi.HostID;

final class StateDumpMessage
implements GroupMessage,
Externalizable {
    private static final long serialVersionUID = -3278918830125969257L;
    ArrayList offers;
    int senderNum;
    long currentSeqNum;

    StateDumpMessage(ArrayList arrayList, int n, long l) {
        this.offers = arrayList;
        this.senderNum = n;
        this.currentSeqNum = l;
    }

    public void execute(HostID hostID) {
        AnnouncementManager.theOne().receiveStateDump(hostID, this);
    }

    public String toString() {
        return "StateDump numOffers:" + this.offers.size() + " seqNum " + this.currentSeqNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ArrayList arrayList = this.offers;
        synchronized (arrayList) {
            ((WLObjectOutput)objectOutput).writeArrayList(this.offers);
        }
        objectOutput.writeInt(this.senderNum);
        objectOutput.writeLong(this.currentSeqNum);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.offers = ((WLObjectInput)objectInput).readArrayList();
        this.senderNum = objectInput.readInt();
        this.currentSeqNum = objectInput.readLong();
    }

    public StateDumpMessage() {
    }
}

