/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.cluster.AnnouncementManager;
import weblogic.cluster.AttributeManager;
import weblogic.cluster.ClusterAnnouncementsDebugLogger;
import weblogic.cluster.ClusterHelper;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterService;
import weblogic.cluster.MemberAttributes;
import weblogic.cluster.MemberManager;
import weblogic.cluster.MulticastReplacer;
import weblogic.cluster.MulticastSessionIDConstants;
import weblogic.cluster.RemoteMemberInfo;
import weblogic.cluster.StateDumpMessage;
import weblogic.cluster.UpgradeUtils;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerChannelStream;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public final class StateDumpServlet
extends HttpServlet
implements MulticastSessionIDConstants {
    private static final int DEFAULT_BUF_SIZE = 10240;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("ServerName");
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        int n = httpServletRequest.getContentLength();
        if (n <= 0) {
            httpServletResponse.sendError(403, "Invalid content-length: " + n);
            return;
        }
        byte[] byArray = new byte[n];
        DataIO.readFully((InputStream)httpServletRequest.getInputStream(), (byte[])byArray);
        if (!ClusterService.getClusterService().checkRequest(string, byArray)) {
            String string2 = ClusterHelper.encodeXSS(string);
            httpServletResponse.sendError(403, this.getServerHashInvalidMessage(string2));
            return;
        }
        if (ClusterService.getClusterService().multicastDataEncryptionEnabled() && !httpServletRequest.isSecure()) {
            ClusterLogger.logEnforceSecureRequest();
            String string3 = ClusterHelper.encodeXSS(string);
            httpServletResponse.sendError(403, this.getUnsecureMulticastMessage(string3));
            return;
        }
        String string4 = httpServletRequest.getParameter("PeerInfo");
        PeerInfo peerInfo = ClusterHelper.getPeerInfo(string4);
        Debug.assertion((peerInfo != null ? 1 : 0) != 0, (String)"Peer info cannot be null");
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        OutputStream outputStream = null;
        try {
            unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(10240);
            ServerChannel serverChannel = ((ServerChannelStream)httpServletRequest).getServerChannel();
            objectOutputStream = UpgradeUtils.getInstance().getOutputStream(unsyncByteArrayOutputStream, ServerChannelManager.findDefaultLocalServerChannel(), peerInfo);
            ArrayList arrayList = (ArrayList)MemberManager.theOne().getRemoteMembers();
            if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
                ClusterAnnouncementsDebugLogger.debug("Sending statedump for " + (arrayList.size() + 1) + " servers");
            }
            objectOutputStream.writeInt(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                MemberAttributes memberAttributes = (MemberAttributes)arrayList.get(i);
                RemoteMemberInfo remoteMemberInfo = MemberManager.theOne().findOrCreate((HostID)memberAttributes.identity());
                try {
                    ServerIdentity serverIdentity = remoteMemberInfo.getAttributes().identity();
                    ((WLObjectOutputStream)objectOutputStream).setReplacer(new MulticastReplacer((HostID)serverIdentity));
                    MemberAttributes memberAttributes2 = remoteMemberInfo.getAttributes();
                    ((WLObjectOutputStream)objectOutputStream).writeObjectWL(memberAttributes2);
                    ArrayList arrayList2 = remoteMemberInfo.getMemberServices().getAllOffers();
                    long l = remoteMemberInfo.findOrCreateReceiver(2, true).getCurrentSeqNum();
                    StateDumpMessage stateDumpMessage = new StateDumpMessage(arrayList2, 2, l);
                    long l2 = 3L * ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getServerStartupTime();
                    if (l2 == 0L) {
                        l2 = 3600000L;
                    }
                    if (AttributeManager.theOne().getLocalAttributes().joinTime() - memberAttributes2.joinTime() < l2 || (long)arrayList2.size() != l) {
                        stateDumpMessage = null;
                    }
                    if (ClusterAnnouncementsDebugLogger.isDebugEnabled()) {
                        if (stateDumpMessage != null) {
                            ClusterAnnouncementsDebugLogger.debug("Sending offers of size " + arrayList2.size() + " of " + serverIdentity + " and seq num " + stateDumpMessage.currentSeqNum);
                        } else {
                            ClusterAnnouncementsDebugLogger.debug("Not sending statedump on behalf  of other server because other server has not been up long enough  for data to be guaranteed consistent.");
                        }
                    }
                    objectOutputStream.writeObject(stateDumpMessage);
                    continue;
                }
                finally {
                    MemberManager.theOne().done(remoteMemberInfo);
                }
            }
            ((WLObjectOutputStream)objectOutputStream).setReplacer(new MulticastReplacer((HostID)LocalServerIdentity.getIdentity()));
            objectOutputStream.writeObject(AttributeManager.theOne().getLocalAttributes());
            objectOutputStream.writeObject(AnnouncementManager.theOne().createRecoverMessage());
            objectOutputStream.flush();
            httpServletResponse.setContentType("application/unknown");
            outputStream = httpServletResponse.getOutputStream();
            httpServletResponse.setContentLength(unsyncByteArrayOutputStream.size());
            unsyncByteArrayOutputStream.writeTo(outputStream);
            outputStream.flush();
        }
        finally {
            try {
                if (unsyncByteArrayOutputStream != null) {
                    unsyncByteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getServerHashInvalidMessage(String string) {
        return "The server hash received from '" + string + "' is invalid. " + "The request was rejected by " + ClusterService.getClusterService().getLocalServerDetails();
    }

    private String getUnsecureMulticastMessage(String string) {
        return "An unsecure statedump request was sent by '" + string + "'. Statedump requests must be encrypted when encrypted multicast " + "option is turned on. The request was rejected by " + ClusterService.getClusterService().getLocalServerDetails();
    }
}

