/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.BasicConflictHandler;
import weblogic.cluster.ConflictHandler;
import weblogic.cluster.NodeInfo;
import weblogic.cluster.ServiceOffer;
import weblogic.jndi.Environment;
import weblogic.utils.AssertionError;

public final class TreeManager {
    private static TreeManager theTreeManager = null;
    private Map nodes;
    private Context initialCtx;
    private ConflictHandler conHandler;
    private long ageThreshold;

    static TreeManager theOne() {
        return theTreeManager;
    }

    static void initialize(long l) {
        theTreeManager = new TreeManager(l);
    }

    private TreeManager(long l) {
        try {
            Environment environment = new Environment();
            environment.setReplicateBindings(false);
            environment.setCreateIntermediateContexts(true);
            this.initialCtx = environment.getInitialContext();
        }
        catch (NamingException namingException) {
            throw new AssertionError("Failed to create initial context", (Throwable)namingException);
        }
        this.conHandler = new BasicConflictHandler();
        this.nodes = new HashMap();
        this.ageThreshold = l;
    }

    void install(ServiceOffer serviceOffer, boolean bl) {
        NodeInfo nodeInfo = this.find(serviceOffer.name());
        nodeInfo.install(serviceOffer, bl);
        this.done(nodeInfo);
    }

    void retract(ServiceOffer serviceOffer, boolean bl) {
        NodeInfo nodeInfo = this.find(serviceOffer.name());
        nodeInfo.retract(serviceOffer, bl);
        this.doneRemove(nodeInfo, serviceOffer.name());
    }

    void update(ServiceOffer serviceOffer, boolean bl) {
        NodeInfo nodeInfo = this.find(serviceOffer.name());
        nodeInfo.update(serviceOffer, bl);
        this.done(nodeInfo);
    }

    private synchronized NodeInfo find(String string) {
        NodeInfo nodeInfo = (NodeInfo)this.nodes.get(string);
        if (nodeInfo == null) {
            nodeInfo = new NodeInfo(this.initialCtx, this.conHandler, string, this.ageThreshold);
            this.nodes.put(string, nodeInfo);
            nodeInfo.numUnprocessedRequests = 1;
        } else {
            ++nodeInfo.numUnprocessedRequests;
        }
        return nodeInfo;
    }

    private synchronized void done(NodeInfo nodeInfo) {
        --nodeInfo.numUnprocessedRequests;
    }

    private synchronized void doneRemove(NodeInfo nodeInfo, String string) {
        --nodeInfo.numUnprocessedRequests;
        if (nodeInfo.numUnprocessedRequests == 0 && nodeInfo.isEmpty()) {
            this.nodes.remove(string);
        }
    }
}

