/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import weblogic.cluster.ClusterDebugLogger;
import weblogic.cluster.ClusterHelper;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.MemberManager;
import weblogic.cluster.MulticastReplacer;
import weblogic.cluster.ServiceAdvertiser;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.utils.io.Replacer;
import weblogic.utils.io.UnsyncByteArrayOutputStream;
import weblogic.work.WorkManagerFactory;

public final class UpgradeUtils
implements ClusterMembersChangeListener {
    private static UpgradeUtils THE_ONE;
    private Map peerInfoMap;
    private PeerInfo clusterVersion = this.getClusterVersion();
    private PeerInfoComparator peerInfoComparator;

    private UpgradeUtils() {
        if (ClusterDebugLogger.isDebugEnabled()) {
            ClusterDebugLogger.debug("[UPGRADE] startup peer info=" + this.clusterVersion);
        }
        this.peerInfoComparator = new PeerInfoComparator();
        this.peerInfoMap = new HashMap();
        this.peerInfoMap.put("_local_", VersionInfoFactory.getPeerInfo());
        if (KernelStatus.isServer()) {
            MemberManager.theOne().addClusterMembersListener(this);
        }
    }

    public static synchronized UpgradeUtils getInstance() {
        if (THE_ONE != null) {
            return THE_ONE;
        }
        THE_ONE = new UpgradeUtils();
        return THE_ONE;
    }

    private synchronized PeerInfo getClusterVersion() {
        if (this.clusterVersion == null) {
            this.clusterVersion = VersionInfoFactory.getPeerInfo();
        }
        if (ClusterDebugLogger.isDebugEnabled()) {
            ClusterDebugLogger.debug("[UPGRADE] cluster version string=" + this.clusterVersion);
        }
        return this.clusterVersion;
    }

    public synchronized PeerInfo getServerVersion(String string) {
        return (PeerInfo)this.peerInfoMap.get(string);
    }

    public synchronized PeerInfo getNewestServerVersion() {
        return (PeerInfo)Collections.max(this.peerInfoMap.values(), this.peerInfoComparator);
    }

    public synchronized void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        if (clusterMembersChangeEvent.getAction() == 0) {
            if (this.peerInfoMap.get(clusterMembersChangeEvent.getClusterMemberInfo().serverName()) == null) {
                if (ClusterDebugLogger.isDebugEnabled()) {
                    ClusterDebugLogger.debug("[UPGRADE] cluster member added=" + clusterMembersChangeEvent.getClusterMemberInfo().peerInfo() + ", serverName=" + clusterMembersChangeEvent.getClusterMemberInfo().serverName());
                }
                this.peerInfoMap.put(clusterMembersChangeEvent.getClusterMemberInfo().serverName(), clusterMembersChangeEvent.getClusterMemberInfo().peerInfo());
            }
        } else if (clusterMembersChangeEvent.getAction() == 1 && this.peerInfoMap.remove(clusterMembersChangeEvent.getClusterMemberInfo().serverName()) != null && ClusterDebugLogger.isDebugEnabled()) {
            ClusterDebugLogger.debug("[UPGRADE] cluster member removed=" + clusterMembersChangeEvent.getClusterMemberInfo().peerInfo() + ", serverName=" + clusterMembersChangeEvent.getClusterMemberInfo().serverName());
        }
        this.clusterVersion = (PeerInfo)Collections.min(this.peerInfoMap.values(), this.peerInfoComparator);
        if (ClusterDebugLogger.isDebugEnabled()) {
            ClusterDebugLogger.debug("[UPGRADE] new cluster version=" + this.clusterVersion);
        }
    }

    synchronized Replacer getInteropReplacer() {
        return RemoteObjectReplacer.getReplacer((PeerInfo)this.clusterVersion);
    }

    public void test() {
        PeerInfo peerInfo = this.clusterVersion;
        this.clusterVersion = VersionInfoFactory.getPeerInfo("9.0.2.0");
        this.rewriteServiceOffersAtNewVersion(peerInfo, this.clusterVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needsRewrite(Object object, PeerInfo peerInfo, PeerInfo peerInfo2) throws IOException {
        boolean bl;
        PeerInfoableObjectOutput peerInfoableObjectOutput;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream;
        block7: {
            if (!(object instanceof Externalizable) && !(object instanceof InteropWriteReplaceable)) {
                return false;
            }
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream2 = null;
            unsyncByteArrayOutputStream = null;
            peerInfoableObjectOutput = null;
            try {
                unsyncByteArrayOutputStream2 = new UnsyncByteArrayOutputStream();
                peerInfoableObjectOutput = new PeerInfoableObjectOutput(unsyncByteArrayOutputStream2, peerInfo);
                peerInfoableObjectOutput.setReplacer(new MulticastReplacer((HostID)LocalServerIdentity.getIdentity()));
                peerInfoableObjectOutput.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
                peerInfoableObjectOutput.writeObjectWL(object);
                peerInfoableObjectOutput.flush();
                peerInfoableObjectOutput.close();
                unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                peerInfoableObjectOutput = new PeerInfoableObjectOutput(unsyncByteArrayOutputStream, peerInfo2);
                peerInfoableObjectOutput.setReplacer(new MulticastReplacer((HostID)LocalServerIdentity.getIdentity()));
                peerInfoableObjectOutput.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
                peerInfoableObjectOutput.writeObjectWL(object);
                peerInfoableObjectOutput.flush();
                bl = !Arrays.equals(unsyncByteArrayOutputStream2.toRawBytes(), unsyncByteArrayOutputStream.toRawBytes());
                Object var8_7 = null;
                if (unsyncByteArrayOutputStream2 == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var8_8 = null;
                    if (unsyncByteArrayOutputStream2 != null) {
                        unsyncByteArrayOutputStream2.close();
                    }
                    if (unsyncByteArrayOutputStream != null) {
                        unsyncByteArrayOutputStream.close();
                    }
                    if (peerInfoableObjectOutput == null) break block8;
                    peerInfoableObjectOutput.close();
                }
                throw throwable;
            }
            unsyncByteArrayOutputStream2.close();
        }
        if (unsyncByteArrayOutputStream != null) {
            unsyncByteArrayOutputStream.close();
        }
        if (peerInfoableObjectOutput != null) {
            peerInfoableObjectOutput.close();
        }
        return bl;
    }

    private void rewriteServiceOffersAtNewVersion(final PeerInfo peerInfo, final PeerInfo peerInfo2) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                ServiceAdvertiser.theOne().rewriteServicesAtNewVersion(peerInfo, peerInfo2);
            }
        });
    }

    synchronized WLObjectOutputStream getOutputStream(UnsyncByteArrayOutputStream unsyncByteArrayOutputStream, ServerChannel serverChannel) throws IOException {
        return this.getOutputStream(unsyncByteArrayOutputStream, serverChannel, this.clusterVersion);
    }

    synchronized WLObjectOutputStream getOutputStream(UnsyncByteArrayOutputStream unsyncByteArrayOutputStream, ServerChannel serverChannel, PeerInfo peerInfo) throws IOException {
        PeerInfoableObjectOutput peerInfoableObjectOutput = new PeerInfoableObjectOutput(unsyncByteArrayOutputStream, peerInfo);
        peerInfoableObjectOutput.setReplacer(new MulticastReplacer((HostID)LocalServerIdentity.getIdentity()));
        if (serverChannel != null) {
            peerInfoableObjectOutput.setServerChannel(serverChannel);
        }
        return peerInfoableObjectOutput;
    }

    public boolean acceptVersion(String string) {
        PeerInfo peerInfo = VersionInfoFactory.getPeerInfo(string);
        if (ClusterDebugLogger.isDebugEnabled()) {
            ClusterDebugLogger.debug("[UPGRADE] comparing [" + VersionInfoFactory.getPeerInfo() + "] with remote version [" + peerInfo + "] with result=" + this.peerInfoComparator.compare(VersionInfoFactory.getPeerInfo(), peerInfo));
        }
        return this.peerInfoComparator.compare(VersionInfoFactory.getPeerInfo(), peerInfo) >= 0;
    }

    public String getLocalServerVersion() {
        return ClusterHelper.STRINGFIED_PEERINFO;
    }

    private static String stringfyPeerInfo(PeerInfo peerInfo) {
        return peerInfo.getMajor() + "," + peerInfo.getMinor() + "," + peerInfo.getServicePack();
    }

    private static class PeerInfoComparator
    implements Comparator {
        private PeerInfoComparator() {
        }

        public int compare(Object object, Object object2) {
            PeerInfo peerInfo = (PeerInfo)object;
            PeerInfo peerInfo2 = (PeerInfo)object2;
            int n = peerInfo.getMajor() - peerInfo2.getMajor();
            if (n != 0) {
                return n;
            }
            n = peerInfo.getMinor() - peerInfo2.getMinor();
            if (n != 0) {
                return n;
            }
            n = peerInfo.getServicePack() - peerInfo2.getServicePack();
            if (n != 0) {
                return n;
            }
            return 0;
        }
    }

    static final class PeerInfoableObjectOutput
    extends WLObjectOutputStream
    implements PeerInfoable {
        private PeerInfo peerInfo;

        PeerInfoableObjectOutput(UnsyncByteArrayOutputStream unsyncByteArrayOutputStream, PeerInfo peerInfo) throws IOException {
            super((OutputStream)unsyncByteArrayOutputStream);
            this.peerInfo = peerInfo;
        }

        public PeerInfo getPeerInfo() {
            return this.peerInfo;
        }

        public String getClusterVersion() {
            return UpgradeUtils.stringfyPeerInfo(this.peerInfo);
        }
    }
}

