/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.security.AccessController;
import weblogic.cluster.ClusterService;
import weblogic.cluster.leasing.databaseless.ClusterFormationMessage;
import weblogic.cluster.leasing.databaseless.ClusterFormationResponse;
import weblogic.cluster.leasing.databaseless.ClusterFormationService;
import weblogic.cluster.leasing.databaseless.ClusterGroupView;
import weblogic.cluster.leasing.databaseless.ClusterState;
import weblogic.cluster.leasing.databaseless.DisconnectActionListener;
import weblogic.cluster.leasing.databaseless.EnvironmentFactory;
import weblogic.cluster.leasing.databaseless.JoinResponseMessage;
import weblogic.cluster.leasing.databaseless.LeaseView;
import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageFactory;
import weblogic.cluster.messaging.internal.ClusterMessageProcessingException;
import weblogic.cluster.messaging.internal.ClusterMessageSender;
import weblogic.cluster.messaging.internal.ClusterResponse;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.SRMResult;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.messaging.internal.ServerInformationImpl;
import weblogic.health.HealthMonitorService;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLifecycleException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class ClusterFormationServiceImpl
implements ClusterFormationService,
TimerListener,
DisconnectActionListener {
    private static final DebugCategory debugClusterFormation = Debug.getCategory((String)"weblogic.cluster.leasing.ClusterFormation");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean DEBUG = ClusterFormationServiceImpl.debugEnabled();
    private static final int FORMATION_RETRY_PERIOD = 5000;
    private ServerInformation localInformation;
    private ClusterGroupView groupView;
    private LeaseView leaseView;
    private SRMResult result;

    public void start(ClusterGroupView clusterGroupView, LeaseView leaseView) {
        if (!ClusterState.getInstance().setState("formation_leader")) {
            if (DEBUG) {
                ClusterFormationServiceImpl.debug("unable to transition from " + ClusterState.getInstance().getState() + " to " + "formation_leader");
            }
            return;
        }
        this.groupView = clusterGroupView;
        this.leaseView = leaseView;
        this.localInformation = ClusterFormationServiceImpl.createLocalServerInformation();
        if (DEBUG) {
            ClusterFormationServiceImpl.debug("starting cluster formation with group view " + clusterGroupView + " and leaseView " + leaseView);
        }
        if (!this.ensureServerReachabilityMajority()) {
            if (DEBUG) {
                ClusterFormationServiceImpl.debug("SRM CHECK RETURNED FALSE ! cannot create the cluster");
            }
            this.OnLosingServerReachabilityMajority();
            return;
        }
        EnvironmentFactory.getClusterMemberDisconnectMonitor().start(this.groupView, this);
        try {
            if (!this.formClusterInternal()) {
                TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this, 5000L, 5000L);
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.formationFailed(illegalStateException);
        }
    }

    private boolean formClusterInternal() {
        ServerInformation[] serverInformationArray = this.groupView.getRemoteMembers(this.localInformation);
        if (serverInformationArray.length == 0) {
            if (DEBUG) {
                ClusterFormationServiceImpl.debug("there are no other running servers. group formation is complete");
            }
            this.consolidateLeaseView(null);
            this.leaderInitialization();
            return true;
        }
        try {
            ClusterResponse[] clusterResponseArray = this.sendFormationMessage(serverInformationArray);
            if (DEBUG) {
                ClusterFormationServiceImpl.debug("received responses to the formation message from all servers. checking responses ...");
            }
            if (this.isFormationRejectionPresent(clusterResponseArray)) {
                if (DEBUG) {
                    ClusterFormationServiceImpl.debug("formation message rejected !!");
                }
                this.handleFormationRejection(clusterResponseArray);
                return false;
            }
            this.consolidateLeaseView(clusterResponseArray);
            this.becomeLeader(serverInformationArray);
            return true;
        }
        catch (ClusterMessageProcessingException clusterMessageProcessingException) {
            if (DEBUG) {
                ClusterFormationServiceImpl.debug("formation message rejected !!");
                clusterMessageProcessingException.printStackTrace();
            }
            this.handleFormationRejection(clusterMessageProcessingException.getResponses());
            return false;
        }
    }

    private void consolidateLeaseView(ClusterResponse[] clusterResponseArray) {
        if (this.leaseView == null) {
            return;
        }
        if (clusterResponseArray != null) {
            for (int i = 0; i < clusterResponseArray.length; ++i) {
                ClusterFormationResponse clusterFormationResponse = (ClusterFormationResponse)clusterResponseArray[i];
                this.leaseView.merge(clusterFormationResponse.getLeaseView());
            }
        }
        this.leaseView.prepareToBecomeLeader();
        this.leaseView = new LeaseView(this.localInformation.getServerName(), this.leaseView.getLeaseTableReplica(), this.leaseView.getVersionNumber());
    }

    private ClusterResponse[] sendFormationMessage(ServerInformation[] serverInformationArray) throws ClusterMessageProcessingException {
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        ClusterGroupView clusterGroupView = new ClusterGroupView(this.localInformation, serverInformationArray);
        ClusterFormationMessage clusterFormationMessage = new ClusterFormationMessage(clusterGroupView);
        if (DEBUG) {
            ClusterFormationServiceImpl.debug("sending " + clusterFormationMessage + " to " + serverInformationArray.length + " running servers");
        }
        return clusterMessageSender.send((ClusterMessage)clusterFormationMessage, serverInformationArray);
    }

    private boolean isFormationRejectionPresent(ClusterResponse[] clusterResponseArray) {
        for (int i = 0; i < clusterResponseArray.length; ++i) {
            ClusterFormationResponse clusterFormationResponse = (ClusterFormationResponse)clusterResponseArray[i];
            if (clusterFormationResponse != null && clusterFormationResponse.isAccepted()) continue;
            return true;
        }
        return false;
    }

    private void handleFormationRejection(ClusterResponse[] clusterResponseArray) {
        for (int i = 0; i < clusterResponseArray.length; ++i) {
            ClusterFormationResponse clusterFormationResponse = (ClusterFormationResponse)clusterResponseArray[i];
            if (clusterFormationResponse == null || clusterFormationResponse.isAccepted()) continue;
            if (DEBUG) {
                ClusterFormationServiceImpl.debug("got a rejection formation response " + clusterFormationResponse);
            }
            if (clusterFormationResponse.getLeaderInformation() != null) {
                if (!this.isServerAlive(clusterFormationResponse.getLeaderInformation().getServerName())) continue;
                if (DEBUG) {
                    ClusterFormationServiceImpl.debug("rejection was caused by the presence of a leader.restarting the server ...");
                }
                this.forceShutdown();
                continue;
            }
            if (DEBUG) {
                ClusterFormationServiceImpl.debug("rejection was caused by a senior server which is not yet the leader. restarting the server ...");
            }
            this.forceShutdown();
        }
    }

    private boolean isServerAlive(String string) {
        if (this.result == null) {
            return true;
        }
        String string2 = this.result.getServerState(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals("RUNNING") || string2.equals("ADMIN");
    }

    private void forceShutdown() {
        try {
            ManagementService.getRuntimeAccess(kernelId).getServerRuntime().forceShutdown();
            throw new IllegalStateException("Server failed formation due to the presence of another leader in the cluster!");
        }
        catch (ServerLifecycleException serverLifecycleException) {
            System.exit(1);
            return;
        }
    }

    private void becomeLeader(ServerInformation[] serverInformationArray) {
        block4: {
            ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
            JoinResponseMessage joinResponseMessage = JoinResponseMessage.getAcceptedResponse(this.groupView, this.leaseView);
            if (DEBUG) {
                ClusterFormationServiceImpl.debug("sending join responses to running members with the leadership information");
            }
            try {
                clusterMessageSender.send((ClusterMessage)joinResponseMessage, serverInformationArray);
            }
            catch (ClusterMessageProcessingException clusterMessageProcessingException) {
                if (!DEBUG) break block4;
                ClusterFormationServiceImpl.debug("got exception while sending join responses. reason:" + clusterMessageProcessingException);
            }
        }
        if (DEBUG) {
            ClusterFormationServiceImpl.debug("starting cluster leader locally after sending join responses");
        }
        this.leaderInitialization();
        this.groupView = null;
    }

    private boolean ensureServerReachabilityMajority() {
        String string = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getName();
        this.result = EnvironmentFactory.getServerReachabilityMajorityService().performSRMCheck(null, string);
        return this.result.hasReachabilityMajority();
    }

    private void leaderInitialization() {
        if (!ClusterState.getInstance().setState("stable_leader")) {
            throw new AssertionError((Object)ClusterState.getInstance().getErrorMessage("stable_leader"));
        }
        if (DEBUG) {
            ClusterFormationServiceImpl.debug("starting the ClusterLeader on local server");
        }
        this.stop();
        EnvironmentFactory.getClusterLeader().start(this.groupView, this.leaseView);
    }

    private void stop() {
        EnvironmentFactory.getClusterMemberDisconnectMonitor().stop();
    }

    private static ServerInformation createLocalServerInformation() {
        return new ServerInformationImpl(ClusterService.getClusterService().getLocalMember());
    }

    public void timerExpired(Timer timer) {
        try {
            if (this.formClusterInternal()) {
                timer.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.formationFailed(illegalStateException);
            timer.cancel();
        }
    }

    private void formationFailed(IllegalStateException illegalStateException) {
        ClusterState.getInstance().setState("discovery");
        if (DEBUG) {
            ClusterFormationServiceImpl.debug("Server cannot form cluster due to " + illegalStateException.getMessage());
            illegalStateException.printStackTrace();
        }
    }

    public void OnBecomingSeniorMostMember() {
    }

    public void OnLosingServerReachabilityMajority() {
        String string = "Server is not in the majority cluster partition";
        ClusterState.getInstance().setState("failed", string);
        this.stop();
        HealthMonitorService.subsystemFailed("DatabaseLessLeasing", string);
    }

    public void onLosingLeader() {
        throw new AssertionError((Object)"onLosingLeader() invoked on the ClusterFormationService");
    }

    public void onLosingMember(ServerInformation serverInformation) {
        this.groupView.removeMember(serverInformation);
    }

    public static ClusterFormationService getInstance() {
        return Factory.THE_ONE;
    }

    private static void debug(String string) {
        DebugLogger.debug("[ClusterFormationService] " + string);
    }

    private static boolean debugEnabled() {
        return debugClusterFormation.isEnabled() || DebugLogger.isDebugEnabled();
    }

    private static final class Factory {
        static final ClusterFormationServiceImpl THE_ONE = new ClusterFormationServiceImpl();

        private Factory() {
        }
    }
}

