/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import weblogic.cluster.leasing.databaseless.GroupViewListener;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.WorkManagerFactory;

public final class ClusterGroupView
implements Serializable {
    private ServerInformation leaderInformation;
    private TreeSet members;
    private transient GroupViewListener listener;
    private long versionNumber = 0L;
    private static final DebugCategory debugClusterGroupView;
    private static final boolean DEBUG;
    private static final long serialVersionUID = 8079240922100673698L;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClusterGroupView(ServerInformation serverInformation, ServerInformation[] serverInformationArray) {
        this.leaderInformation = serverInformation;
        this.members = new TreeSet();
        this.members.add(serverInformation);
        if (serverInformationArray != null && serverInformationArray.length > 0) {
            this.members.addAll(Arrays.asList(serverInformationArray));
        }
    }

    ClusterGroupView(TreeSet treeSet) {
        if (!$assertionsDisabled && treeSet.size() <= 0) {
            throw new AssertionError();
        }
        this.leaderInformation = (ServerInformation)treeSet.first();
        this.members = treeSet;
    }

    synchronized ServerInformation getLeaderInformation() {
        return this.leaderInformation;
    }

    Set getMembers() {
        return this.members;
    }

    public String toString() {
        return "[GroupView with leader " + this.leaderInformation + " version " + this.versionNumber + " and members " + this.members + "]";
    }

    public synchronized boolean isSeniorMost(ServerInformation serverInformation) {
        return serverInformation.equals(this.members.first());
    }

    public synchronized ServerInformation getSeniorMost() {
        return (ServerInformation)this.members.first();
    }

    public synchronized void removeLeader() {
        this.removeMember(this.leaderInformation);
        this.leaderInformation = (ServerInformation)this.members.first();
    }

    public synchronized ServerInformation[] getRemoteMembers(ServerInformation serverInformation) {
        ServerInformation[] serverInformationArray;
        ArrayList<ServerInformation[]> arrayList = new ArrayList<ServerInformation[]>();
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            serverInformationArray = (ServerInformation[])iterator.next();
            if (serverInformation.equals(serverInformationArray)) continue;
            arrayList.add(serverInformationArray);
        }
        serverInformationArray = new ServerInformation[arrayList.size()];
        return arrayList.toArray(serverInformationArray);
    }

    public synchronized void addMember(final ServerInformation serverInformation) {
        this.members.add(serverInformation);
        if (DEBUG) {
            ClusterGroupView.debug("Added Member - " + serverInformation + " to group " + this);
        }
        if (this.listener != null) {
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    ClusterGroupView.this.listener.memberAdded(serverInformation);
                }
            });
        }
    }

    public synchronized void removeMember(final ServerInformation serverInformation) {
        if (!this.members.remove(serverInformation)) {
            return;
        }
        if (this.leaderInformation.equals(serverInformation)) {
            this.leaderInformation = (ServerInformation)this.members.first();
        }
        if (DEBUG) {
            ClusterGroupView.debug("Removed Member - " + serverInformation + " from group " + this);
        }
        if (this.listener != null) {
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    ClusterGroupView.this.listener.memberRemoved(serverInformation);
                }
            });
        }
    }

    void setGroupViewListener(GroupViewListener groupViewListener) {
        this.listener = groupViewListener;
    }

    public synchronized long getVersionNumber() {
        return this.versionNumber;
    }

    synchronized long incrementVersionNumber() {
        return ++this.versionNumber;
    }

    public synchronized void processStateDump(ClusterGroupView clusterGroupView) {
        if (clusterGroupView == null || this.versionNumber >= clusterGroupView.getVersionNumber()) {
            return;
        }
        TreeSet treeSet = (TreeSet)clusterGroupView.getMembers();
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            ServerInformation serverInformation = (ServerInformation)iterator.next();
            if (treeSet.contains(serverInformation)) continue;
            this.listener.memberRemoved(serverInformation);
        }
        this.members = treeSet;
        this.versionNumber = clusterGroupView.getVersionNumber();
    }

    synchronized ServerInformation getServerInformation(String string) {
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            ServerInformation serverInformation = (ServerInformation)iterator.next();
            if (!serverInformation.getServerName().equals(string)) continue;
            return serverInformation;
        }
        return null;
    }

    private static void debug(String string) {
        DebugLogger.debug("[ClusterGroupView] " + string);
    }

    private static boolean debugEnabled() {
        return debugClusterGroupView.isEnabled() || DebugLogger.isDebugEnabled();
    }

    static {
        $assertionsDisabled = !ClusterGroupView.class.desiredAssertionStatus();
        debugClusterGroupView = Debug.getCategory((String)"weblogic.cluster.leasing.ClusterGroupView");
        DEBUG = ClusterGroupView.debugEnabled();
    }
}

