/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.cluster.leasing.databaseless.ClusterGroupView;
import weblogic.cluster.leasing.databaseless.ClusterLeaderHeartbeatMessage;
import weblogic.cluster.leasing.databaseless.ClusterMemberDisconnectMonitor;
import weblogic.cluster.leasing.databaseless.ClusterState;
import weblogic.cluster.leasing.databaseless.DatabaseLessLeasingService;
import weblogic.cluster.leasing.databaseless.DisconnectActionListener;
import weblogic.cluster.leasing.databaseless.EnvironmentFactory;
import weblogic.cluster.leasing.databaseless.GroupViewUpdateMessage;
import weblogic.cluster.leasing.databaseless.JoinRequestMessage;
import weblogic.cluster.leasing.databaseless.JoinResponseMessage;
import weblogic.cluster.leasing.databaseless.LeaderAlreadyExistsException;
import weblogic.cluster.leasing.databaseless.LeaseMessage;
import weblogic.cluster.leasing.databaseless.LeaseServer;
import weblogic.cluster.leasing.databaseless.LeaseView;
import weblogic.cluster.leasing.databaseless.StateDumpResponse;
import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageFactory;
import weblogic.cluster.messaging.internal.ClusterMessageProcessingException;
import weblogic.cluster.messaging.internal.ClusterMessageReceiver;
import weblogic.cluster.messaging.internal.ClusterMessageSender;
import weblogic.cluster.messaging.internal.ClusterResponse;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.messaging.internal.ServerInformationImpl;
import weblogic.health.HealthMonitorService;
import weblogic.management.configuration.DatabaseLessLeasingBasisMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.WorkManagerFactory;

public final class ClusterLeader
implements ClusterMembersChangeListener,
ClusterMessageReceiver,
DisconnectActionListener {
    private static final DebugCategory debugClusterLeader = Debug.getCategory((String)"weblogic.cluster.leasing.ClusterLeader");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean DEBUG = ClusterLeader.debugEnabled();
    private LeaseServer leaseServer;
    private ClusterGroupView groupView;
    private LeaseView leaseView;
    private Timer heartbeatTimer;
    private boolean stopped;

    synchronized void start(ClusterGroupView clusterGroupView, LeaseView leaseView) {
        this.groupView = clusterGroupView;
        this.leaseView = leaseView == null ? new LeaseView(clusterGroupView.getLeaderInformation().getServerName(), null) : leaseView;
        ClusterService.getClusterService().addClusterMembersListener(this);
        if (DEBUG) {
            ClusterLeader.debug("installed ClusterLeader for giving leases and managing cluster view. leader information " + clusterGroupView.getLeaderInformation());
        }
        this.leaseServer = new LeaseServer(this, this.leaseView);
        ClusterMessageFactory.getInstance().registerReceiver(this);
        ((DatabaseLessLeasingService)DatabaseLessLeasingService.getInstance()).localServerIsClusterLeader();
        EnvironmentFactory.getClusterMemberDisconnectMonitor().start(this.groupView, this);
        this.joinMembersInWaiting();
        if (ClusterState.getInstance().getState() != "failed") {
            this.startClusterHeartBeats();
        }
    }

    private void startClusterHeartBeats() {
        if (this.stopped) {
            return;
        }
        HeartbeatTimer heartbeatTimer = new HeartbeatTimer();
        DatabaseLessLeasingBasisMBean databaseLessLeasingBasisMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getDatabaseLessLeasingBasis();
        this.heartbeatTimer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)heartbeatTimer, (long)(databaseLessLeasingBasisMBean.getLeaderHeartbeatPeriod() * 1000), (long)(databaseLessLeasingBasisMBean.getLeaderHeartbeatPeriod() * 1000));
    }

    private void joinMembersInWaiting() {
        if (this.stopped) {
            return;
        }
        Collection collection = ClusterService.getClusterService().getAllRemoteMembers();
        Set set = this.groupView.getMembers();
        if (collection.isEmpty()) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)iterator.next();
            ServerInformationImpl serverInformationImpl = new ServerInformationImpl(clusterMemberInfo);
            if (set.contains(serverInformationImpl)) continue;
            this.joinServer(serverInformationImpl);
            if (ClusterState.getInstance().getState() != "failed") continue;
            break;
        }
    }

    synchronized ServerInformation getLeaderInformation() {
        if (this.stopped) {
            return null;
        }
        return this.groupView != null ? this.groupView.getLeaderInformation() : null;
    }

    public synchronized void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        int n = clusterMembersChangeEvent.getAction();
        if (n == 0 || n == 3) {
            ServerInformationImpl serverInformationImpl = new ServerInformationImpl(clusterMembersChangeEvent.getClusterMemberInfo());
            this.joinServer(serverInformationImpl);
        }
    }

    private synchronized void joinServer(ServerInformation serverInformation) {
        JoinResponseMessage joinResponseMessage;
        if (this.stopped || this.groupView.getMembers().contains(serverInformation)) {
            return;
        }
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        ServerInformation serverInformation2 = this.groupView.getLeaderInformation();
        boolean bl = false;
        if (serverInformation2 != null && serverInformation2.compareTo(serverInformation) < 0) {
            if (DEBUG) {
                ClusterLeader.debug("sending a join response message to " + serverInformation);
            }
            this.groupView.addMember(serverInformation);
            joinResponseMessage = JoinResponseMessage.getAcceptedResponse(this.groupView, this.leaseView);
            bl = true;
        } else {
            if (DEBUG) {
                ClusterLeader.debug("sending a join rejection message to " + serverInformation);
            }
            joinResponseMessage = JoinResponseMessage.getRejectedResponse(this.groupView.getLeaderInformation());
        }
        try {
            clusterMessageSender.send((ClusterMessage)joinResponseMessage, serverInformation.getServerName());
        }
        catch (LeaderAlreadyExistsException leaderAlreadyExistsException) {
            if (DEBUG) {
                ClusterLeader.debug(serverInformation.getServerName() + " knows about the presence of another live cluster leader. " + "Marking this server as failed and stopping the cluster leader");
            }
            String string = " knows about the presence of another live cluster leader. Marking this server as failed and stopping the cluster leader ";
            ClusterState.getInstance().setState("failed", string);
            this.handleExistenceofAnotherLeader(serverInformation, string);
            bl = false;
        }
        catch (RemoteException remoteException) {
            this.groupView.removeMember(serverInformation);
            bl = false;
        }
        if (bl) {
            GroupViewUpdateMessage groupViewUpdateMessage = GroupViewUpdateMessage.createMemberAdded(this.getLeaderInformation(), serverInformation, this.groupView.incrementVersionNumber());
            this.sendGroupMessage(groupViewUpdateMessage);
            ((DatabaseLessLeasingService)DatabaseLessLeasingService.getInstance()).fireConsensusServiceGroupViewListenerEvent(serverInformation, true);
        }
    }

    private void handleExistenceofAnotherLeader(final ServerInformation serverInformation, final String string) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ClusterMemberDisconnectMonitor clusterMemberDisconnectMonitor = EnvironmentFactory.getClusterMemberDisconnectMonitor();
                synchronized (clusterMemberDisconnectMonitor) {
                    ClusterLeader.this.stop();
                    HealthMonitorService.subsystemFailedForceShutdown("Consensus-Leasing", serverInformation.getServerName() + string);
                }
            }
        });
    }

    public synchronized boolean sendGroupMessage(ClusterMessage clusterMessage) {
        if (this.stopped) {
            return false;
        }
        ServerInformation[] serverInformationArray = this.groupView.getRemoteMembers(this.getLeaderInformation());
        if (serverInformationArray == null || serverInformationArray.length == 0) {
            return true;
        }
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        if (DEBUG) {
            ClusterLeader.debug("sending " + clusterMessage + " to " + serverInformationArray.length + " running servers");
        }
        try {
            clusterMessageSender.send(clusterMessage, serverInformationArray);
            return true;
        }
        catch (ClusterMessageProcessingException clusterMessageProcessingException) {
            return false;
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        this.groupView = null;
        EnvironmentFactory.getClusterMemberDisconnectMonitor().stop();
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.cancel();
        }
    }

    public void OnBecomingSeniorMostMember() {
    }

    public void OnLosingServerReachabilityMajority() {
        if (DEBUG) {
            ClusterLeader.debug("OnLosingServerReachabilityMajority() called ! marking the server as failed and stopping the cluster leader");
        }
        String string = "Server is not in the majority cluster partition";
        ClusterState.getInstance().setState("failed", string);
        this.stop();
        HealthMonitorService.subsystemFailed("DatabaseLessLeasing", string);
        ((DatabaseLessLeasingService)DatabaseLessLeasingService.getInstance()).localServerLostClusterLeadership();
    }

    public void onLosingLeader() {
        if (DEBUG) {
            ClusterLeader.debug("onLosingLeader() called on the leader itself ! marking the server as failed and stopping the cluster leader");
        }
        String string = "NodeManager associated with the local server is unreachable !";
        ClusterState.getInstance().setState("failed", string);
        this.stop();
        HealthMonitorService.subsystemFailed("DatabaseLessLeasing", string);
        ((DatabaseLessLeasingService)DatabaseLessLeasingService.getInstance()).localServerLostClusterLeadership();
    }

    public synchronized void onLosingMember(ServerInformation serverInformation) {
        if (this.stopped) {
            return;
        }
        this.groupView.removeMember(serverInformation);
        GroupViewUpdateMessage groupViewUpdateMessage = GroupViewUpdateMessage.createMemberRemoved(this.getLeaderInformation(), serverInformation, this.groupView.incrementVersionNumber());
        this.sendGroupMessage(groupViewUpdateMessage);
        ((DatabaseLessLeasingService)DatabaseLessLeasingService.getInstance()).fireConsensusServiceGroupViewListenerEvent(serverInformation, false);
    }

    public static ClusterLeader getInstance() {
        return Factory.THE_ONE;
    }

    public boolean accept(ClusterMessage clusterMessage) {
        return clusterMessage.getMessageType() == 4 || clusterMessage.getMessageType() == 2 || clusterMessage.getMessageType() == 8;
    }

    public synchronized ClusterResponse process(ClusterMessage clusterMessage) throws ClusterMessageProcessingException {
        if (this.stopped) {
            throw new ClusterMessageProcessingException("ClusterLeader is not running as it is not in the majority cluster partition");
        }
        if (clusterMessage.getMessageType() == 4) {
            return this.leaseServer.process((LeaseMessage)clusterMessage);
        }
        if (clusterMessage.getMessageType() == 2) {
            this.handleJoinRequest((JoinRequestMessage)clusterMessage);
            return null;
        }
        if (clusterMessage.getMessageType() == 8) {
            if (DEBUG) {
                ClusterLeader.debug("sending a state dump response with group version " + this.groupView.getVersionNumber() + " and lease version " + this.leaseView.getVersionNumber());
            }
            return new StateDumpResponse(this.groupView, this.leaseView);
        }
        throw new AssertionError((Object)("Unknown message received by leader " + clusterMessage));
    }

    private void handleJoinRequest(final JoinRequestMessage joinRequestMessage) {
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            public void run() {
                ClusterLeader.this.joinServer(joinRequestMessage.getSenderInformation());
            }
        });
    }

    private static boolean debugEnabled() {
        return debugClusterLeader.isEnabled() || DebugLogger.isDebugEnabled();
    }

    private static void debug(String string) {
        DebugLogger.debug("[ClusterLeader] " + string);
    }

    private class HeartbeatTimer
    implements TimerListener {
        private HeartbeatTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            ClusterLeader clusterLeader = ClusterLeader.this;
            synchronized (clusterLeader) {
                ServerInformation[] serverInformationArray;
                if (ClusterLeader.this.stopped) {
                    timer.cancel();
                    return;
                }
                HashSet<Object> hashSet = new HashSet();
                ServerInformation[] serverInformationArray2 = this.getDiscoveredMembers();
                if (serverInformationArray2 != null) {
                    hashSet = new HashSet<ServerInformation>(Arrays.asList(serverInformationArray2));
                }
                if ((serverInformationArray = ClusterLeader.this.groupView.getRemoteMembers(ClusterLeader.this.groupView.getLeaderInformation())) != null) {
                    hashSet.addAll(Arrays.asList(serverInformationArray));
                }
                if (hashSet.size() == 0) {
                    return;
                }
                ServerInformation[] serverInformationArray3 = new ServerInformation[hashSet.size()];
                serverInformationArray3 = hashSet.toArray(serverInformationArray3);
                ClusterLeaderHeartbeatMessage clusterLeaderHeartbeatMessage = ClusterLeaderHeartbeatMessage.create(ClusterLeader.this.groupView, ClusterLeader.this.leaseView);
                ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getOneWayMessageSender();
                if (DEBUG) {
                    ClusterLeader.debug("sending " + clusterLeaderHeartbeatMessage + " to " + serverInformationArray3.length + " running servers");
                }
                try {
                    clusterMessageSender.send((ClusterMessage)clusterLeaderHeartbeatMessage, serverInformationArray3);
                }
                catch (ClusterMessageProcessingException clusterMessageProcessingException) {
                    // empty catch block
                }
            }
        }

        private ServerInformation[] getDiscoveredMembers() {
            Collection collection = ClusterService.getClusterService().getAllRemoteMembers();
            if (collection.isEmpty()) {
                return null;
            }
            ServerInformation[] serverInformationArray = new ServerInformation[collection.size()];
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)iterator.next();
                serverInformationArray[n++] = new ServerInformationImpl(clusterMemberInfo);
            }
            return serverInformationArray;
        }
    }

    private static final class Factory {
        static final ClusterLeader THE_ONE = new ClusterLeader();

        private Factory() {
        }
    }
}

