/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import weblogic.cluster.MemberManager;
import weblogic.cluster.leasing.databaseless.ClusterMember;
import weblogic.cluster.leasing.databaseless.DatabaseLessLeasingLogger;
import weblogic.cluster.leasing.databaseless.EnvironmentFactory;
import weblogic.cluster.leasing.databaseless.PrimordialClusterLeaderService;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.RMIClusterMessageEndPointImpl;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.t3.srvr.EnableListenersIfAdminChannelAbsentService;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class ClusterLeaderService
extends AbstractServerService {
    private static final DebugCategory debugClusterLeaderService;
    private static final AuthenticatedSubject kernelId;
    private static ClusterLeaderService THE_ONE;
    private static final boolean DEBUG;
    private boolean started = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterLeaderService() {
        Class clazz = ClusterLeaderService.class;
        synchronized (clazz) {
            if (!$assertionsDisabled && THE_ONE != null) {
                throw new AssertionError();
            }
            THE_ONE = this;
        }
    }

    public static ClusterLeaderService getInstance() {
        if (!$assertionsDisabled && THE_ONE == null) {
            throw new AssertionError();
        }
        return THE_ONE;
    }

    public String getLeaderName() {
        ServerInformation serverInformation = this.getLeaderInformation();
        return serverInformation != null ? serverInformation.getServerName() : null;
    }

    public void start() throws ServiceFailureException {
        if (this.started) {
            return;
        }
        PrimordialClusterLeaderService.getInstance().stop();
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (clusterMBean == null) {
            return;
        }
        if (!"consensus".equalsIgnoreCase(clusterMBean.getMigrationBasis())) {
            return;
        }
        if (DEBUG) {
            ClusterLeaderService.debug("--- DATABASE LESS LEASING IS TURNED ON ---");
        }
        ClusterLeaderService.ensureServersHaveMachines(clusterMBean);
        if (!Boolean.getBoolean("weblogic.nodemanager.ServiceEnabled")) {
            DatabaseLessLeasingLogger.logServerNotStartedByNodeManager();
            throw new ServiceFailureException("Server must be started by NodeManager when consensus leasing is enabled");
        }
        try {
            ServerHelper.exportObject((Remote)RMIClusterMessageEndPointImpl.getInstance());
        }
        catch (RemoteException remoteException) {
            throw new ServiceFailureException((Throwable)remoteException);
        }
        try {
            if (!EnableListenersIfAdminChannelAbsentService.startInRunningState()) {
                MemberManager.theOne().sendMemberRuntimeState();
            }
        }
        catch (IOException iOException) {
            throw new ServiceFailureException("Failed to send runtime state message", (Throwable)iOException);
        }
        int n = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getDatabaseLessLeasingBasis().getMemberDiscoveryTimeout();
        if (DEBUG) {
            ClusterLeaderService.debug("Initialize EnvironmentFoctory and start the discovery timer");
        }
        EnvironmentFactory.initialize();
        EnvironmentFactory.getDiscoveryService().start(n);
        this.started = true;
    }

    private static void ensureServersHaveMachines(ClusterMBean clusterMBean) throws ServiceFailureException {
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (serverMBeanArray[i].getMachine() != null) continue;
            throw new ServiceFailureException("server " + serverMBeanArray[i] + " is not associated with a machine");
        }
    }

    private ServerInformation getLeaderInformation() {
        ServerInformation serverInformation = EnvironmentFactory.getClusterMember().getLeaderInformation();
        if (serverInformation != null) {
            return serverInformation;
        }
        return EnvironmentFactory.getClusterLeader().getLeaderInformation();
    }

    static ServerInformation getLeader() {
        if (THE_ONE != null && THE_ONE.getLeaderInformation() != null) {
            return THE_ONE.getLeaderInformation();
        }
        return PrimordialClusterLeaderService.getInstance().getLeaderInformation();
    }

    ServerInformation getLocalServerInformation() {
        return ClusterMember.getInstance().getLocalServerInformation();
    }

    private static boolean debugEnabled() {
        return debugClusterLeaderService.isEnabled() || DebugLogger.isDebugEnabled();
    }

    private static void debug(String string) {
        DebugLogger.debug("[ClusterLeaderService] " + string);
    }

    static {
        $assertionsDisabled = !ClusterLeaderService.class.desiredAssertionStatus();
        debugClusterLeaderService = Debug.getCategory((String)"weblogic.cluster.leasing.ClusterLeaderService");
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        THE_ONE = null;
        DEBUG = ClusterLeaderService.debugEnabled();
    }
}

