/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.rmi.RemoteException;
import weblogic.cluster.ClusterService;
import weblogic.cluster.leasing.databaseless.ClusterFormationMessage;
import weblogic.cluster.leasing.databaseless.ClusterFormationResponse;
import weblogic.cluster.leasing.databaseless.ClusterGroupView;
import weblogic.cluster.leasing.databaseless.ClusterLeaderHeartbeatMessage;
import weblogic.cluster.leasing.databaseless.ClusterState;
import weblogic.cluster.leasing.databaseless.DatabaseLessLeasingService;
import weblogic.cluster.leasing.databaseless.DisconnectActionListener;
import weblogic.cluster.leasing.databaseless.EnvironmentFactory;
import weblogic.cluster.leasing.databaseless.GroupViewUpdateMessage;
import weblogic.cluster.leasing.databaseless.JoinRequestMessage;
import weblogic.cluster.leasing.databaseless.JoinResponseMessage;
import weblogic.cluster.leasing.databaseless.LeaderAlreadyExistsException;
import weblogic.cluster.leasing.databaseless.LeaderQueryMessage;
import weblogic.cluster.leasing.databaseless.LeaderQueryResponse;
import weblogic.cluster.leasing.databaseless.LeaseTableUpdateMessage;
import weblogic.cluster.leasing.databaseless.LeaseView;
import weblogic.cluster.leasing.databaseless.StateDumpRequestMessage;
import weblogic.cluster.leasing.databaseless.StateDumpResponse;
import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageFactory;
import weblogic.cluster.messaging.internal.ClusterMessageProcessingException;
import weblogic.cluster.messaging.internal.ClusterMessageReceiver;
import weblogic.cluster.messaging.internal.ClusterMessageSender;
import weblogic.cluster.messaging.internal.ClusterResponse;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.messaging.internal.ServerInformationImpl;
import weblogic.health.HealthMonitorService;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class ClusterMember
implements ClusterMessageReceiver,
DisconnectActionListener {
    private static final DebugCategory debugClusterMember;
    private static final boolean DEBUG;
    private final ServerInformation localInformation = ClusterMember.createLocalServerInformation();
    private ClusterGroupView groupView;
    private LeaseView leaseView;
    private ServerInformation leaderInformation;
    private ClusterFormationMessage acceptedFormationMessage;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ClusterMember getInstance() {
        return Factory.THE_ONE;
    }

    private ClusterMember() {
        ClusterMessageFactory.getInstance().registerReceiver(this);
    }

    private static ServerInformation createLocalServerInformation() {
        return new ServerInformationImpl(ClusterService.getClusterService().getLocalMember());
    }

    public ServerInformation getLeaderInformation() {
        return this.leaderInformation;
    }

    ServerInformation getLocalServerInformation() {
        return this.localInformation;
    }

    ClusterGroupView getGroupView() {
        return this.groupView;
    }

    LeaseView getLeaseView() {
        return this.leaseView;
    }

    void addMember(ServerInformation serverInformation) {
        this.groupView.addMember(serverInformation);
    }

    void removeMember(ServerInformation serverInformation) {
        this.groupView.removeMember(serverInformation);
    }

    public String getLeaderName() {
        ServerInformation serverInformation = this.getLeaderInformation();
        return serverInformation != null ? serverInformation.getServerName() : null;
    }

    public boolean accept(ClusterMessage clusterMessage) {
        int n = clusterMessage.getMessageType();
        return n == 1 || n == 3 || n == 5 || n == 6 || n == 7 || n == 10;
    }

    public synchronized ClusterResponse process(ClusterMessage clusterMessage) throws ClusterMessageProcessingException {
        if (DEBUG) {
            ClusterMember.debug("received remote message " + clusterMessage);
        }
        if ("failed".equals(ClusterState.getInstance().getState())) {
            throw new ClusterMessageProcessingException("cannot process message '" + clusterMessage + "' as the server is in failed state");
        }
        if (clusterMessage.getMessageType() == 1) {
            return this.handleFormationRequest((ClusterFormationMessage)clusterMessage);
        }
        if (clusterMessage.getMessageType() == 3) {
            return this.handleJoinResponseRequest((JoinResponseMessage)clusterMessage);
        }
        if (clusterMessage.getMessageType() == 5) {
            return this.handleLeaseTableUpdateRequest((LeaseTableUpdateMessage)clusterMessage);
        }
        if (clusterMessage.getMessageType() == 6) {
            return this.handleGroupViewUpdateRequest((GroupViewUpdateMessage)clusterMessage);
        }
        if (clusterMessage.getMessageType() == 7) {
            return this.handleLeaderHeartbeatRequest((ClusterLeaderHeartbeatMessage)clusterMessage);
        }
        if (clusterMessage.getMessageType() == 10) {
            return this.handleLeaderQuery((LeaderQueryMessage)clusterMessage);
        }
        throw new AssertionError((Object)("Received an unsolicited request " + clusterMessage));
    }

    private void sendJoinRequestMessage(ServerInformation serverInformation) {
        block3: {
            JoinRequestMessage joinRequestMessage = JoinRequestMessage.create(this.localInformation);
            ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getOneWayMessageSender();
            if (DEBUG) {
                ClusterMember.debug("sending join request message to " + serverInformation);
            }
            try {
                clusterMessageSender.send((ClusterMessage)joinRequestMessage, serverInformation);
            }
            catch (RemoteException remoteException) {
                if (!DEBUG) break block3;
                ClusterMember.debug("join request message to " + serverInformation + " failed with " + remoteException.getMessage());
                remoteException.printStackTrace();
            }
        }
    }

    private ClusterResponse handleLeaderHeartbeatRequest(ClusterLeaderHeartbeatMessage clusterLeaderHeartbeatMessage) {
        if (ClusterState.getInstance().getState() == "discovery") {
            this.sendJoinRequestMessage(clusterLeaderHeartbeatMessage.getSenderInformation());
            return null;
        }
        if (ClusterState.getInstance().getState() != "stable") {
            return null;
        }
        if (clusterLeaderHeartbeatMessage.getGroupViewVersion() != this.groupView.getVersionNumber() || clusterLeaderHeartbeatMessage.getLeaseViewVersion() != this.leaseView.getVersionNumber()) {
            StateDumpRequestMessage stateDumpRequestMessage = StateDumpRequestMessage.create(this.localInformation, this.groupView, this.leaseView);
            ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
            if (DEBUG) {
                ClusterMember.debug("sending " + stateDumpRequestMessage + " to leader " + this.leaderInformation);
            }
            try {
                StateDumpResponse stateDumpResponse = (StateDumpResponse)clusterMessageSender.send((ClusterMessage)stateDumpRequestMessage, this.leaderInformation);
                this.leaseView.processStateDump(stateDumpResponse.getLeaseView());
                this.groupView.processStateDump(stateDumpResponse.getGroupView());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    private synchronized ClusterResponse handleGroupViewUpdateRequest(GroupViewUpdateMessage groupViewUpdateMessage) throws ClusterMessageProcessingException {
        if (this.groupView == null) {
            throw new ClusterMessageProcessingException("Unacceptable group view update.  Cluster member has stopped.  Received:" + groupViewUpdateMessage);
        }
        if (this.groupView.getVersionNumber() + 1L != groupViewUpdateMessage.getVersionNumber()) {
            throw new ClusterMessageProcessingException("unacceptable group view update. local version " + this.groupView.getVersionNumber() + " and received version is " + groupViewUpdateMessage.getVersionNumber());
        }
        if (groupViewUpdateMessage.getOperation() == 1) {
            this.addMember(groupViewUpdateMessage.getServerInformation());
            this.groupView.incrementVersionNumber();
        } else if (groupViewUpdateMessage.getOperation() == 2) {
            this.removeMember(groupViewUpdateMessage.getServerInformation());
            this.groupView.incrementVersionNumber();
        } else {
            throw new AssertionError((Object)("unsupported group view update message " + groupViewUpdateMessage));
        }
        return null;
    }

    private ClusterResponse handleLeaseTableUpdateRequest(LeaseTableUpdateMessage leaseTableUpdateMessage) throws ClusterMessageProcessingException {
        if (!$assertionsDisabled && this.leaseView == null) {
            throw new AssertionError();
        }
        this.leaseView.process(leaseTableUpdateMessage);
        return null;
    }

    private ClusterResponse handleJoinResponseRequest(JoinResponseMessage joinResponseMessage) throws LeaderAlreadyExistsException {
        String string = ClusterState.getInstance().getState();
        if (string.equals("stable") ? this.leaderInformation == null || !this.leaderInformation.equals(joinResponseMessage.getSenderInformation()) : !ClusterState.getInstance().setState("stable")) {
            throw new LeaderAlreadyExistsException(ClusterState.getInstance().getErrorMessage("stable"));
        }
        if (string.equals("discovery")) {
            EnvironmentFactory.getDiscoveryService().stop();
        } else {
            EnvironmentFactory.getClusterMemberDisconnectMonitor().stop();
        }
        if (!joinResponseMessage.isAccepted()) {
            this.fatalError();
            return null;
        }
        this.groupView = joinResponseMessage.getGroupView();
        if (this.leaseView == null) {
            this.leaseView = new LeaseView(this.localInformation.getServerName(), null);
        }
        this.leaseView.processStateDump(joinResponseMessage.getLeaseView());
        this.leaderInformation = this.groupView.getLeaderInformation();
        EnvironmentFactory.getClusterMemberDisconnectMonitor().start(this.groupView, this);
        if (DEBUG) {
            ClusterMember.debug("installed leader with group view " + this.groupView);
        }
        return null;
    }

    private synchronized ClusterResponse handleFormationRequest(ClusterFormationMessage clusterFormationMessage) {
        String string = ClusterState.getInstance().getState();
        if (this.acceptFormationRequest(clusterFormationMessage) && ClusterState.getInstance().setState("formation")) {
            this.acceptedFormationMessage = clusterFormationMessage;
            this.groupView = this.acceptedFormationMessage.getGroupView();
            if (string.equals("discovery")) {
                EnvironmentFactory.getDiscoveryService().stop();
            }
            if (DEBUG) {
                ClusterMember.debug("stopping current disconnect monitor during formation");
            }
            EnvironmentFactory.getClusterMemberDisconnectMonitor().stop();
            if (DEBUG) {
                ClusterMember.debug("starting new disconnect monitor...");
            }
            EnvironmentFactory.getClusterMemberDisconnectMonitor().start(this.acceptedFormationMessage.getGroupView(), this);
            if (DEBUG) {
                ClusterMember.debug("sending accepted formation response");
            }
            return ClusterFormationResponse.getAcceptedResponse(clusterFormationMessage, this.acceptedFormationMessage, this.localInformation, this.leaseView);
        }
        if (this.acceptedFormationMessage != null && this.acceptedFormationMessage.getSenderInformation().equals(clusterFormationMessage.getSenderInformation())) {
            return ClusterFormationResponse.getAcceptedResponse(clusterFormationMessage, this.acceptedFormationMessage, this.localInformation, this.leaseView);
        }
        if (DEBUG) {
            ClusterMember.debug("sending rejected formation response for message " + clusterFormationMessage);
        }
        return ClusterFormationResponse.getRejectedResponse(clusterFormationMessage, this.acceptedFormationMessage, this.getLeaderInformation(), this.localInformation);
    }

    private boolean acceptFormationRequest(ClusterFormationMessage clusterFormationMessage) {
        if (this.acceptedFormationMessage != null || this.leaderInformation != null) {
            return false;
        }
        return this.localInformation.compareTo(clusterFormationMessage.getSenderInformation()) > 0;
    }

    public synchronized void stop() {
        this.groupView = null;
        this.acceptedFormationMessage = null;
        this.leaderInformation = null;
        EnvironmentFactory.getClusterMemberDisconnectMonitor().stop();
    }

    private void fatalError() {
        if (DEBUG) {
            ClusterMember.debug("OnLosingServerReachabilityMajority() called ! marking the server as failed");
        }
        String string = "Server is not in the majority cluster partition";
        ClusterState.getInstance().setState("failed", string);
        this.stop();
        HealthMonitorService.subsystemFailed("DatabaseLessLeasing", string);
    }

    public void OnBecomingSeniorMostMember() {
        if (!$assertionsDisabled && this.groupView == null) {
            throw new AssertionError();
        }
        ClusterGroupView clusterGroupView = this.groupView;
        this.stop();
        EnvironmentFactory.getClusterFormationService().start(clusterGroupView, this.leaseView);
    }

    public void OnLosingServerReachabilityMajority() {
        this.fatalError();
    }

    public synchronized void onLosingLeader() {
        if (!ClusterState.getInstance().setState("discovery")) {
            throw new AssertionError((Object)ClusterState.getInstance().getErrorMessage("discovery"));
        }
        if (!$assertionsDisabled && this.groupView == null) {
            throw new AssertionError();
        }
        this.groupView.removeLeader();
        this.acceptedFormationMessage = null;
        this.leaderInformation = null;
    }

    public void onLosingMember(ServerInformation serverInformation) {
        this.groupView.removeMember(serverInformation);
    }

    private ClusterResponse handleLeaderQuery(LeaderQueryMessage leaderQueryMessage) {
        DatabaseLessLeasingService databaseLessLeasingService = (DatabaseLessLeasingService)DatabaseLessLeasingService.getInstance();
        if (databaseLessLeasingService.isClusterLeader()) {
            return new LeaderQueryResponse(this.localInformation);
        }
        if (this.leaderInformation != null) {
            return new LeaderQueryResponse(this.leaderInformation);
        }
        return new LeaderQueryResponse();
    }

    public String toString() {
        return "[ClusterMember with view " + this.groupView + "]";
    }

    private static void debug(String string) {
        DebugLogger.debug("[ClusterMember] " + string);
    }

    private static boolean debugEnabled() {
        return debugClusterMember.isEnabled() || DebugLogger.isDebugEnabled();
    }

    static {
        $assertionsDisabled = !ClusterMember.class.desiredAssertionStatus();
        debugClusterMember = Debug.getCategory((String)"weblogic.cluster.leasing.ClusterMember");
        DEBUG = ClusterMember.debugEnabled();
    }

    private static final class Factory {
        static final ClusterMember THE_ONE = new ClusterMember();

        private Factory() {
        }
    }
}

