/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.util.ArrayList;
import java.util.List;
import weblogic.cluster.leasing.databaseless.ClusterStateChangeListener;
import weblogic.health.HealthFeedback;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.work.WorkManagerFactory;

public final class ClusterState
implements HealthFeedback {
    static final String DISCOVERY = "discovery";
    static final String FORMATION = "formation";
    static final String FORMATION_LEADER = "formation_leader";
    static final String STABLE = "stable";
    public static final String STABLE_LEADER = "stable_leader";
    static final String FAILED = "failed";
    private String currentState;
    private final List listeners = new ArrayList();
    private HealthState healthState = new HealthState(0);

    public synchronized boolean setState(String string) {
        return this.setState(string, null);
    }

    public synchronized boolean setState(String string, String string2) {
        String string3 = string.intern();
        this.setHealthState(string, string2);
        if (string3 == DISCOVERY || string3 == FAILED) {
            return this.setInternalState(string3);
        }
        if (this.currentState == null) {
            if (string3 == FORMATION || string3 == STABLE) {
                return this.setInternalState(string3);
            }
            return false;
        }
        if (this.currentState == DISCOVERY) {
            if (string3 == FORMATION || string3 == STABLE || string3 == FORMATION_LEADER) {
                return this.setInternalState(string3);
            }
            return false;
        }
        if (this.currentState == FORMATION_LEADER) {
            if (string3 == STABLE_LEADER) {
                return this.setInternalState(string3);
            }
            return false;
        }
        if (this.currentState == FORMATION) {
            if (string3 == STABLE) {
                return this.setInternalState(string3);
            }
            return false;
        }
        throw new AssertionError((Object)("Invalid state transition from " + this.currentState + " to " + string));
    }

    public HealthState getHealthState() {
        return this.healthState;
    }

    private ClusterState() {
        HealthMonitorService.register("DatabaseLessLeasing", this, true);
    }

    private void setHealthState(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string == FAILED) {
            this.healthState = new HealthState(3, string2);
            return;
        }
        if (this.healthState.getState() == 3 && string != FAILED) {
            this.healthState = new HealthState(0);
        }
    }

    private boolean setInternalState(final String string) {
        final String string2 = this.currentState;
        this.currentState = string;
        WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List list = ClusterState.this.listeners;
                synchronized (list) {
                    for (int i = 0; i < ClusterState.this.listeners.size(); ++i) {
                        ((ClusterStateChangeListener)ClusterState.this.listeners.get(i)).stateChanged(string2, string);
                    }
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStateChangeListener(ClusterStateChangeListener clusterStateChangeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(clusterStateChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStateChangeListener(ClusterStateChangeListener clusterStateChangeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(clusterStateChangeListener);
        }
    }

    public synchronized String getErrorMessage(String string) {
        return "unable to transition from " + this.currentState + " to " + string;
    }

    public static ClusterState getInstance() {
        return Factory.THE_ONE;
    }

    synchronized String getState() {
        return this.currentState;
    }

    private static final class Factory {
        static final ClusterState THE_ONE = new ClusterState();

        private Factory() {
        }
    }
}

