/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.util.Iterator;
import weblogic.cluster.leasing.databaseless.ClusterLeaderService;
import weblogic.cluster.leasing.databaseless.EnvironmentFactory;
import weblogic.cluster.leasing.databaseless.LeaseClient;
import weblogic.cluster.messaging.internal.SRMResult;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.singleton.AbstractConsensusService;
import weblogic.cluster.singleton.ClusterLeaderListener;
import weblogic.cluster.singleton.ConsensusServiceGroupViewListener;
import weblogic.cluster.singleton.LeasingBasis;
import weblogic.utils.collections.ArraySet;
import weblogic.work.WorkManagerFactory;

public final class DatabaseLessLeasingService
extends AbstractConsensusService {
    private boolean isClusterLeader;
    private final ArraySet clusterLeaderListeners = new ArraySet();
    private final ArraySet consensusServiceGroupViewListeners = new ArraySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseLessLeasingService() {
        Class clazz = DatabaseLessLeasingService.class;
        synchronized (clazz) {
            if (instance != null) {
                throw new AssertionError((Object)"Duplicate DatabaseLessLeasingService instance");
            }
            instance = this;
        }
    }

    public LeasingBasis createConsensusBasis(int n, int n2) {
        return new LeaseClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterLeaderListener(ClusterLeaderListener clusterLeaderListener) {
        ArraySet arraySet = this.clusterLeaderListeners;
        synchronized (arraySet) {
            if (this.isClusterLeader) {
                clusterLeaderListener.localServerIsClusterLeader();
            } else {
                this.clusterLeaderListeners.add((Object)clusterLeaderListener);
            }
        }
    }

    public String getServerState(String string) {
        String string2 = null;
        SRMResult sRMResult = EnvironmentFactory.getServerReachabilityMajorityService().getLastSRMResult();
        if (sRMResult != null) {
            string2 = sRMResult.getServerState(string);
        }
        return string2;
    }

    public void addConsensusServiceGroupViewListener(ConsensusServiceGroupViewListener consensusServiceGroupViewListener) {
        this.consensusServiceGroupViewListeners.add((Object)consensusServiceGroupViewListener);
    }

    public void removeConsensusServiceGroupViewListener(ConsensusServiceGroupViewListener consensusServiceGroupViewListener) {
        this.consensusServiceGroupViewListeners.remove((Object)consensusServiceGroupViewListener);
    }

    void fireConsensusServiceGroupViewListenerEvent(final ServerInformation serverInformation, boolean bl) {
        Iterator iterator = this.consensusServiceGroupViewListeners.iterator();
        while (iterator.hasNext()) {
            final ConsensusServiceGroupViewListener consensusServiceGroupViewListener = (ConsensusServiceGroupViewListener)iterator.next();
            if (bl) {
                WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                    public void run() {
                        consensusServiceGroupViewListener.memberAdded(serverInformation.getServerName());
                    }
                });
                continue;
            }
            WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                public void run() {
                    consensusServiceGroupViewListener.memberRemoved(serverInformation.getServerName());
                }
            });
        }
    }

    public String getLeasingBasisLocation() {
        return ClusterLeaderService.getInstance().getLeaderName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void localServerIsClusterLeader() {
        ArraySet arraySet = this.clusterLeaderListeners;
        synchronized (arraySet) {
            Iterator iterator = this.clusterLeaderListeners.iterator();
            while (iterator.hasNext()) {
                final ClusterLeaderListener clusterLeaderListener = (ClusterLeaderListener)iterator.next();
                WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                    public void run() {
                        clusterLeaderListener.localServerIsClusterLeader();
                    }
                });
            }
            this.isClusterLeader = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void localServerLostClusterLeadership() {
        ArraySet arraySet = this.clusterLeaderListeners;
        synchronized (arraySet) {
            Iterator iterator = this.clusterLeaderListeners.iterator();
            while (iterator.hasNext()) {
                final ClusterLeaderListener clusterLeaderListener = (ClusterLeaderListener)iterator.next();
                WorkManagerFactory.getInstance().getSystem().schedule(new Runnable(){

                    public void run() {
                        clusterLeaderListener.localServerLostClusterLeadership();
                    }
                });
            }
            this.isClusterLeader = false;
        }
    }

    boolean isClusterLeader() {
        return this.isClusterLeader;
    }
}

