/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.io.IOException;
import java.util.Set;
import weblogic.cluster.leasing.databaseless.ClusterLeaderService;
import weblogic.cluster.leasing.databaseless.ClusterState;
import weblogic.cluster.leasing.databaseless.ClusterStateChangeListener;
import weblogic.cluster.leasing.databaseless.EnvironmentFactory;
import weblogic.cluster.leasing.databaseless.LeaseMessage;
import weblogic.cluster.leasing.databaseless.LeaseResponse;
import weblogic.cluster.leasing.databaseless.LeaseTableUpdateException;
import weblogic.cluster.leasing.databaseless.PrimordialClusterLeaderService;
import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageFactory;
import weblogic.cluster.messaging.internal.ClusterMessageSender;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.singleton.ClusterReformationInProgressException;
import weblogic.cluster.singleton.LeasingBasis;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class LeaseClient
implements LeasingBasis,
ClusterStateChangeListener {
    private static final DebugCategory debugLeaseClient = Debug.getCategory((String)"weblogic.cluster.leasing.LeaseClient");
    private static final boolean DEBUG = LeaseClient.debugEnabled();
    private boolean clusterFormationInProgress = true;

    public LeaseClient() {
        ClusterState.getInstance().addStateChangeListener(this);
    }

    public boolean acquire(String string, String string2, int n) throws IOException {
        boolean bl;
        ServerInformation serverInformation = ClusterLeaderService.getLeader();
        if (serverInformation == null) {
            if (DEBUG) {
                LeaseClient.debug("Cluster leader is not present ! refuse lease acquisition for " + string);
            }
            return false;
        }
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        LeaseMessage leaseMessage = new LeaseMessage(string, string2, n);
        if (DEBUG) {
            LeaseClient.debug("requesting new lease " + leaseMessage + " from LeaseServer " + serverInformation);
        }
        LeaseResponse leaseResponse = (LeaseResponse)clusterMessageSender.send((ClusterMessage)leaseMessage, serverInformation);
        if (DEBUG) {
            LeaseClient.debug("received response to the lease message " + leaseResponse);
        }
        if ((bl = ((Boolean)leaseResponse.getResult()).booleanValue()) && EnvironmentFactory.getClusterMember().getLeaseView() != null) {
            EnvironmentFactory.getClusterMember().getLeaseView().leaseAcquiredByLocalServer(string, n);
        }
        return bl;
    }

    public void release(String string, String string2) throws IOException {
        ServerInformation serverInformation = ClusterLeaderService.getLeader();
        if (serverInformation == null) {
            if (DEBUG) {
                LeaseClient.debug("Cluster leader is not present ! refuse lease release for " + string);
            }
            return;
        }
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        LeaseMessage leaseMessage = new LeaseMessage(string, string2);
        if (DEBUG) {
            LeaseClient.debug("requesting lease release " + leaseMessage + " from LeaseServer " + serverInformation);
        }
        try {
            LeaseResponse leaseResponse = (LeaseResponse)clusterMessageSender.send((ClusterMessage)leaseMessage, serverInformation);
            if (DEBUG) {
                LeaseClient.debug("received response to the lease message " + leaseResponse);
            }
            if (EnvironmentFactory.getClusterMember().getLeaseView() != null) {
                EnvironmentFactory.getClusterMember().getLeaseView().leaseReleasedByLocalServer(string);
            }
        }
        catch (LeaseTableUpdateException leaseTableUpdateException) {
            throw new IOException(leaseTableUpdateException.getMessage());
        }
    }

    public String findOwner(String string) throws IOException {
        ServerInformation serverInformation = ClusterLeaderService.getLeader();
        if (serverInformation == null && (serverInformation = PrimordialClusterLeaderService.getInstance().getLeaderInformationInternal(true)) == null) {
            if (DEBUG) {
                LeaseClient.debug("No server knows about the Cluster leader yet ! refuse find owner for " + string);
            }
            throw this.createIOException("unable to find owner for lease " + string + " as the cluster leader is unavailable");
        }
        return this.findOwner(string, serverInformation);
    }

    public String findOwner(String string, ServerInformation serverInformation) throws IOException {
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        LeaseMessage leaseMessage = new LeaseMessage(string);
        if (DEBUG) {
            LeaseClient.debug("requesting find owner " + leaseMessage + " from LeaseServer " + serverInformation);
        }
        LeaseResponse leaseResponse = (LeaseResponse)clusterMessageSender.send((ClusterMessage)leaseMessage, serverInformation);
        if (DEBUG) {
            LeaseClient.debug("received response to the lease message " + leaseResponse);
        }
        return (String)leaseResponse.getResult();
    }

    public String findPreviousOwner(String string) throws IOException {
        ServerInformation serverInformation = ClusterLeaderService.getLeader();
        if (serverInformation == null) {
            if (DEBUG) {
                LeaseClient.debug("Cluster leader is not present ! refuse find previous owner for " + string);
            }
            throw this.createIOException("unable to find previous owner for lease " + string + " as the cluster leader is unavailable");
        }
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        LeaseMessage leaseMessage = LeaseMessage.createFindPreviousOwnerMessage(string);
        if (DEBUG) {
            LeaseClient.debug("requesting find previous owner " + leaseMessage + " from LeaseServer " + serverInformation);
        }
        LeaseResponse leaseResponse = (LeaseResponse)clusterMessageSender.send((ClusterMessage)leaseMessage, serverInformation);
        if (DEBUG) {
            LeaseClient.debug("received response to the lease message " + leaseResponse);
        }
        return (String)leaseResponse.getResult();
    }

    public int renewLeases(String string, Set set, int n) throws IOException {
        ServerInformation serverInformation = ClusterLeaderService.getLeader();
        if (serverInformation == null) {
            if (DEBUG) {
                LeaseClient.debug("Cluster leader is not present ! refuse renew leases for " + string);
            }
            throw this.createIOException("Cluster leader is not present ! refuse renew leases for " + string);
        }
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        LeaseMessage leaseMessage = new LeaseMessage(string, set, n);
        if (DEBUG) {
            LeaseClient.debug("requesting renew leases " + leaseMessage + " from LeaseServer " + serverInformation);
        }
        LeaseResponse leaseResponse = (LeaseResponse)clusterMessageSender.send((ClusterMessage)leaseMessage, serverInformation);
        if (DEBUG) {
            LeaseClient.debug("received response to the lease message " + leaseResponse);
        }
        return (Integer)leaseResponse.getResult();
    }

    public int renewAllLeases(int n, String string) throws IOException {
        ServerInformation serverInformation = ClusterLeaderService.getLeader();
        if (serverInformation == null) {
            if (DEBUG) {
                LeaseClient.debug("Cluster leader is not present ! refuse renew all leases for " + string);
            }
            throw this.createIOException("Cluster leader is not present ! refuse renew all leases for " + string);
        }
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        LeaseMessage leaseMessage = new LeaseMessage(n, string);
        if (DEBUG) {
            LeaseClient.debug("requesting renew all leases " + leaseMessage + " from LeaseServer " + serverInformation);
        }
        LeaseResponse leaseResponse = (LeaseResponse)clusterMessageSender.send((ClusterMessage)leaseMessage, serverInformation);
        if (DEBUG) {
            LeaseClient.debug("received response to the lease message " + leaseResponse);
        }
        return (Integer)leaseResponse.getResult();
    }

    public String[] findExpiredLeases(int n) throws IOException {
        ServerInformation serverInformation = ClusterLeaderService.getLeader();
        if (serverInformation == null) {
            if (DEBUG) {
                LeaseClient.debug("Cluster leader is not present ! refuse find expired leases");
            }
            throw this.createIOException("unable to find expired leases  as the cluster leader is unavailable");
        }
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        LeaseMessage leaseMessage = LeaseMessage.findExpiredLeasesMessage(n);
        if (DEBUG) {
            LeaseClient.debug("requesting expired leases " + leaseMessage + " from LeaseServer " + serverInformation);
        }
        LeaseResponse leaseResponse = (LeaseResponse)clusterMessageSender.send((ClusterMessage)leaseMessage, serverInformation);
        if (DEBUG) {
            LeaseClient.debug("received response to the lease message " + leaseResponse);
        }
        return (String[])leaseResponse.getResult();
    }

    public synchronized void stateChanged(String string, String string2) {
        String string3 = string2.intern();
        this.clusterFormationInProgress = string3 == "discovery" || string3 == "formation" || string3 == "formation_leader";
    }

    private synchronized IOException createIOException(String string) {
        if (this.clusterFormationInProgress) {
            return new ClusterReformationInProgressException(string);
        }
        return new IOException(string);
    }

    private static boolean debugEnabled() {
        return debugLeaseClient.isEnabled() || DebugLogger.isDebugEnabled();
    }

    private static void debug(String string) {
        DebugLogger.debug("[LeaseClient] " + string);
    }
}

