/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.util.Set;
import weblogic.cluster.ClusterService;
import weblogic.cluster.messaging.internal.BaseClusterMessage;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.messaging.internal.ServerInformationImpl;

class LeaseMessage
extends BaseClusterMessage {
    static final long serialVersionUID = 4300768677385372050L;
    static final String ACQUIRE = "acquire";
    static final String RELEASE = "release";
    static final String FIND_OWNER = "find_owner";
    static final String FIND_PREVIOUS_OWNER = "find_previous_owner";
    static final String EXPIRED_LEASES = "expired";
    static final String RENEW_ALL = "renew_all";
    static final String RENEW_LEASES = "renew_leases";
    private final String leaseName;
    private final String owner;
    private final int leaseTimeout;
    private final int healthCheckPeriod;
    private String requestType;
    private final int gracePeriod;
    private final Set leasesToRenew;

    LeaseMessage(String string, String string2, int n) {
        super(LeaseMessage.getLocalInformation(), 4);
        this.leaseName = string;
        this.owner = string2;
        this.leaseTimeout = n;
        this.healthCheckPeriod = -1;
        this.requestType = ACQUIRE;
        this.gracePeriod = -1;
        this.leasesToRenew = null;
    }

    LeaseMessage(String string, String string2) {
        super(LeaseMessage.getLocalInformation(), 4);
        this.leaseName = string;
        this.owner = string2;
        this.leaseTimeout = -1;
        this.healthCheckPeriod = -1;
        this.requestType = RELEASE;
        this.gracePeriod = -1;
        this.leasesToRenew = null;
    }

    public LeaseMessage(String string) {
        super(LeaseMessage.getLocalInformation(), 4);
        this.leaseName = string;
        this.owner = null;
        this.leaseTimeout = -1;
        this.healthCheckPeriod = -1;
        this.requestType = FIND_OWNER;
        this.gracePeriod = -1;
        this.leasesToRenew = null;
    }

    public LeaseMessage(int n) {
        super(LeaseMessage.getLocalInformation(), 4);
        this.leaseName = null;
        this.owner = null;
        this.leaseTimeout = -1;
        this.healthCheckPeriod = -1;
        this.requestType = EXPIRED_LEASES;
        this.gracePeriod = n;
        this.leasesToRenew = null;
    }

    LeaseMessage(int n, String string) {
        super(LeaseMessage.getLocalInformation(), 4);
        this.leaseName = null;
        this.owner = string;
        this.leaseTimeout = -1;
        this.healthCheckPeriod = n;
        this.gracePeriod = -1;
        this.requestType = RENEW_ALL;
        this.leasesToRenew = null;
    }

    LeaseMessage(String string, Set set, int n) {
        super(LeaseMessage.getLocalInformation(), 4);
        this.leaseName = null;
        this.owner = string;
        this.leaseTimeout = -1;
        this.healthCheckPeriod = n;
        this.gracePeriod = -1;
        this.requestType = RENEW_LEASES;
        this.leasesToRenew = set;
    }

    static LeaseMessage createFindPreviousOwnerMessage(String string) {
        LeaseMessage leaseMessage = new LeaseMessage(string);
        leaseMessage.requestType = FIND_PREVIOUS_OWNER;
        return leaseMessage;
    }

    static LeaseMessage findExpiredLeasesMessage(int n) {
        LeaseMessage leaseMessage = new LeaseMessage(n);
        return leaseMessage;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getLeaseName() {
        return this.leaseName;
    }

    public String getOwner() {
        return this.owner;
    }

    public int getLeaseTimeout() {
        return this.leaseTimeout;
    }

    public int getHealthCheckPeriod() {
        return this.healthCheckPeriod;
    }

    public int getGracePeriod() {
        return this.gracePeriod;
    }

    public Set getLeasesToRenew() {
        return this.leasesToRenew;
    }

    public String toString() {
        String string = this.requestType.equalsIgnoreCase(RENEW_LEASES) ? this.leasesToRenew.toString() : this.leaseName;
        return "[LeaseMessage " + this.requestType + ", leaseNames " + string + ", owner " + this.owner + ", leaseTimeout " + this.leaseTimeout + ", healthCheckPeriod " + this.healthCheckPeriod + ", gracePeriod " + this.gracePeriod + "]";
    }

    static ServerInformation getLocalInformation() {
        return new ServerInformationImpl(ClusterService.getClusterService().getLocalMember());
    }
}

