/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.io.IOException;
import java.util.Set;
import weblogic.cluster.leasing.databaseless.ClusterLeader;
import weblogic.cluster.leasing.databaseless.LeaseMessage;
import weblogic.cluster.leasing.databaseless.LeaseResponse;
import weblogic.cluster.leasing.databaseless.LeaseTableUpdateException;
import weblogic.cluster.leasing.databaseless.LeaseView;
import weblogic.cluster.leasing.databaseless.ReplicatedLeaseTable;
import weblogic.cluster.messaging.internal.ClusterMessageProcessingException;
import weblogic.cluster.messaging.internal.ClusterResponse;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.singleton.LeasingBasis;
import weblogic.cluster.singleton.MissedHeartbeatException;
import weblogic.cluster.singleton.SimpleLeasingBasis;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class LeaseServer
implements LeasingBasis {
    private static final DebugCategory debugLeaseServer = Debug.getCategory((String)"weblogic.cluster.leasing.LeaseServer");
    private static final boolean DEBUG = LeaseServer.debugEnabled();
    private final SimpleLeasingBasis simpleBasis;

    LeaseServer(ClusterLeader clusterLeader, LeaseView leaseView) {
        ReplicatedLeaseTable replicatedLeaseTable = new ReplicatedLeaseTable(clusterLeader, leaseView);
        this.simpleBasis = new SimpleLeasingBasis(replicatedLeaseTable);
        if (DEBUG) {
            LeaseServer.debug("created basis with entries " + leaseView.getLeaseTableReplica());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(String string, String string2, int n) {
        SimpleLeasingBasis simpleLeasingBasis = this.simpleBasis;
        synchronized (simpleLeasingBasis) {
            try {
                boolean bl = this.simpleBasis.acquire(string, string2, n);
                if (bl) {
                    if (DEBUG) {
                        LeaseServer.debug("acquire: successfully updated other servers for " + string + " requested by " + string2 + ". Updated master lease table " + "and granted lease to " + string2 + " for lease timeout of " + n);
                    }
                    return true;
                }
                if (DEBUG) {
                    String string3 = this.simpleBasis.findOwner(string);
                    LeaseServer.debug("acquire: " + string3 + " owns the lease " + string + " requested by " + string2 + ". lease acquire is denied");
                }
                return false;
            }
            catch (LeaseTableUpdateException leaseTableUpdateException) {
                if (DEBUG) {
                    LeaseServer.debug("acquire: failed to update other servers for " + string + " requested by " + string2 + ". Lease is denied!");
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(String string, String string2) throws IOException {
        SimpleLeasingBasis simpleLeasingBasis = this.simpleBasis;
        synchronized (simpleLeasingBasis) {
            String string3 = this.simpleBasis.findOwner(string);
            if (DEBUG) {
                LeaseServer.debug("release: got owner " + string3 + " for lease name " + string);
            }
            if (string3 == null) {
                return;
            }
            if (string3 != null && !string3.equalsIgnoreCase(string2)) {
                return;
            }
            if (DEBUG) {
                LeaseServer.debug("release: removing " + string + " from master " + "after updating other servers");
            }
            this.simpleBasis.release(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findOwner(String string) {
        SimpleLeasingBasis simpleLeasingBasis = this.simpleBasis;
        synchronized (simpleLeasingBasis) {
            String string2 = this.simpleBasis.findOwner(string);
            if (DEBUG) {
                LeaseServer.debug("findOwner: got owner " + string2 + " for lease name " + string);
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findPreviousOwner(String string) {
        SimpleLeasingBasis simpleLeasingBasis = this.simpleBasis;
        synchronized (simpleLeasingBasis) {
            String string2 = this.simpleBasis.findPreviousOwner(string);
            if (DEBUG) {
                LeaseServer.debug("findPreviousOwner: got owner " + string2 + " for lease name " + string);
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int renewAllLeases(int n, String string) throws MissedHeartbeatException {
        SimpleLeasingBasis simpleLeasingBasis = this.simpleBasis;
        synchronized (simpleLeasingBasis) {
            try {
                int n2 = this.simpleBasis.renewAllLeases(n, string);
                if (DEBUG) {
                    LeaseServer.debug("renewAllLeases: successfully renewed " + n2 + " leases for " + string);
                }
                return n2;
            }
            catch (LeaseTableUpdateException leaseTableUpdateException) {
                if (DEBUG) {
                    LeaseServer.debug("renewAllLeases: update failed on other servers. not renewing leases owned by " + string);
                }
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int renewLeases(String string, Set set, int n) throws MissedHeartbeatException {
        SimpleLeasingBasis simpleLeasingBasis = this.simpleBasis;
        synchronized (simpleLeasingBasis) {
            try {
                int n2 = this.simpleBasis.renewLeases(string, set, n);
                if (DEBUG) {
                    LeaseServer.debug("renewLeases: successfully renewed " + n2 + " leases for " + string);
                }
                return n2;
            }
            catch (LeaseTableUpdateException leaseTableUpdateException) {
                if (DEBUG) {
                    LeaseServer.debug("renewLeases: update failed on other servers. not renewing leases owned by " + string);
                }
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findExpiredLeases(int n) {
        SimpleLeasingBasis simpleLeasingBasis = this.simpleBasis;
        synchronized (simpleLeasingBasis) {
            return this.simpleBasis.findExpiredLeases(n);
        }
    }

    public ClusterResponse process(LeaseMessage leaseMessage) throws ClusterMessageProcessingException {
        if ("acquire".equals(leaseMessage.getRequestType())) {
            boolean bl = this.acquire(leaseMessage.getLeaseName(), leaseMessage.getOwner(), leaseMessage.getLeaseTimeout());
            return new LeaseResponse(bl, leaseMessage);
        }
        if ("release".equals(leaseMessage.getRequestType())) {
            try {
                this.release(leaseMessage.getLeaseName(), leaseMessage.getOwner());
            }
            catch (IOException iOException) {
                throw new ClusterMessageProcessingException(iOException);
            }
            return new LeaseResponse(Boolean.TRUE, leaseMessage);
        }
        if ("find_owner".equals(leaseMessage.getRequestType())) {
            String string = this.findOwner(leaseMessage.getLeaseName());
            return new LeaseResponse(string, leaseMessage);
        }
        if ("renew_all".equals(leaseMessage.getRequestType())) {
            try {
                int n = this.renewAllLeases(leaseMessage.getHealthCheckPeriod(), leaseMessage.getOwner());
                return new LeaseResponse(n, leaseMessage);
            }
            catch (MissedHeartbeatException missedHeartbeatException) {
                throw new ClusterMessageProcessingException(missedHeartbeatException);
            }
        }
        if ("renew_leases".equals(leaseMessage.getRequestType())) {
            try {
                int n = this.renewLeases(leaseMessage.getOwner(), leaseMessage.getLeasesToRenew(), leaseMessage.getHealthCheckPeriod());
                return new LeaseResponse(n, leaseMessage);
            }
            catch (MissedHeartbeatException missedHeartbeatException) {
                throw new ClusterMessageProcessingException(missedHeartbeatException);
            }
        }
        if ("expired".equals(leaseMessage.getRequestType())) {
            String[] stringArray = this.findExpiredLeases(leaseMessage.getGracePeriod());
            return new LeaseResponse(stringArray, leaseMessage);
        }
        if ("find_previous_owner".equals(leaseMessage.getRequestType())) {
            String string = this.findPreviousOwner(leaseMessage.getLeaseName());
            return new LeaseResponse(string, leaseMessage);
        }
        throw new AssertionError((Object)(leaseMessage + " is unsupported !"));
    }

    private static boolean debugEnabled() {
        return debugLeaseServer.isEnabled() || DebugLogger.isDebugEnabled();
    }

    private static void debug(String string) {
        DebugLogger.debug("[LeaseServer] " + string);
    }
}

