/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.cluster.leasing.databaseless.LeaseTableUpdateMessage;
import weblogic.cluster.messaging.internal.ClusterMessageProcessingException;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.singleton.LeaseManager;
import weblogic.cluster.singleton.SimpleLeasingBasis;
import weblogic.protocol.LocalServerIdentity;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class LeaseView
implements Serializable {
    static final long serialVersionUID = 7210518548000338390L;
    private static final DebugCategory debugLeaseView = Debug.getCategory((String)"weblogic.cluster.leasing.LeaseView");
    private static final boolean DEBUG = LeaseView.debugEnabled();
    private static final long GUARD_TIME = 5000L;
    private long versionNumber;
    private HashMap leaseTableReplica;
    private HashMap localLeases;
    private String serverName;

    LeaseView(String string, HashMap hashMap) {
        this(string, hashMap, 0L);
    }

    LeaseView(String string, HashMap hashMap, long l) {
        this.versionNumber = l;
        this.serverName = string;
        this.leaseTableReplica = hashMap == null ? new HashMap() : hashMap;
        this.localLeases = new HashMap();
        if (DEBUG) {
            LeaseView.debug("created lease view for " + string + " with entries " + this.leaseTableReplica);
        }
    }

    private static void debug(String string) {
        DebugLogger.debug("[LeaseView] " + string);
    }

    synchronized void process(LeaseTableUpdateMessage leaseTableUpdateMessage) throws ClusterMessageProcessingException {
        if (leaseTableUpdateMessage.getVersion() != this.versionNumber + 1L) {
            throw new ClusterMessageProcessingException("unacceptable lease view update. local version " + this.versionNumber + " and received version is " + leaseTableUpdateMessage.getVersion());
        }
        ++this.versionNumber;
        if (DEBUG) {
            LeaseView.debug("executing " + leaseTableUpdateMessage);
        }
        if (leaseTableUpdateMessage.getOperation() == 1) {
            this.leaseTableReplica.put(leaseTableUpdateMessage.getKey(), leaseTableUpdateMessage.getValue());
            Object v = this.localLeases.get(leaseTableUpdateMessage.getKey());
            if (v != null && !v.equals(leaseTableUpdateMessage.getValue())) {
                if (DEBUG) {
                    LeaseView.debug("removing " + leaseTableUpdateMessage.getKey() + " as it has expired. local server no longer owns this lease !");
                }
                this.localLeases.remove(leaseTableUpdateMessage.getKey());
            }
        } else if (leaseTableUpdateMessage.getOperation() == 2) {
            this.leaseTableReplica.remove(leaseTableUpdateMessage.getKey());
        } else if (leaseTableUpdateMessage.getOperation() == 3) {
            this.leaseTableReplica.putAll(leaseTableUpdateMessage.getMap());
        } else {
            throw new AssertionError((Object)("unsupported lease update operation " + leaseTableUpdateMessage));
        }
    }

    synchronized void leaseAcquiredByLocalServer(String string, int n) {
        String string2 = LeaseManager.getOwnerIdentity(LocalServerIdentity.getIdentity());
        SimpleLeasingBasis.LeaseEntry leaseEntry = new SimpleLeasingBasis.LeaseEntry(string2, string, n);
        this.localLeases.put(leaseEntry.getLeaseName(), leaseEntry);
        if (DEBUG) {
            LeaseView.debug("added " + leaseEntry + " to list of leases owned by " + "this server");
        }
    }

    synchronized void leaseReleasedByLocalServer(String string) {
        this.localLeases.remove(string);
        if (DEBUG) {
            LeaseView.debug("removed " + string + " from the list of leases owned " + "by this server");
        }
    }

    synchronized int leasesOwnedByLocalServer() {
        return this.localLeases.size();
    }

    synchronized void merge(LeaseView leaseView) {
        if (leaseView == null) {
            return;
        }
        this.leaseTableReplica.putAll(leaseView.localLeases);
    }

    synchronized void prepareToBecomeLeader() {
        this.leaseTableReplica.putAll(this.localLeases);
        Iterator iterator = this.leaseTableReplica.values().iterator();
        long l = System.currentTimeMillis() + 5000L;
        while (iterator.hasNext()) {
            SimpleLeasingBasis.LeaseEntry leaseEntry = (SimpleLeasingBasis.LeaseEntry)iterator.next();
            leaseEntry.setTimestamp(l);
        }
    }

    public HashMap getLeaseTableReplica() {
        return this.leaseTableReplica;
    }

    long getVersionNumber() {
        return this.versionNumber;
    }

    public synchronized void processStateDump(LeaseView leaseView) {
        if (leaseView == null || this.versionNumber == leaseView.getVersionNumber()) {
            return;
        }
        if (DEBUG) {
            LeaseView.debug("resetting lease view with " + leaseView.getLeaseTableReplica());
        }
        this.leaseTableReplica = leaseView.getLeaseTableReplica();
        this.versionNumber = leaseView.getVersionNumber();
    }

    void incrementVersionNumber() {
        ++this.versionNumber;
    }

    public String toString() {
        return "LeaseView for " + this.serverName + " with version " + this.versionNumber + "\nLeaseTableReplica contents: " + this.leaseTableReplica + "\nleases owned: " + this.localLeases;
    }

    private static boolean debugEnabled() {
        return debugLeaseView.isEnabled() || DebugLogger.isDebugEnabled();
    }
}

