/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterService;
import weblogic.cluster.leasing.databaseless.ClusterGroupView;
import weblogic.cluster.leasing.databaseless.ClusterState;
import weblogic.cluster.leasing.databaseless.DisconnectActionListener;
import weblogic.cluster.leasing.databaseless.DiscoveryService;
import weblogic.cluster.leasing.databaseless.EnvironmentFactory;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.messaging.internal.ServerInformationImpl;
import weblogic.health.HealthMonitorService;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

final class MulticastBasedDiscoveryService
implements DiscoveryService,
TimerListener,
DisconnectActionListener {
    private static final DebugCategory debugDiscoveryService = Debug.getCategory((String)"weblogic.cluster.leasing.DiscoveryService");
    private static final boolean DEBUG = MulticastBasedDiscoveryService.debugEnabled();
    private ServerInformation localInformation;
    private boolean stopped;
    private ClusterGroupView groupView;

    MulticastBasedDiscoveryService() {
    }

    public static MulticastBasedDiscoveryService getInstance() {
        return Factory.THE_ONE;
    }

    public void start(int n) {
        if (!ClusterState.getInstance().setState("discovery")) {
            if (DEBUG) {
                MulticastBasedDiscoveryService.debug("unable to transition from " + ClusterState.getInstance().getState() + " to " + "discovery");
            }
            return;
        }
        this.localInformation = MulticastBasedDiscoveryService.createLocalServerInformation();
        if (DEBUG) {
            MulticastBasedDiscoveryService.debug("starting discovery timer that will expire in " + n + " seconds");
        }
        TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this, (long)(n * 1000));
    }

    private static ServerInformation createLocalServerInformation() {
        return new ServerInformationImpl(ClusterService.getClusterService().getLocalMember());
    }

    private ClusterGroupView discoveredGroupView() {
        Collection collection = ClusterService.getClusterService().getAllRemoteMembers();
        if (DEBUG) {
            MulticastBasedDiscoveryService.debug("ClusterService has " + collection.size() + " members");
        }
        if (collection.size() == 0) {
            if (DEBUG) {
                MulticastBasedDiscoveryService.debug("this is the only running cluster member !");
            }
            return new ClusterGroupView(this.localInformation, null);
        }
        Iterator iterator = collection.iterator();
        TreeSet<ServerInformation> treeSet = new TreeSet<ServerInformation>();
        treeSet.add(this.localInformation);
        while (iterator.hasNext()) {
            ClusterMemberInfo clusterMemberInfo = (ClusterMemberInfo)iterator.next();
            ServerInformationImpl serverInformationImpl = new ServerInformationImpl(clusterMemberInfo);
            if (DEBUG) {
                MulticastBasedDiscoveryService.debug("discovered " + serverInformationImpl);
            }
            treeSet.add(serverInformationImpl);
        }
        return new ClusterGroupView(treeSet);
    }

    private static void debug(String string) {
        DebugLogger.debug("[DiscoveryService] " + string);
    }

    public void timerExpired(Timer timer) {
        String string = ClusterState.getInstance().getState().intern();
        if (DEBUG) {
            MulticastBasedDiscoveryService.debug("discovery timer detected state " + string);
        }
        if (string != "discovery") {
            if (DEBUG) {
                MulticastBasedDiscoveryService.debug("discovery timer quit as state is " + string);
            }
            return;
        }
        this.groupView = this.discoveredGroupView();
        if (DEBUG) {
            MulticastBasedDiscoveryService.debug("discovered group view " + this.groupView);
        }
        if (this.groupView.isSeniorMost(this.localInformation)) {
            if (DEBUG) {
                MulticastBasedDiscoveryService.debug("we are the seniormost member. try forming the cluster");
            }
            EnvironmentFactory.getClusterFormationService().start(this.groupView, null);
        } else {
            this.registerForDisconnects();
        }
    }

    private synchronized void registerForDisconnects() {
        if (this.stopped) {
            return;
        }
        if (DEBUG) {
            MulticastBasedDiscoveryService.debug("we are not the senior most. registering for disconnects");
        }
        EnvironmentFactory.getClusterMemberDisconnectMonitor().start(this.groupView, this);
    }

    public synchronized void stop() {
        if (DEBUG) {
            MulticastBasedDiscoveryService.debug("stopped !");
        }
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        EnvironmentFactory.getClusterMemberDisconnectMonitor().stop();
    }

    public void OnBecomingSeniorMostMember() {
        if (DEBUG) {
            MulticastBasedDiscoveryService.debug("DisconnectMonitor notified that we are seniormost! trying to form the cluster");
        }
        if (this.groupView.isSeniorMost(this.localInformation)) {
            if (DEBUG) {
                MulticastBasedDiscoveryService.debug("we are the seniormost member. try forming the cluster");
            }
            EnvironmentFactory.getClusterMemberDisconnectMonitor().stop();
            EnvironmentFactory.getClusterFormationService().start(this.groupView, null);
        }
    }

    public synchronized void OnLosingServerReachabilityMajority() {
        if (DEBUG) {
            MulticastBasedDiscoveryService.debug("OnLosingServerReachabilityMajority() called ! marking the server as failed");
        }
        String string = "Server is not in the majority cluster partition";
        ClusterState.getInstance().setState("failed", string);
        this.stop();
        HealthMonitorService.subsystemFailed("DatabaseLessLeasing", string);
    }

    public synchronized void onLosingLeader() {
        this.groupView.removeLeader();
    }

    public synchronized void onLosingMember(ServerInformation serverInformation) {
        this.groupView.removeMember(serverInformation);
    }

    private static boolean debugEnabled() {
        return debugDiscoveryService.isEnabled() || DebugLogger.isDebugEnabled();
    }

    private static final class Factory {
        static final MulticastBasedDiscoveryService THE_ONE = new MulticastBasedDiscoveryService();

        private Factory() {
        }
    }
}

