/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterService;
import weblogic.cluster.InboundService;
import weblogic.cluster.leasing.databaseless.ClusterMember;
import weblogic.cluster.leasing.databaseless.LeaderQueryMessage;
import weblogic.cluster.leasing.databaseless.LeaderQueryResponse;
import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageFactory;
import weblogic.cluster.messaging.internal.ClusterMessageSender;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.MachineState;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.messaging.internal.ServerInformationImpl;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class PrimordialClusterLeaderService
extends AbstractServerService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean DEBUG = true;
    private static PrimordialClusterLeaderService THE_ONE;
    private boolean stopped;
    private boolean canQuery = false;
    private List machineList;
    private ServerInformation leader = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimordialClusterLeaderService() {
        Class clazz = PrimordialClusterLeaderService.class;
        synchronized (clazz) {
            if (THE_ONE != null) {
                throw new AssertionError((Object)"PrimordialClusterLeaderService cannot be initialized more than once !");
            }
            THE_ONE = this;
        }
    }

    public static PrimordialClusterLeaderService getInstance() {
        return THE_ONE;
    }

    public synchronized void start() throws ServiceFailureException {
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (clusterMBean == null || !"consensus".equals(clusterMBean.getMigrationBasis()) || !PrimordialClusterLeaderService.isAutoServiceMigrationEnabled(clusterMBean) && !PrimordialClusterLeaderService.isAutoMigratableCluster(clusterMBean)) {
            this.debug("Not starting the PrimordialClusterLeaderService");
            return;
        }
        this.canQuery = true;
        this.machineList = this.createMachineList(clusterMBean);
        InboundService.startListening();
        long l = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getDatabaseLessLeasingBasis().getMemberDiscoveryTimeout();
        long l2 = System.currentTimeMillis() + l;
        while (true) {
            try {
                this.debug("waiting for " + l + " seconds to sync ... ");
                ((Object)((Object)this)).wait(l * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            ServerInformation serverInformation = this.getLeaderInformation();
            if (serverInformation != null || l3 >= l2) break;
            l = l2 - l3;
        }
        this.debug("done waiting to sync with cluster leader");
    }

    public synchronized void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        if (clusterMembersChangeEvent.getAction() == 0) {
            ((Object)((Object)this)).notify();
        }
    }

    ServerInformation getLeaderInformation() {
        return this.getLeaderInformationInternal(false);
    }

    public void stop() {
        this.stopped = true;
    }

    ServerInformation getLeaderInformationInternal(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        if (!this.canQuery || this.stopped && !bl) {
            return null;
        }
        if (this.leader != null) {
            try {
                object3 = this.queryForLeader(this.leader);
                if (object3 != null) {
                    this.leader = object3;
                    return object3;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        object3 = ClusterService.getClusterService().getAllRemoteMembers().iterator();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        while (object3.hasNext()) {
            object2 = (ClusterMemberInfo)object3.next();
            object = new ServerInformationImpl((ClusterMemberInfo)object2);
            this.debug("discovered " + object);
            treeSet.add(object);
        }
        if (treeSet.size() > 0) {
            try {
                return this.queryForLeader((ServerInformation)treeSet.first());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (bl) {
            object2 = this.machineList.iterator();
            while (object2.hasNext()) {
                object = (MachineMBean)object2.next();
                MachineState machineState = MachineState.getMachineState((MachineMBean)object, true);
                List list = machineState.getServersInState("RUNNING");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    ServerInformationImpl serverInformationImpl = new ServerInformationImpl(string);
                    try {
                        ServerInformation serverInformation = this.queryForLeader(serverInformationImpl);
                        if (serverInformation == null) continue;
                        this.leader = serverInformation;
                        return serverInformation;
                    }
                    catch (RemoteException remoteException) {
                    }
                }
            }
        }
        if (treeSet.size() > 0) {
            return (ServerInformation)treeSet.first();
        }
        return null;
    }

    private ServerInformation queryForLeader(ServerInformation serverInformation) throws RemoteException {
        ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
        LeaderQueryMessage leaderQueryMessage = LeaderQueryMessage.create(ClusterMember.getInstance().getLocalServerInformation());
        this.debug("requesting cluster leader " + leaderQueryMessage + " from " + serverInformation);
        LeaderQueryResponse leaderQueryResponse = (LeaderQueryResponse)clusterMessageSender.send((ClusterMessage)leaderQueryMessage, serverInformation);
        this.debug("received response to the cluster leader query  " + leaderQueryResponse);
        return leaderQueryResponse.getLeaderInformation();
    }

    private List createMachineList(ClusterMBean clusterMBean) {
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        ArrayList<MachineMBean> arrayList = new ArrayList<MachineMBean>();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            ServerMBean serverMBean = serverMBeanArray[i];
            MachineMBean machineMBean = serverMBean.getMachine();
            if (arrayList.contains(machineMBean)) continue;
            arrayList.add(machineMBean);
        }
        return arrayList;
    }

    private static boolean isAutoServiceMigrationEnabled(ClusterMBean clusterMBean) {
        MigratableTargetMBean[] migratableTargetMBeanArray = clusterMBean.getMigratableTargets();
        if (migratableTargetMBeanArray == null) {
            return false;
        }
        for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
            if ("manual".equals(migratableTargetMBeanArray[i].getMigrationPolicy())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAutoMigratableCluster(ClusterMBean clusterMBean) {
        if (clusterMBean == null) {
            return false;
        }
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBeanArray[i].isAutoMigrationEnabled()) continue;
            return true;
        }
        return false;
    }

    private void debug(String string) {
        DebugLogger.debug("[PrimordialClusterLeaderService] " + string);
    }
}

