/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.cluster.leasing.databaseless.ClusterGroupView;
import weblogic.cluster.leasing.databaseless.ClusterLeaderService;
import weblogic.cluster.leasing.databaseless.ClusterMemberDisconnectMonitor;
import weblogic.cluster.leasing.databaseless.DisconnectActionListener;
import weblogic.cluster.leasing.databaseless.EnvironmentFactory;
import weblogic.cluster.leasing.databaseless.GroupViewListener;
import weblogic.cluster.leasing.databaseless.MachineFailureEvent;
import weblogic.cluster.leasing.databaseless.ServerFailureDetector;
import weblogic.cluster.leasing.databaseless.ServerFailureEvent;
import weblogic.cluster.leasing.databaseless.ServerFailureListener;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.SRMResult;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.management.configuration.DatabaseLessLeasingBasisMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class RMIBasedDisconnectMonitorImpl
implements ClusterMemberDisconnectMonitor,
ServerFailureListener,
GroupViewListener,
TimerListener {
    private static final DebugCategory debugDisconnectMonitor;
    private static final boolean DEBUG;
    private static final AuthenticatedSubject kernelId;
    private ClusterGroupView groupView;
    private DisconnectActionListener listener;
    private ServerInformation localInformation;
    private Map detectorMap = new HashMap();
    private ServerInformation leaderInfo;
    private boolean isLeader;
    private Timer srmCheckTimer;
    private Set deadServers;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ClusterMemberDisconnectMonitor getInstance() {
        return Factory.THE_ONE;
    }

    public synchronized void start(ClusterGroupView clusterGroupView, DisconnectActionListener disconnectActionListener) {
        if (DEBUG) {
            RMIBasedDisconnectMonitorImpl.debug("inside start()");
        }
        if (!($assertionsDisabled || this.listener == null && this.groupView == null)) {
            throw new AssertionError();
        }
        this.groupView = clusterGroupView;
        this.listener = disconnectActionListener;
        this.deadServers = new HashSet();
        this.leaderInfo = clusterGroupView.getLeaderInformation();
        if (!$assertionsDisabled && this.leaderInfo == null) {
            throw new AssertionError();
        }
        this.localInformation = ClusterLeaderService.getInstance().getLocalServerInformation();
        if (this.leaderInfo.equals(this.localInformation)) {
            int n;
            this.isLeader = true;
            ServerInformation[] serverInformationArray = clusterGroupView.getRemoteMembers(this.localInformation);
            if (DEBUG) {
                RMIBasedDisconnectMonitorImpl.debug("we are the leader ! create server failure detectors for all members in the group view");
            }
            for (n = 0; n < serverInformationArray.length; ++n) {
                this.createFailureDetector(serverInformationArray[n]);
            }
            n = RMIBasedDisconnectMonitorImpl.getLeaderSRMCheckPeriod();
            this.srmCheckTimer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this, 0L, (long)n);
        } else {
            if (DEBUG) {
                RMIBasedDisconnectMonitorImpl.debug("creating server failure detector for " + this.leaderInfo);
            }
            this.createFailureDetector(this.leaderInfo);
            this.srmCheckTimer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this, 0L);
        }
        this.groupView.setGroupViewListener(this);
    }

    private static int getLeaderSRMCheckPeriod() {
        DatabaseLessLeasingBasisMBean databaseLessLeasingBasisMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getDatabaseLessLeasingBasis();
        if (!databaseLessLeasingBasisMBean.isPeriodicSRMCheckEnabled()) {
            if (DEBUG) {
                RMIBasedDisconnectMonitorImpl.debug("periodic SRM check is disabled !");
            }
            return 0;
        }
        if (DEBUG) {
            RMIBasedDisconnectMonitorImpl.debug("periodic SRM check is enabled !");
        }
        int n = databaseLessLeasingBasisMBean.getMemberDiscoveryTimeout();
        return n * 1000 / 2;
    }

    public synchronized void stop() {
        if (this.srmCheckTimer != null) {
            this.srmCheckTimer.cancel();
        }
        Iterator iterator = this.detectorMap.values().iterator();
        while (iterator.hasNext()) {
            ((ServerFailureDetector)iterator.next()).stop();
        }
        this.listener = null;
        if (this.groupView != null) {
            this.groupView.setGroupViewListener(null);
        }
        this.groupView = null;
        this.deadServers = null;
    }

    public synchronized void memberAdded(ServerInformation serverInformation) {
        if (this.isLeader) {
            this.createFailureDetector(serverInformation);
        }
    }

    public void memberRemoved(ServerInformation serverInformation) {
        if (this.detectorMap.get(serverInformation) == null) {
            this.onServerFailure(serverInformation);
        }
    }

    public void onServerFailure(ServerFailureEvent serverFailureEvent) {
        this.onServerFailure(serverFailureEvent.getServerInformation());
    }

    public synchronized void onMachineFailure(MachineFailureEvent machineFailureEvent) {
        if (this.listener == null) {
            return;
        }
        List list = machineFailureEvent.getFailedServers();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServerInformation serverInformation = this.groupView.getServerInformation((String)iterator.next());
            if (serverInformation == null || this.deadServers.contains(serverInformation)) continue;
            this.deadServers.add(serverInformation);
            if (this.leaderInfo.equals(serverInformation)) {
                if (DEBUG) {
                    RMIBasedDisconnectMonitorImpl.debug("MachineFailure: leader is really dead ! Invoking onLosingLeader()");
                }
                this.listener.onLosingLeader();
                continue;
            }
            if (DEBUG) {
                RMIBasedDisconnectMonitorImpl.debug("MachineFailure: " + serverInformation.getServerName() + " is dead ! Invoking onLosingMember()");
            }
            this.listener.onLosingMember(serverInformation);
        }
        this.reachabilityCheckHelper(machineFailureEvent.getMachineName());
    }

    private synchronized void onServerFailure(ServerInformation serverInformation) {
        if (this.listener == null || this.deadServers.contains(serverInformation)) {
            return;
        }
        this.deadServers.add(serverInformation);
        if (this.leaderInfo.equals(serverInformation)) {
            if (DEBUG) {
                RMIBasedDisconnectMonitorImpl.debug("leader is really dead ! Invoking onLosingLeader()");
            }
            this.listener.onLosingLeader();
        } else {
            if (DEBUG) {
                RMIBasedDisconnectMonitorImpl.debug(serverInformation.getServerName() + " is dead ! Invoking onLosingMember()");
            }
            this.listener.onLosingMember(serverInformation);
        }
        this.reachabilityCheckHelper(null);
    }

    private void reachabilityCheckHelper(String string) {
        SRMResult sRMResult = this.getSRMResult(string, true);
        if (!sRMResult.hasReachabilityMajority()) {
            if (DEBUG) {
                RMIBasedDisconnectMonitorImpl.debug("a member is dead but this server does not have reachability majority. OnLosingServerReachabilityMajority()");
            }
            this.listener.OnLosingServerReachabilityMajority();
            return;
        }
        if (this.groupView.isSeniorMost(this.localInformation)) {
            if (DEBUG) {
                RMIBasedDisconnectMonitorImpl.debug("local server is the seniormost member !");
            }
            this.listener.OnBecomingSeniorMostMember();
            return;
        }
        ServerInformation serverInformation = this.groupView.getSeniorMost();
        if (this.detectorMap.get(serverInformation) == null) {
            this.createFailureDetector(serverInformation);
        }
    }

    private void createFailureDetector(ServerInformation serverInformation) {
        ServerFailureDetector serverFailureDetector = EnvironmentFactory.getFailureDetector(serverInformation.getServerName());
        serverFailureDetector.start(serverInformation, this);
        this.detectorMap.put(serverInformation, serverFailureDetector);
    }

    private SRMResult getSRMResult(String string, boolean bl) {
        String string2 = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getName();
        return EnvironmentFactory.getServerReachabilityMajorityService().performSRMCheck(this.leaderInfo, string2, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        if (this.listener == null) {
            return;
        }
        SRMResult sRMResult = this.getSRMResult(null, false);
        if (sRMResult.hasReachabilityMajority()) {
            return;
        }
        if (DEBUG) {
            RMIBasedDisconnectMonitorImpl.debug("SRM timer determined that the leader does not have reachability majority. OnLosingServerReachabilityMajority()");
        }
        RMIBasedDisconnectMonitorImpl rMIBasedDisconnectMonitorImpl = this;
        synchronized (rMIBasedDisconnectMonitorImpl) {
            if (this.listener == null) {
                return;
            }
            this.listener.OnLosingServerReachabilityMajority();
        }
    }

    private static void debug(String string) {
        DebugLogger.debug("[RMIDisconnectMonitor] " + string);
    }

    private static boolean debugEnabled() {
        return debugDisconnectMonitor.isEnabled() || DebugLogger.isDebugEnabled();
    }

    static {
        $assertionsDisabled = !RMIBasedDisconnectMonitorImpl.class.desiredAssertionStatus();
        debugDisconnectMonitor = Debug.getCategory((String)"weblogic.cluster.leasing.DisconnectMonitor");
        DEBUG = RMIBasedDisconnectMonitorImpl.debugEnabled();
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private static final class Factory {
        static final RMIBasedDisconnectMonitorImpl THE_ONE = new RMIBasedDisconnectMonitorImpl();

        private Factory() {
        }
    }
}

