/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import weblogic.cluster.leasing.databaseless.ClusterLeader;
import weblogic.cluster.leasing.databaseless.LeaseTableUpdateException;
import weblogic.cluster.leasing.databaseless.LeaseTableUpdateMessage;
import weblogic.cluster.leasing.databaseless.LeaseView;

public class ReplicatedLeaseTable
implements Map {
    private ClusterLeader leader;
    private LeaseView leaseView;
    private Map localMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    ReplicatedLeaseTable(ClusterLeader clusterLeader, LeaseView leaseView) {
        this.leader = clusterLeader;
        this.leaseView = leaseView;
        this.localMap = leaseView.getLeaseTableReplica();
    }

    public Object put(Object object, Object object2) {
        if (!$assertionsDisabled && this.leader == null) {
            throw new AssertionError();
        }
        if (object2 != null && object2.equals(this.localMap.get(object))) {
            return this.localMap.put(object, object2);
        }
        LeaseTableUpdateMessage leaseTableUpdateMessage = LeaseTableUpdateMessage.createPutMessage(this.leader.getLeaderInformation(), this.leaseView.getVersionNumber() + 1L, (Serializable)object, (Serializable)object2);
        if (this.leader.sendGroupMessage(leaseTableUpdateMessage)) {
            this.leaseView.incrementVersionNumber();
            return this.localMap.put(object, object2);
        }
        throw new LeaseTableUpdateException("Unable to send lease table PUT to remote servers");
    }

    public Object remove(Object object) {
        if (!$assertionsDisabled && this.leader == null) {
            throw new AssertionError();
        }
        LeaseTableUpdateMessage leaseTableUpdateMessage = LeaseTableUpdateMessage.createRemoveMessage(this.leader.getLeaderInformation(), this.leaseView.getVersionNumber() + 1L, (Serializable)object);
        if (this.leader.sendGroupMessage(leaseTableUpdateMessage)) {
            this.leaseView.incrementVersionNumber();
            return this.localMap.remove(object);
        }
        throw new LeaseTableUpdateException("Unable to send lease table REMOVE to remote servers");
    }

    public void putAll(Map map) {
        this.localMap.putAll(map);
    }

    public void clear() {
        this.localMap.clear();
    }

    public Set keySet() {
        return this.localMap.keySet();
    }

    public Collection values() {
        return this.localMap.values();
    }

    public Set entrySet() {
        return this.localMap.entrySet();
    }

    public int size() {
        return this.localMap.size();
    }

    public boolean isEmpty() {
        return this.localMap.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.localMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.localMap.containsValue(object);
    }

    public Object get(Object object) {
        return this.localMap.get(object);
    }

    static {
        $assertionsDisabled = !ReplicatedLeaseTable.class.desiredAssertionStatus();
    }
}

