/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.leasing.databaseless;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import weblogic.cluster.ClusterLogger;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.cluster.leasing.databaseless.EnvironmentFactory;
import weblogic.cluster.leasing.databaseless.MachineFailureEvent;
import weblogic.cluster.leasing.databaseless.ServerFailureDetector;
import weblogic.cluster.leasing.databaseless.ServerFailureEvent;
import weblogic.cluster.leasing.databaseless.ServerFailureListener;
import weblogic.cluster.messaging.internal.BaseClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageEndPoint;
import weblogic.cluster.messaging.internal.ClusterMessageFactory;
import weblogic.cluster.messaging.internal.ClusterMessageSender;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.MachineState;
import weblogic.cluster.messaging.internal.MessageDeliveryFailureListener;
import weblogic.cluster.messaging.internal.RMIClusterMessageEndPointImpl;
import weblogic.cluster.messaging.internal.SRMResult;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.cluster.messaging.internal.ServerInformationImpl;
import weblogic.jndi.Environment;
import weblogic.management.configuration.DatabaseLessLeasingBasisMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MachineMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.URLManager;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManagerFactory;

public final class ServerFailureDetectorImpl
implements ServerFailureDetector,
DisconnectListener,
MessageDeliveryFailureListener,
ClusterMembersChangeListener {
    private static final AuthenticatedSubject kernelId;
    private static final ClusterMessage PING_REQUEST;
    private static final int PING_PERIOD = 10000;
    private static final int NODEMANAGER_QUERY_DELAY = 3000;
    private static final DebugCategory debugFailureDetector;
    private static final boolean DEBUG;
    private ClusterMessageEndPoint remote;
    private ServerInformation serverInfo;
    private ServerFailureListener listener;
    private boolean nmRetryTimerRunning;
    private boolean stopped;
    private Timer pingTimer;
    private long lastStateCheckTime;
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized void start(ServerInformation serverInformation, ServerFailureListener serverFailureListener) {
        if (DEBUG) {
            ServerFailureDetectorImpl.debug("--- starting server failure detector for " + serverInformation.getServerName());
        }
        this.serverInfo = serverInformation;
        this.listener = serverFailureListener;
        this.stopped = false;
        this.nmRetryTimerRunning = false;
        this.pingTimer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)new PingTimer(), 10000L, 10000L);
        this.registerForDisconnect();
        ClusterMessageFactory.getInstance().registerMessageDeliveryFailureListener(this);
        ClusterService.getClusterService().addClusterMembersListener(this);
    }

    private static ServerInformation createLocalServerInformation() {
        return new ServerInformationImpl(ClusterService.getClusterService().getLocalMember());
    }

    public synchronized boolean stop() {
        block3: {
            if (this.stopped) {
                return false;
            }
            this.stopped = true;
            this.pingTimer.cancel();
            ClusterMessageFactory.getInstance().removeMessageDeliveryFailureListener(this);
            ClusterService.getClusterService().removeClusterMembersListener(this);
            try {
                DisconnectMonitorListImpl.getDisconnectMonitor().removeDisconnectListener((Remote)this.remote, (DisconnectListener)this);
            }
            catch (DisconnectMonitorUnavailableException disconnectMonitorUnavailableException) {
                if (!DEBUG) break block3;
                ServerFailureDetectorImpl.debug("unable to stop !");
                disconnectMonitorUnavailableException.printStackTrace();
            }
        }
        return true;
    }

    private void registerForDisconnect() {
        try {
            DatabaseLessLeasingBasisMBean databaseLessLeasingBasisMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster().getDatabaseLessLeasingBasis();
            Environment environment = new Environment();
            environment.setProviderUrl(URLManager.findAdministrationURL(this.serverInfo.getServerName()));
            environment.setRequestTimeout(databaseLessLeasingBasisMBean.getMessageDeliveryTimeout());
            this.remote = (ClusterMessageEndPoint)PortableRemoteObject.narrow((Object)environment.getInitialReference(RMIClusterMessageEndPointImpl.class), (Class)ClusterMessageEndPoint.class);
            DisconnectMonitorListImpl.getDisconnectMonitor().addDisconnectListener((Remote)this.remote, (DisconnectListener)this);
            if (DEBUG) {
                ServerFailureDetectorImpl.debug("registered for disconnect events from " + this.serverInfo.getServerName());
            }
        }
        catch (DisconnectMonitorUnavailableException disconnectMonitorUnavailableException) {
            throw new AssertionError((Object)("Unable to register with the leader for disconnects!" + (Object)((Object)disconnectMonitorUnavailableException)));
        }
        catch (UnknownHostException unknownHostException) {
            this.onDisconnect(null);
        }
        catch (NamingException namingException) {
            this.onDisconnect(null);
        }
    }

    private static void debug(String string) {
        DebugLogger.debug("[ServerFailureDetector] " + string);
    }

    public synchronized void onDisconnect(DisconnectEvent disconnectEvent) {
        if (!this.stateCheckNeeded(disconnectEvent)) {
            return;
        }
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(this.serverInfo.getServerName());
        if (!$assertionsDisabled && serverMBean == null) {
            throw new AssertionError();
        }
        MachineState machineState = ServerFailureDetectorImpl.getState(serverMBean);
        if (!this.isServerDead(machineState)) {
            this.lastStateCheckTime = System.currentTimeMillis();
            return;
        }
        long l = serverMBean.getCluster().getDatabaseLessLeasingBasis().getFenceTimeout() * 1000;
        if (machineState.isMachineUnavailable() && l > 0L) {
            if (DEBUG) {
                ServerFailureDetectorImpl.debug("unable to reach the NodeManager for the server " + serverMBean.getName() + ". Fence timeout is " + l + "ms");
            }
            this.nmRetryTimerRunning = true;
            TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)new NMRetryTimer(), l);
        } else {
            this.invokeListener(machineState);
        }
    }

    private void invokeListener(MachineState machineState) {
        if (DEBUG) {
            ServerFailureDetectorImpl.debug("Invoking onServerFailure() for " + this.serverInfo.getServerName());
        }
        if (this.stop()) {
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new ListenerRunnable(this.listener, this.serverInfo, machineState));
        }
    }

    private boolean stateCheckNeeded(DisconnectEvent disconnectEvent) {
        if (this.stopped || this.nmRetryTimerRunning) {
            return false;
        }
        String string = this.getConfiguredMachine().getNodeManager().getNMType();
        if ("plain".equalsIgnoreCase(string) || "ssl".equalsIgnoreCase(string)) {
            return true;
        }
        return disconnectEvent != null || System.currentTimeMillis() - this.lastStateCheckTime >= 3000L;
    }

    private static MachineState getState(ServerMBean serverMBean) {
        MachineMBean machineMBean;
        Object object;
        SRMResult sRMResult = EnvironmentFactory.getServerReachabilityMajorityService().getLastSRMResult();
        if (sRMResult != null) {
            object = sRMResult.getCurrentMachine(serverMBean.getName());
            DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            if (DEBUG) {
                ClusterLogger.logDebug((String)("SRM returned " + (String)object + " for " + serverMBean.getName()));
            }
            machineMBean = domainMBean.lookupMachine((String)object);
        } else {
            if (DEBUG) {
                ServerFailureDetectorImpl.debug("unable to get machine for " + serverMBean.getName());
            }
            machineMBean = serverMBean.getMachine();
        }
        object = MachineState.getMachineState(machineMBean, true);
        if (DEBUG) {
            ServerFailureDetectorImpl.debug("Machine state for " + serverMBean.getName() + " is " + object);
        }
        return object;
    }

    private boolean isServerDead(MachineState machineState) {
        if (machineState.isMachineUnavailable()) {
            return true;
        }
        String string = machineState.getServerState(this.serverInfo.getServerName());
        if (DEBUG) {
            ServerFailureDetectorImpl.debug("serverstate for " + this.serverInfo.getServerName() + " is " + string);
        }
        return string != null && !string.equals("RUNNING") && !string.equals("ADMIN") && !string.equals("SUSPENDING") && !string.equals("FORCE_SUSPENDING") && !string.equals("RESUMING");
    }

    public void onMessageDeliveryFailure(String string, RemoteException remoteException) {
        if (DEBUG) {
            ServerFailureDetectorImpl.debug("received onMessageDeliveryFailure for " + string + " due to " + StackTraceUtils.throwable2StackTrace((Throwable)remoteException));
        }
        if (this.serverInfo.getServerName().equals(string)) {
            if (DEBUG) {
                ServerFailureDetectorImpl.debug("calling onDisconnect due to onMessageDeliveryFailure!");
            }
            this.onDisconnect(null);
        }
    }

    public void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        if (this.serverInfo.getServerName().equals(clusterMembersChangeEvent.getClusterMemberInfo().serverName()) && clusterMembersChangeEvent.getAction() == 1) {
            this.onDisconnect(null);
        }
    }

    private MachineMBean getConfiguredMachine() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(this.serverInfo.getServerName()).getMachine();
    }

    private static boolean debugEnabled() {
        return debugFailureDetector.isEnabled() || DebugLogger.isDebugEnabled();
    }

    static {
        $assertionsDisabled = !ServerFailureDetectorImpl.class.desiredAssertionStatus();
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        PING_REQUEST = new BaseClusterMessage(ServerFailureDetectorImpl.createLocalServerInformation(), 9);
        debugFailureDetector = Debug.getCategory((String)"weblogic.cluster.leasing.FailureDetector");
        DEBUG = ServerFailureDetectorImpl.debugEnabled();
    }

    private class NMRetryTimer
    implements TimerListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        private NMRetryTimer() {
        }

        public void timerExpired(Timer timer) {
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupServer(ServerFailureDetectorImpl.this.serverInfo.getServerName());
            if (!$assertionsDisabled && serverMBean == null) {
                throw new AssertionError();
            }
            MachineState machineState = ServerFailureDetectorImpl.getState(serverMBean);
            if (ServerFailureDetectorImpl.this.stopped || !ServerFailureDetectorImpl.this.isServerDead(machineState)) {
                ServerFailureDetectorImpl.this.nmRetryTimerRunning = false;
                return;
            }
            if (DEBUG) {
                ServerFailureDetectorImpl.debug("NMRetryTimer invoking onServerFailure() for " + serverMBean.getName());
            }
            ServerFailureDetectorImpl.this.invokeListener(machineState);
        }

        static {
            $assertionsDisabled = !(class$weblogic$cluster$leasing$databaseless$ServerFailureDetectorImpl == null ? (class$weblogic$cluster$leasing$databaseless$ServerFailureDetectorImpl = ServerFailureDetectorImpl.class$("weblogic.cluster.leasing.databaseless.ServerFailureDetectorImpl")) : class$weblogic$cluster$leasing$databaseless$ServerFailureDetectorImpl).desiredAssertionStatus();
        }
    }

    private static class ListenerRunnable
    implements Runnable {
        private final ServerFailureListener listener;
        private final ServerInformation serverInfo;
        private final MachineState machineState;

        ListenerRunnable(ServerFailureListener serverFailureListener, ServerInformation serverInformation, MachineState machineState) {
            this.listener = serverFailureListener;
            this.serverInfo = serverInformation;
            this.machineState = machineState;
        }

        public void run() {
            if (this.machineState.isMachineUnavailable()) {
                this.listener.onMachineFailure(new MachineFailureEvent(){

                    public List getFailedServers() {
                        List<String> list = new ArrayList();
                        List list2 = ListenerRunnable.this.machineState.getServerNames();
                        SRMResult sRMResult = EnvironmentFactory.getServerReachabilityMajorityService().getLastSRMResult();
                        if (sRMResult != null) {
                            String string = ListenerRunnable.this.machineState.getMachineName();
                            Iterator iterator = list2.iterator();
                            while (iterator.hasNext()) {
                                String string2 = (String)iterator.next();
                                if (!sRMResult.getCurrentMachine(string2).equals(string)) continue;
                                list.add(string2);
                            }
                        } else {
                            list = list2;
                        }
                        return list;
                    }

                    public String getMachineName() {
                        return ListenerRunnable.this.machineState.getMachineName();
                    }
                });
            } else {
                this.listener.onServerFailure(new ServerFailureEvent(){

                    public ServerInformation getServerInformation() {
                        return ListenerRunnable.this.serverInfo;
                    }
                });
            }
        }
    }

    private class PingTimer
    implements TimerListener {
        private PingTimer() {
        }

        public void timerExpired(Timer timer) {
            if (ServerFailureDetectorImpl.this.stopped) {
                timer.cancel();
                return;
            }
            ClusterMessageSender clusterMessageSender = ClusterMessageFactory.getInstance().getDefaultMessageSender();
            try {
                clusterMessageSender.send(PING_REQUEST, ServerFailureDetectorImpl.this.serverInfo);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

