/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.io.IOException;
import weblogic.cluster.messaging.internal.Connection;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.GroupImpl;
import weblogic.cluster.messaging.internal.GroupMember;
import weblogic.cluster.messaging.internal.Message;

final class AnonymousGroupImpl
extends GroupImpl {
    AnonymousGroupImpl() {
    }

    public void start() {
    }

    public void send(Message message) {
        GroupMember[] groupMemberArray = this.getMembers();
        for (int i = 0; i < groupMemberArray.length; ++i) {
            GroupMember groupMember = groupMemberArray[i];
            if (message.getServerName().equals(groupMember.getConfiguration().getServerName())) continue;
            try {
                groupMember.send(message);
                if (!DEBUG) continue;
                this.debug(message + " send ok to " + groupMember);
                continue;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
                this.removeFromRunningSet(groupMember);
                if (!DEBUG) continue;
                this.debug(message + " send failed to " + groupMember);
            }
        }
    }

    protected void performLeaderActions(Message message) {
        throw new AssertionError((Object)"local server can never perform leader actions on anonymous group !");
    }

    public void forward(Message message, Connection connection) {
        throw new AssertionError((Object)"forward cannot be called on anonymous groups !");
    }

    protected synchronized void startDiscoveryIfNeeded() {
    }

    protected void debug(String string) {
        Environment.getLogService().debug("[AnonymousGroup] [" + this.toString() + "] " + string);
    }
}

