/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.util.ArrayList;
import java.util.Iterator;
import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageReceiver;
import weblogic.cluster.messaging.internal.ClusterMessageSender;
import weblogic.cluster.messaging.internal.ClusterMessageSenderWrapper;
import weblogic.cluster.messaging.internal.MessageDeliveryFailureListener;
import weblogic.cluster.messaging.internal.RMIClusterMessageSenderImpl;

public class ClusterMessageFactory {
    private final ArrayList messageReceivers = new ArrayList();
    private ClusterMessageSenderWrapper defaultSender;

    public static ClusterMessageFactory getInstance() {
        return Factory.THE_ONE;
    }

    public synchronized ClusterMessageSender getDefaultMessageSender() {
        if (this.defaultSender == null) {
            this.defaultSender = new ClusterMessageSenderWrapper(RMIClusterMessageSenderImpl.getInstance());
        }
        return this.defaultSender;
    }

    public ClusterMessageSender getOneWayMessageSender() {
        return RMIClusterMessageSenderImpl.getOneWay();
    }

    public synchronized void registerReceiver(ClusterMessageReceiver clusterMessageReceiver) {
        this.messageReceivers.add(clusterMessageReceiver);
    }

    public synchronized ClusterMessageReceiver getMessageReceiver(ClusterMessage clusterMessage) {
        Iterator iterator = this.messageReceivers.iterator();
        while (iterator.hasNext()) {
            ClusterMessageReceiver clusterMessageReceiver = (ClusterMessageReceiver)iterator.next();
            if (!clusterMessageReceiver.accept(clusterMessage)) continue;
            return clusterMessageReceiver;
        }
        return null;
    }

    public void registerMessageDeliveryFailureListener(MessageDeliveryFailureListener messageDeliveryFailureListener) {
        this.getDefaultMessageSender();
        this.defaultSender.addMessageDeliveryFailureListener(messageDeliveryFailureListener);
    }

    public void removeMessageDeliveryFailureListener(MessageDeliveryFailureListener messageDeliveryFailureListener) {
        this.getDefaultMessageSender();
        this.defaultSender.removeMessageDeliveryFailureListener(messageDeliveryFailureListener);
    }

    private static final class Factory {
        static final ClusterMessageFactory THE_ONE = new ClusterMessageFactory();

        private Factory() {
        }
    }
}

