/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.cluster.messaging.internal.ClusterResponse;
import weblogic.cluster.messaging.internal.ServerInformation;

public class ClusterMessageProcessingException
extends RemoteException {
    private final ClusterResponse[] responses;
    private final HashMap failedServers;

    public ClusterMessageProcessingException(Exception exception) {
        super(exception.getMessage(), exception);
        this.responses = null;
        this.failedServers = null;
    }

    public ClusterMessageProcessingException(String string) {
        super(string);
        this.responses = null;
        this.failedServers = null;
    }

    public ClusterMessageProcessingException(ClusterResponse[] clusterResponseArray, HashMap hashMap) {
        super(ClusterMessageProcessingException.getReason(hashMap));
        this.responses = clusterResponseArray;
        this.failedServers = hashMap;
    }

    public ClusterResponse[] getResponses() {
        return this.responses;
    }

    public HashMap getFailedServers() {
        return this.failedServers;
    }

    private static String getReason(Map map) {
        if (map == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            ServerInformation serverInformation = (ServerInformation)iterator.next();
            stringBuffer.append("Server '" + serverInformation.getServerName() + "' failed due to '" + map.get(serverInformation) + "'\n");
        }
        return stringBuffer.toString();
    }
}

