/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.cluster.messaging.internal.ClusterMessage;
import weblogic.cluster.messaging.internal.ClusterMessageProcessingException;
import weblogic.cluster.messaging.internal.ClusterMessageSender;
import weblogic.cluster.messaging.internal.ClusterResponse;
import weblogic.cluster.messaging.internal.DebugLogger;
import weblogic.cluster.messaging.internal.MessageDeliveryFailureListener;
import weblogic.cluster.messaging.internal.ServerInformation;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.WorkManagerFactory;

public final class ClusterMessageSenderWrapper
implements ClusterMessageSender {
    private static final DebugCategory debugClusterMessaging = Debug.getCategory((String)"weblogic.cluster.leasing.ClusterMessaging");
    private static final boolean DEBUG = ClusterMessageSenderWrapper.debugEnabled();
    private ClusterMessageSender delegate;
    private ArrayList listeners = new ArrayList();

    ClusterMessageSenderWrapper(ClusterMessageSender clusterMessageSender) {
        this.delegate = clusterMessageSender;
    }

    synchronized void addMessageDeliveryFailureListener(MessageDeliveryFailureListener messageDeliveryFailureListener) {
        this.listeners.add(messageDeliveryFailureListener);
    }

    synchronized void removeMessageDeliveryFailureListener(MessageDeliveryFailureListener messageDeliveryFailureListener) {
        this.listeners.remove(messageDeliveryFailureListener);
    }

    public ClusterResponse[] send(ClusterMessage clusterMessage, ServerInformation[] serverInformationArray) throws ClusterMessageProcessingException {
        try {
            return this.delegate.send(clusterMessage, serverInformationArray);
        }
        catch (ClusterMessageProcessingException clusterMessageProcessingException) {
            this.invokeListeners(clusterMessageProcessingException);
            throw clusterMessageProcessingException;
        }
    }

    public ClusterResponse send(ClusterMessage clusterMessage, ServerInformation serverInformation) throws RemoteException {
        try {
            return this.delegate.send(clusterMessage, serverInformation);
        }
        catch (RemoteException remoteException) {
            this.invokeListeners(serverInformation.getServerName(), remoteException);
            throw remoteException;
        }
    }

    public ClusterResponse send(ClusterMessage clusterMessage, String string) throws RemoteException {
        try {
            return this.delegate.send(clusterMessage, string);
        }
        catch (RemoteException remoteException) {
            this.invokeListeners(string, remoteException);
            throw remoteException;
        }
    }

    private synchronized void invokeListeners(ClusterMessageProcessingException clusterMessageProcessingException) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        HashMap hashMap = clusterMessageProcessingException.getFailedServers();
        if (hashMap == null || hashMap.size() == 0) {
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            ServerInformation serverInformation = (ServerInformation)iterator.next();
            this.invokeListeners(serverInformation.getServerName(), (RemoteException)hashMap.get(serverInformation));
        }
    }

    private synchronized void invokeListeners(String string, RemoteException remoteException) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        MessageDeliveryFailureListener[] messageDeliveryFailureListenerArray = new MessageDeliveryFailureListener[this.listeners.size()];
        this.listeners.toArray(messageDeliveryFailureListenerArray);
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new ListenerInvocationRunnable(messageDeliveryFailureListenerArray, string, remoteException));
    }

    private static boolean debugEnabled() {
        return debugClusterMessaging.isEnabled() || DebugLogger.isDebugEnabled();
    }

    private static void debug(String string) {
        DebugLogger.debug("[MessageSenderWrapper] " + string);
    }

    private static class ListenerInvocationRunnable
    implements Runnable {
        private final MessageDeliveryFailureListener[] listeners;
        private final String serverName;
        private final RemoteException re;

        ListenerInvocationRunnable(MessageDeliveryFailureListener[] messageDeliveryFailureListenerArray, String string, RemoteException remoteException) {
            this.listeners = messageDeliveryFailureListenerArray;
            this.serverName = string;
            this.re = remoteException;
        }

        public void run() {
            for (int i = 0; i < this.listeners.length; ++i) {
                MessageDeliveryFailureListener messageDeliveryFailureListener = this.listeners[i];
                if (DEBUG) {
                    ClusterMessageSenderWrapper.debug("invoking onMessageDeliveryFailure on " + this.serverName);
                }
                messageDeliveryFailureListener.onMessageDeliveryFailure(this.serverName, this.re);
            }
        }
    }
}

