/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import weblogic.cluster.messaging.internal.Connection;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.Message;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;
import weblogic.utils.io.ChunkedDataOutputStream;

public class ConnectionImpl
implements Connection {
    protected static final boolean DEBUG = Environment.DEBUG;
    private Socket socket;
    private boolean isDead;
    private ServerConfigurationInformation info;
    private String serverId;
    private static final String delimiter = "-";

    public ConnectionImpl(ServerConfigurationInformation serverConfigurationInformation) {
        this.info = serverConfigurationInformation;
        if (serverConfigurationInformation != null && serverConfigurationInformation.getCreationTime() > 1L) {
            this.serverId = serverConfigurationInformation.getServerName() + delimiter + serverConfigurationInformation.getCreationTime();
        }
    }

    public ConnectionImpl(Socket socket) throws IOException {
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
    }

    protected OutputStream getOutputStream() throws IOException {
        try {
            return this.socket.getOutputStream();
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public final boolean isDead() {
        return this.isDead;
    }

    public final ServerConfigurationInformation getConfiguration() {
        return this.info;
    }

    public void send(Message message) throws IOException {
        ChunkedDataOutputStream chunkedDataOutputStream = new ChunkedDataOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            this.skipHeader(chunkedDataOutputStream);
            objectOutputStream = new ObjectOutputStream((OutputStream)chunkedDataOutputStream);
            objectOutputStream.writeObject(message);
            int n = chunkedDataOutputStream.getSize();
            if (DEBUG) {
                this.debug("writing length " + n);
            }
            chunkedDataOutputStream.setPosition(0);
            this.writeHeader(chunkedDataOutputStream);
            chunkedDataOutputStream.writeInt(n);
            if (DEBUG) {
                this.debug("writing data " + chunkedDataOutputStream.getBuffer());
            }
            chunkedDataOutputStream.writeTo(this.getOutputStream());
            if (objectOutputStream != null) {
                this.close(objectOutputStream);
            }
        }
        catch (IOException iOException) {
            try {
                this.close();
                throw iOException;
            }
            catch (Throwable throwable) {
                if (objectOutputStream != null) {
                    this.close(objectOutputStream);
                }
                throw throwable;
            }
        }
    }

    private void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void skipHeader(ChunkedDataOutputStream chunkedDataOutputStream) {
        chunkedDataOutputStream.skip(Message.HEADER_LENGTH);
    }

    protected void writeHeader(ChunkedDataOutputStream chunkedDataOutputStream) {
        chunkedDataOutputStream.writeBytes("CLUSTER-BROADCAST");
    }

    protected void debug(String string) {
        Environment.getLogService().debug("[Connection][" + this.info + "]" + string);
    }

    public void handleIncomingMessage(InputStream inputStream) throws IOException {
        Message message;
        if (DEBUG) {
            this.debug("reading message from input stream ...");
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            message = (Message)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        finally {
            if (objectInputStream != null) {
                this.close(objectInputStream);
            }
        }
        if (DEBUG) {
            this.debug("received message: " + message);
        }
        if (this.info == null) {
            this.info = message.getForwardingServer();
        }
        this.serverId = message.getForwardingServer().getServerName() + delimiter + message.getForwardingServer().getCreationTime();
        if (DEBUG) {
            this.debug("dispatching to group manager with serverId: " + this.serverId);
        }
        Environment.executeDispatchMessage(new Runnable(){

            public void run() {
                Environment.getGroupManager().handleMessage(message, ConnectionImpl.this);
            }
        });
    }

    public String getServerId() {
        return this.serverId;
    }

    public void close() {
        this.isDead = true;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void setSocket(Socket socket) throws IOException {
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
    }
}

