/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.security.AccessController;
import java.util.Timer;
import java.util.TimerTask;
import weblogic.cluster.messaging.internal.ConfiguredServersMonitor;
import weblogic.cluster.messaging.internal.ConnectionManager;
import weblogic.cluster.messaging.internal.GroupManager;
import weblogic.cluster.messaging.internal.GroupManagerImpl;
import weblogic.cluster.messaging.internal.HttpPingRoutineImpl;
import weblogic.cluster.messaging.internal.LogService;
import weblogic.cluster.messaging.internal.LogServiceImpl;
import weblogic.cluster.messaging.internal.PingRoutine;
import weblogic.cluster.messaging.internal.PingRoutineImpl;
import weblogic.cluster.messaging.internal.PropertyService;
import weblogic.cluster.messaging.internal.PropertyServiceImpl;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class Environment {
    public static final boolean HTTP_PING = Environment.initProperty("weblogic.unicast.HttpPing");
    public static final boolean DEBUG = Environment.initProperty("weblogic.debug.DebugUnicastMessaging");
    private static ConfiguredServersMonitor configuration;
    private static ConnectionManager connectionManager;
    private static LogService logService;
    private static PropertyService propertyService;
    private static WorkManager dispatchWM;
    private static WorkManager forwardingWM;
    private static final AuthenticatedSubject kernelId;

    private static boolean initProperty(String string) {
        try {
            return Boolean.getBoolean(string);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static synchronized void initialize(ConfiguredServersMonitor configuredServersMonitor, ConnectionManager connectionManager) {
        Environment.setLogService(LogServiceImpl.getInstance());
        Environment.initialize(configuredServersMonitor, connectionManager, PropertyServiceImpl.getInstance());
    }

    public static synchronized boolean isInitialized() {
        return configuration != null;
    }

    public static synchronized void initialize(ConfiguredServersMonitor configuredServersMonitor, ConnectionManager connectionManager, PropertyService propertyService) {
        if (configuration != null) {
            throw new AssertionError((Object)"double initialization of unicast messaging!");
        }
        configuration = configuredServersMonitor;
        Environment.connectionManager = connectionManager;
        Environment.propertyService = propertyService;
        ClusterMBean clusterMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        if (clusterMBean.isMessageOrderingEnabled()) {
            dispatchWM = WorkManagerFactory.getInstance().findOrCreate("weblogic.unicast.DispatchWorkManager", 1, 1);
            forwardingWM = WorkManagerFactory.getInstance().findOrCreate("weblogic.unicast.ForwardingWorkManager", 1, 1);
        } else {
            dispatchWM = WorkManagerFactory.getInstance().findOrCreate("weblogic.unicast.DispatchWorkManager", 5, -1);
            forwardingWM = WorkManagerFactory.getInstance().findOrCreate("weblogic.unicast.ForwardingWorkManager", 5, -1);
        }
    }

    public static void setLogService(LogService logService) {
        Environment.logService = logService;
    }

    public static ConfiguredServersMonitor getConfiguredServersMonitor() {
        return configuration;
    }

    public static void executeForwardMessage(Runnable runnable) {
        forwardingWM.schedule(runnable);
    }

    public static void executeDispatchMessage(Runnable runnable) {
        dispatchWM.schedule(runnable);
    }

    public static Object startTimer(final Runnable runnable, int n, int n2) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                runnable.run();
            }
        }, n, (long)n2);
        return timer;
    }

    public static PingRoutine getPingRoutine() {
        if (HTTP_PING) {
            return HttpPingRoutineImpl.getInstance();
        }
        return PingRoutineImpl.getInstance();
    }

    public static void stopTimer(Object object) {
        ((Timer)object).cancel();
    }

    public static ConnectionManager getConnectionManager() {
        return connectionManager;
    }

    public static GroupManager getGroupManager() {
        return GroupManagerImpl.getInstance();
    }

    public static LogService getLogService() {
        return logService;
    }

    public static PropertyService getPropertyService() {
        return propertyService;
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

