/*
 * Decompiled with CFR 0.152.
 */
package weblogic.cluster.messaging.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import weblogic.cluster.messaging.internal.Connection;
import weblogic.cluster.messaging.internal.Environment;
import weblogic.cluster.messaging.internal.Group;
import weblogic.cluster.messaging.internal.GroupManagerImpl;
import weblogic.cluster.messaging.internal.GroupMember;
import weblogic.cluster.messaging.internal.GroupMemberImpl;
import weblogic.cluster.messaging.internal.Message;
import weblogic.cluster.messaging.internal.PingRoutine;
import weblogic.cluster.messaging.internal.ServerConfigurationInformation;

class GroupImpl
implements Group {
    protected static final boolean DEBUG = Environment.DEBUG;
    protected final Set configurationSet;
    protected final TreeSet members = new TreeSet();
    protected final Set unreliableSet = new HashSet();
    protected Object handle;

    private static boolean initProperty(String string) {
        try {
            return Boolean.getBoolean(string);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    GroupImpl() {
        this.configurationSet = new HashSet();
    }

    public GroupImpl(Set set) {
        this.configurationSet = set;
    }

    public synchronized GroupMember[] getMembers() {
        GroupMember[] groupMemberArray = new GroupMember[this.members.size()];
        this.members.toArray(groupMemberArray);
        return groupMemberArray;
    }

    public synchronized GroupMember[] getUnReliableMembers() {
        GroupMember[] groupMemberArray = new GroupMember[this.unreliableSet.size()];
        this.unreliableSet.toArray(groupMemberArray);
        return groupMemberArray;
    }

    protected synchronized ServerConfigurationInformation[] getConfigurations() {
        ServerConfigurationInformation[] serverConfigurationInformationArray = new ServerConfigurationInformation[this.configurationSet.size()];
        this.configurationSet.toArray(serverConfigurationInformationArray);
        return serverConfigurationInformationArray;
    }

    public synchronized void addToConfigurationSet(ServerConfigurationInformation serverConfigurationInformation) {
        this.configurationSet.add(serverConfigurationInformation);
    }

    public synchronized void removeFromConfigurationSet(ServerConfigurationInformation serverConfigurationInformation) {
        this.configurationSet.remove(serverConfigurationInformation);
    }

    synchronized void addToRunningSet(GroupMember groupMember) {
        this.members.add(groupMember);
        this.configurationSet.remove(groupMember.getConfiguration());
        if (DEBUG) {
            this.debug("addToRunningSet " + groupMember);
        }
    }

    protected void debug(String string) {
        Environment.getLogService().debug("[Group] [" + this.toString() + "] " + string);
    }

    public synchronized GroupMember removeFromRunningSet(GroupMember groupMember) {
        if (DEBUG) {
            this.debug("removeFromRunningSet " + groupMember);
        }
        this.members.remove(groupMember);
        this.configurationSet.add(groupMember.getConfiguration());
        this.startDiscoveryIfNeeded();
        if (this.members.size() == 0) {
            return null;
        }
        return (GroupMember)this.members.first();
    }

    public synchronized void removeFromUnReliableSet(GroupMember groupMember) {
        if (DEBUG) {
            this.debug("removeFromUnReliableSet " + groupMember);
        }
        this.unreliableSet.remove(groupMember);
        this.configurationSet.add(groupMember.getConfiguration());
        this.startDiscoveryIfNeeded();
    }

    private synchronized boolean isLocalServerSeniormost() {
        GroupMember groupMember = GroupManagerImpl.getInstance().getLocalMember();
        return groupMember.equals(this.members.first());
    }

    protected synchronized void startDiscoveryIfNeeded() {
        if (this.handle != null) {
            return;
        }
        if (this.members.size() < 1) {
            throw new AssertionError((Object)"local group should have atleast one member!");
        }
        if (this.members.size() == 1 || this.isLocalServerSeniormost()) {
            this.handle = this.startTimer();
        }
    }

    public void send(Message message) throws IOException {
        GroupMember groupMember = GroupManagerImpl.getInstance().getLocalMember();
        GroupMember[] groupMemberArray = this.getMembers();
        if (groupMemberArray.length == 0) {
            throw new AssertionError((Object)"LocalGroup should atleast have the local server!");
        }
        if (groupMember.equals(groupMemberArray[0])) {
            if (DEBUG) {
                this.debug("we are the seniormost. Send message to group");
            }
            this.performLeaderActions(message);
        } else {
            GroupMember groupMember2 = groupMemberArray[0];
            this.sendToLeader(groupMember2, message);
        }
    }

    protected void sendToLeader(GroupMember groupMember, Message message) {
        GroupMember groupMember2 = GroupManagerImpl.getInstance().getLocalMember();
        while (true) {
            try {
                if (groupMember2.equals(groupMember)) {
                    this.performLeaderActions(message);
                    return;
                }
                if (DEBUG) {
                    this.debug("Send [" + message + "] to leader -> " + groupMember);
                }
                if (!message.getServerName().equals(groupMember.getConfiguration().getServerName())) {
                    groupMember.send(message);
                    if (groupMember.getLastArrivalTime() > 0L && System.currentTimeMillis() - groupMember.getLastArrivalTime() > Environment.getPropertyService().getHeartbeatTimeoutMillis()) {
                        if (DEBUG) {
                            this.debug("add Leader " + groupMember + " to unreliableSet");
                        }
                        this.unreliableSet.add(groupMember);
                        throw new UnReliableServerException(groupMember.getConfiguration().getServerName() + " missed heartbeats !");
                    }
                }
                if (DEBUG) {
                    this.debug("send ok to " + groupMember);
                }
                return;
            }
            catch (IOException iOException) {
                groupMember = this.removeFromRunningSet(groupMember);
                if (groupMember == null) {
                    return;
                }
                if (!DEBUG) continue;
                this.debug("send failed to " + groupMember);
                continue;
            }
            catch (UnReliableServerException unReliableServerException) {
                groupMember = this.removeFromRunningSet(groupMember);
                if (groupMember == null) {
                    return;
                }
                groupMember.setLastMessageArrivalTime(System.currentTimeMillis() + Environment.getPropertyService().getHeartbeatTimeoutMillis());
                if (!DEBUG) continue;
                this.debug("send failed to " + groupMember);
                continue;
            }
            break;
        }
    }

    protected void performLeaderActions(Message message) {
        if (DEBUG) {
            this.debug("we are the seniormost. Send message to group");
        }
        GroupMember groupMember = GroupManagerImpl.getInstance().getLocalMember();
        GroupMember[] groupMemberArray = this.getMembers();
        for (int i = 0; i < groupMemberArray.length; ++i) {
            GroupMember groupMember2 = groupMemberArray[i];
            if (groupMember.equals(groupMember2)) continue;
            try {
                groupMember2.send(message);
                if (!DEBUG) continue;
                this.debug(message + " send ok to " + groupMember2);
                continue;
            }
            catch (IOException iOException) {
                this.removeFromRunningSet(groupMember2);
                if (!DEBUG) continue;
                this.debug(message + " send failed to " + groupMember2);
            }
        }
        GroupMember[] groupMemberArray2 = this.getUnReliableMembers();
        for (int i = 0; i < groupMemberArray2.length; ++i) {
            GroupMember groupMember3 = groupMemberArray2[i];
            try {
                groupMember3.send(message);
                if (!DEBUG) continue;
                this.debug(message + " send ok to unreliable member " + groupMember3);
                continue;
            }
            catch (IOException iOException) {
                this.removeFromUnReliableSet(groupMember3);
                if (!DEBUG) continue;
                this.debug(message + " send failed to " + groupMember3);
            }
        }
        GroupManagerImpl.getInstance().sendRemoteGroups(message);
    }

    public boolean isLocal() {
        return true;
    }

    public void start() {
        this.handle = this.startTimer();
    }

    public void stop() {
        if (this.handle == null) {
            return;
        }
        Environment.stopTimer(this.handle);
    }

    private Object startTimer() {
        int n = Environment.getPropertyService().getDiscoveryPeriodMillis();
        return Environment.startTimer(new LocalGroupMonitor(), 0, n);
    }

    public synchronized ServerConfigurationInformation getConfigInformation(String string) {
        ServerConfigurationInformation serverConfigurationInformation;
        Comparable comparable;
        Iterator iterator = this.configurationSet.iterator();
        while (iterator.hasNext()) {
            comparable = (ServerConfigurationInformation)iterator.next();
            if (!comparable.getServerName().equals(string)) continue;
            return comparable;
        }
        iterator = this.members.iterator();
        while (iterator.hasNext()) {
            comparable = (GroupMember)iterator.next();
            serverConfigurationInformation = comparable.getConfiguration();
            if (!serverConfigurationInformation.getServerName().equals(string)) continue;
            return serverConfigurationInformation;
        }
        iterator = this.unreliableSet.iterator();
        while (iterator.hasNext()) {
            comparable = (GroupMember)iterator.next();
            serverConfigurationInformation = comparable.getConfiguration();
            if (!serverConfigurationInformation.getServerName().equals(string)) continue;
            return serverConfigurationInformation;
        }
        return null;
    }

    public synchronized GroupMember findOrCreateGroupMember(ServerConfigurationInformation serverConfigurationInformation, long l) {
        GroupMember groupMember;
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            groupMember = (GroupMember)iterator.next();
            if (!groupMember.getConfiguration().equals(serverConfigurationInformation)) continue;
            return groupMember;
        }
        groupMember = new GroupMemberImpl(serverConfigurationInformation, l);
        if (this.unreliableSet.contains(groupMember)) {
            this.removeFromUnReliableSet(groupMember);
        }
        this.addToRunningSet(groupMember);
        return groupMember;
    }

    private boolean isMessageFromRemoteGroup(Connection connection) {
        return this.getConfigInformation(connection.getConfiguration().getServerName()) == null;
    }

    public void forward(Message message, Connection connection) {
        int n;
        GroupMember groupMember = GroupManagerImpl.getInstance().getLocalMember();
        GroupMember[] groupMemberArray = this.getMembers();
        if (groupMemberArray.length == 0) {
            throw new AssertionError((Object)"LocalGroup should atleast have the local server!");
        }
        if (groupMember.equals(groupMemberArray[0]) || this.isMessageFromRemoteGroup(connection)) {
            if (DEBUG) {
                this.debug("we are the seniormost. Send message to group. connection.getConfiguration()=" + connection.getConfiguration().getServerName());
            }
            for (int i = 0; i < groupMemberArray.length; ++i) {
                GroupMember groupMember2 = groupMemberArray[i];
                if (groupMember.equals(groupMember2) || groupMember2.getConfiguration().equals(connection.getConfiguration())) continue;
                try {
                    groupMember2.send(message);
                    if (!DEBUG) continue;
                    this.debug(message + " forward ok to " + groupMember2);
                    continue;
                }
                catch (IOException iOException) {
                    this.removeFromRunningSet(groupMember2);
                    if (!DEBUG) continue;
                    this.debug(message + " forward failed to " + groupMember2);
                }
            }
            GroupMember[] groupMemberArray2 = this.getUnReliableMembers();
            for (n = 0; n < groupMemberArray2.length; ++n) {
                GroupMember groupMember3 = groupMemberArray2[n];
                if (groupMember.equals(groupMember3) || groupMember3.getConfiguration().equals(connection.getConfiguration())) continue;
                try {
                    groupMember3.send(message);
                    if (!DEBUG) continue;
                    this.debug(message + " forward ok to unreliable member " + groupMember3);
                    continue;
                }
                catch (IOException iOException) {
                    this.removeFromUnReliableSet(groupMember3);
                    if (!DEBUG) continue;
                    this.debug(message + " send failed to " + groupMember3);
                }
            }
        }
        boolean bl = this.getConfigInformation(message.getServerName()) != null;
        int n2 = n = this.getConfigInformation(connection.getConfiguration().getServerName()) != null ? 1 : 0;
        if (groupMember.equals(groupMemberArray[0]) && bl && n != 0) {
            GroupManagerImpl.getInstance().sendRemoteGroups(message);
        }
    }

    public String toString() {
        return "LocalGroup [" + this.members + "]";
    }

    private static class UnReliableServerException
    extends Exception {
        UnReliableServerException(String string) {
            super(string);
        }
    }

    private class LocalGroupMonitor
    implements Runnable {
        private int discoveryAttempts;
        private boolean remoteGroupMonitoring;

        private LocalGroupMonitor() {
        }

        public void run() {
            if (GroupImpl.this.isLocalServerSeniormost()) {
                ServerConfigurationInformation[] serverConfigurationInformationArray;
                if (this.discoveryAttempts > 2 && !this.remoteGroupMonitoring) {
                    GroupManagerImpl.getInstance().startRemoteGroups();
                    this.remoteGroupMonitoring = true;
                    if (DEBUG) {
                        GroupImpl.this.debug("starting remote group discovery ...");
                    }
                }
                if ((serverConfigurationInformationArray = GroupImpl.this.getConfigurations()) == null || serverConfigurationInformationArray.length == 0) {
                    return;
                }
                for (int i = 0; i < serverConfigurationInformationArray.length; ++i) {
                    GroupMemberImpl groupMemberImpl;
                    PingRoutine pingRoutine = Environment.getPingRoutine();
                    long l = pingRoutine.ping(serverConfigurationInformationArray[i]);
                    if (l <= 0L) continue;
                    if (DEBUG) {
                        GroupImpl.this.debug("discovered " + serverConfigurationInformationArray[i]);
                    }
                    if (GroupImpl.this.unreliableSet.contains(groupMemberImpl = new GroupMemberImpl(serverConfigurationInformationArray[i], l))) continue;
                    GroupImpl.this.addToRunningSet(groupMemberImpl);
                }
                ++this.discoveryAttempts;
            } else {
                if (DEBUG) {
                    GroupImpl.this.debug("we are not senior anymore ! senior is " + GroupImpl.this.getMembers()[0]);
                }
                Environment.stopTimer(GroupImpl.this.handle);
                GroupImpl.this.handle = null;
                if (this.remoteGroupMonitoring) {
                    if (DEBUG) {
                        GroupImpl.this.debug("stopping remote group discovery ...");
                    }
                    Environment.getGroupManager().stopRemoteGroups();
                    this.remoteGroupMonitoring = false;
                }
            }
        }
    }
}

